/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.schedule.ui.ganttchartview.fx;

import java.util.HashMap;
import java.util.Map;
import javafx.scene.paint.Color;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.schedule.model.SchedulableEntity;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.model.IIdLabeled;

public class ScheduleViewColorsFX {
    private static final Color[] SERIES_BASE_COLORS = ScheduleViewColorsFX.initColors();
    private static final Map<Integer, Color> colorCache = new HashMap<Integer, Color>();

    private static Color[] initColors() {
        Color[] c = new Color[]{Color.rgb((int)31, (int)73, (int)125), Color.rgb((int)149, (int)55, (int)53), Color.rgb((int)119, (int)147, (int)60), Color.rgb((int)96, (int)74, (int)123), Color.rgb((int)49, (int)133, (int)156), Color.rgb((int)228, (int)108, (int)10), Color.rgb((int)0, (int)102, (int)204), Color.rgb((int)255, (int)153, (int)51), Color.rgb((int)0, (int)204, (int)0), Color.rgb((int)255, (int)80, (int)80), Color.rgb((int)153, (int)102, (int)51), Color.rgb((int)0, (int)255, (int)255)};
        return c;
    }

    public static Color getColor(int index) {
        int i = index / SERIES_BASE_COLORS.length;
        int f = index % SERIES_BASE_COLORS.length;
        Color base = SERIES_BASE_COLORS[f];
        if (i == 0) {
            return base;
        }
        Color c = colorCache.get(index);
        if (c != null) {
            return c;
        }
        int r = (int)(255.0 * base.getRed());
        int g = (int)(255.0 * base.getGreen());
        int b = (int)(255.0 * base.getBlue());
        if ((i & 1) == 1) {
            r = 255 - r;
            g = 255 - g;
            b = 255 - b;
        }
        int brightness = i / 2;
        float scale = 1.0f + 0.5f * (float)brightness;
        r = Math.round((float)r * scale) & 0xFF;
        g = Math.round((float)g * scale) & 0xFF;
        b = Math.round((float)b * scale) & 0xFF;
        Color newColor = Color.rgb((int)r, (int)g, (int)b);
        colorCache.put(index, newColor);
        return newColor;
    }

    public static Color getColor(ResourceAllocation resourceAllocation, Map<EObject, Color> objectToColor) {
        SchedulableEntity schedulableEntity = resourceAllocation.getSchedulableEntity();
        if (schedulableEntity == null) {
            return null;
        }
        IModelElement modelElement = schedulableEntity.getModelElement();
        if (!(modelElement instanceof IIdLabeled)) {
            return null;
        }
        Color color = ScheduleViewColorsFX.getColor(((IIdLabeled)modelElement).getId());
        objectToColor.put((EObject)modelElement, color);
        return color;
    }
}

