/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.schedule.ui.ganttchartview.fx;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.Slider;
import javafx.scene.control.Spinner;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.schedule.model.Schedule;
import org.fortiss.af3.schedule.model.SubSchedule;
import org.fortiss.af3.schedule.model.SystemSchedule;
import org.fortiss.af3.schedule.ui.ganttchartview.fx.ScheduleViewCanvasFX;
import org.fortiss.af3.schedule.ui.ganttchartview.fx.ScheduleViewFX;
import org.fortiss.af3.schedule.ui.ganttchartview.fx.ScheduleViewModelFX;
import org.fortiss.af3.schedule.utils.ScheduleUtils;
import org.fortiss.tooling.common.ui.javafx.layout.CompositeFXControllerBase;
import org.fortiss.tooling.common.ui.javafx.layout.ICompositeFXController;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.ui.util.SelectionUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class ScheduleViewCompositeFX
extends CompositeFXControllerBase<Node, Node>
implements ISelectionListener {
    @FXML
    private Canvas canvas;
    ScheduleViewCanvasFX canvasWrapper;
    @FXML
    private Slider slider;
    @FXML
    private ScrollBar scrollBar;
    @FXML
    private Spinner<Integer> numPeriodsSpinner;
    @FXML
    private CheckBox displayPeriodsSchedulableEntitiesCheckBox;
    @FXML
    private CheckBox displayPeriodsSchedulesCheckBox;
    @FXML
    private Pane canvasPane;
    @FXML
    private GridPane mainPane;
    private EObject scheduleContainer;
    private boolean isSelectionChangedEnabled = true;
    private FileProject fileProject;
    private ScheduleViewFX parent;
    private EContentAdapter fileProjectScheduleChangeAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            int eventType = notification.getEventType();
            Object notifier = notification.getNotifier();
            if ((eventType == 3 || eventType == 5 || eventType == 4 || eventType == 6) && notifier == ScheduleViewCompositeFX.this.scheduleContainer) {
                ScheduleViewCompositeFX.this.setSchedule();
            }
            if ((eventType == 4 || eventType == 6) && notification.getOldValue() == ScheduleViewCompositeFX.this.scheduleContainer) {
                ScheduleViewCompositeFX.this.scheduleContainer = null;
                ScheduleViewCompositeFX.this.fileProject.eAdapters().remove((Object)ScheduleViewCompositeFX.this.fileProjectScheduleChangeAdapter);
                ScheduleViewCompositeFX.this.fileProject = null;
                ScheduleViewCompositeFX.this.setSchedule();
            }
            if (ScheduleViewCompositeFX.this.scheduleContainer instanceof INamedElement && eventType == 1 && notifier == ScheduleViewCompositeFX.this.scheduleContainer) {
                ScheduleViewCompositeFX.this.updateTitle();
            }
        }
    };

    public ScheduleViewCompositeFX() {
        super(new ICompositeFXController[0]);
    }

    public void setParent(ScheduleViewFX parent) {
        this.parent = parent;
    }

    public void initialize() {
        this.canvasWrapper = new ScheduleViewCanvasFX(this, this.canvas, this.scrollBar);
        this.canvas.widthProperty().bind((ObservableValue)this.canvasPane.widthProperty());
        this.canvas.heightProperty().bind((ObservableValue)this.canvasPane.heightProperty());
        this.slider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (oldValue.intValue() != newValue.intValue()) {
                    ScheduleViewCompositeFX.this.updateScale(newValue.intValue());
                }
            }
        });
        this.numPeriodsSpinner.valueProperty().addListener((ChangeListener)new ChangeListener<Integer>(){

            public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
                ScheduleViewCompositeFX.this.canvasWrapper.updateHyperPeriods(newValue);
            }
        });
        this.canvas.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                ScheduleViewCompositeFX.this.canvasWrapper.mouseMoved((int)event.getX(), (int)event.getY(), true);
            }
        });
        this.mainPane.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                ScheduleViewCompositeFX.this.onResize();
            }
        });
        this.mainPane.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                ScheduleViewCompositeFX.this.onResize();
            }
        });
    }

    public void updateScale(int value) {
        int userScaleEffective = Math.min(Math.max(0, value), 10);
        this.canvasWrapper.setScalingUserX(userScaleEffective);
    }

    public void setScale(int value) {
        int userScaleEffective = Math.min(Math.max(0, value), 10);
        this.slider.setValue((double)value);
        this.canvasWrapper.setScalingUserX(userScaleEffective);
    }

    public void setSchedule(EObject scheduleContainer, List<Schedule> schedules, BigDecimal majorFrame) {
        this.scheduleContainer = scheduleContainer;
        ScheduleViewModelFX scheduleModel = this.canvasWrapper.getScheduleModel();
        if (schedules != null) {
            scheduleModel.setSchedule(schedules.stream().sorted((schedule1, schedule2) -> schedule1.getName().compareTo(schedule2.getName())).collect(Collectors.toList()), majorFrame);
            scheduleModel.setSchedulableEntityPeriods(this.getSchedulableEntityPeriods(majorFrame));
            scheduleModel.setResourceSchedulePeriods(this.getResourceSchedulePeriods(majorFrame));
        }
    }

    private List<BigDecimal> getSchedulableEntityPeriods(BigDecimal majorFrame) {
        if (this.scheduleContainer == null) {
            return Collections.emptyList();
        }
        TreeSet<BigDecimal> periods = new TreeSet<BigDecimal>();
        for (ResourceAllocation ra : EcoreUtils.getChildrenWithType((EObject)this.scheduleContainer, ResourceAllocation.class)) {
            BigDecimal period = ScheduleUtils.getPeriod((ResourceAllocation)ra);
            this.unfoldPeriod(periods, period, majorFrame);
        }
        BigDecimal[] periodsArray = new BigDecimal[periods.size()];
        periods.toArray(periodsArray);
        return Arrays.asList(periodsArray);
    }

    private List<BigDecimal> getResourceSchedulePeriods(BigDecimal majorFrame) {
        if (this.scheduleContainer == null) {
            return Collections.emptyList();
        }
        TreeSet<BigDecimal> periods = new TreeSet<BigDecimal>();
        for (Schedule ra : EcoreUtils.getChildrenWithType((EObject)this.scheduleContainer, Schedule.class)) {
            BigDecimal period = ScheduleUtils.getHyperPeriod((Schedule)ra);
            this.unfoldPeriod(periods, period, majorFrame);
        }
        BigDecimal[] periodsArray = new BigDecimal[periods.size()];
        periods.toArray(periodsArray);
        return Arrays.asList(periodsArray);
    }

    private void unfoldPeriod(Set<BigDecimal> periods, BigDecimal period, BigDecimal majorFrame) {
        if (period != null && period.compareTo(BigDecimal.ZERO) == 1) {
            BigDecimal p = period;
            while (p.compareTo(majorFrame) <= 0) {
                periods.add(p);
                p = p.add(period);
            }
        }
    }

    public String getFXMLLocation() {
        return "libraryModule.fxml";
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.isSelectionChangedEnabled) {
            return;
        }
        this.isSelectionChangedEnabled = false;
        SystemSchedule systemSchedule = null;
        EObject obj = (EObject)SelectionUtils.checkAndPickFirst((ISelection)selection, EObject.class);
        if (obj != null) {
            systemSchedule = (SystemSchedule)KernelModelElementUtils.getParentElement((EObject)obj, SystemSchedule.class, (boolean)true);
        }
        if (systemSchedule != null) {
            this.scheduleContainer = systemSchedule;
            this.setSchedule();
            FileProject fp = (FileProject)KernelModelElementUtils.getParentElement((EObject)systemSchedule, FileProject.class, (boolean)false);
            if (fp != this.fileProject) {
                if (this.fileProject != null) {
                    this.fileProject.eAdapters().remove((Object)this.fileProjectScheduleChangeAdapter);
                }
                this.fileProject = fp;
                this.fileProject.eAdapters().add((Object)this.fileProjectScheduleChangeAdapter);
            }
        }
        this.isSelectionChangedEnabled = true;
    }

    public void setSchedule(SubSchedule subSchedule) {
        this.scheduleContainer = subSchedule;
        this.fileProject = (FileProject)KernelModelElementUtils.getParentElement((EObject)subSchedule, FileProject.class, (boolean)false);
        if (this.fileProject != null) {
            this.fileProject.eAdapters().add((Object)this.fileProjectScheduleChangeAdapter);
        }
        this.setSchedule();
        this.isSelectionChangedEnabled = false;
    }

    private void setSchedule() {
        Object scheduleList = null;
        BigDecimal majorFrame = BigDecimal.ZERO;
        if (this.scheduleContainer instanceof SystemSchedule) {
            SystemSchedule systemSchedule = (SystemSchedule)this.scheduleContainer;
            scheduleList = systemSchedule.getScheduleList();
            if (systemSchedule.getMajorFrame() != null) {
                majorFrame = systemSchedule.getMajorFrame();
            }
        } else if (this.scheduleContainer instanceof SubSchedule) {
            scheduleList = Arrays.asList((SubSchedule)this.scheduleContainer);
            SystemSchedule systemSchedule = (SystemSchedule)KernelModelElementUtils.getParentElement((EObject)this.scheduleContainer, SystemSchedule.class, (boolean)false);
            majorFrame = systemSchedule != null ? systemSchedule.getMajorFrame() : BigDecimal.ZERO;
        }
        this.isSelectionChangedEnabled = true;
        this.setSchedule(this.scheduleContainer, (List<Schedule>)scheduleList, majorFrame);
        this.updateTitle();
        this.redrawCanvas();
    }

    private void updateTitle() {
        String scheduleName;
        if (this.scheduleContainer instanceof INamedElement && (scheduleName = ((INamedElement)this.scheduleContainer).getName()) != null && !scheduleName.isEmpty()) {
            this.parent.setPartName(scheduleName);
        }
        if (this.scheduleContainer != null) {
            String projectHint;
            FileProject fp = (FileProject)KernelModelElementUtils.getParentElement((EObject)this.scheduleContainer, FileProject.class, (boolean)false);
            String string = projectHint = fp != null ? " in \"" + fp.getName() + "\"" : "";
            if (this.scheduleContainer instanceof SystemSchedule) {
                this.parent.setTitleToolTip("System schedule" + projectHint);
            } else if (this.scheduleContainer instanceof SubSchedule) {
                this.parent.setTitleToolTip("Sub-schedule refining resource allocation \"" + ((SubSchedule)this.scheduleContainer).getRefinedResourceAllocation().getName() + "\"" + projectHint);
            }
        }
    }

    public void redrawCanvas() {
        this.canvasWrapper.repaint();
        BigDecimal majorFrame = this.canvasWrapper.getScheduleModel().getMajorFrame();
        boolean hasPeriods = majorFrame != null && majorFrame.compareTo(BigDecimal.ZERO) != 0;
        this.displayPeriodsSchedulableEntitiesCheckBox.setDisable(!hasPeriods);
        this.displayPeriodsSchedulesCheckBox.setDisable(!hasPeriods);
    }

    public void onActionDisplayPeriods() {
        this.canvasWrapper.setDisplayPeriodsSchedules(this.displayPeriodsSchedulesCheckBox.isSelected());
        this.redrawCanvas();
    }

    public void onActionDisplayPeriodsSchedulable() {
        this.canvasWrapper.setDisplayPeriodsSchedulableEntities(this.displayPeriodsSchedulableEntitiesCheckBox.isSelected());
        this.redrawCanvas();
    }

    public void onMouseMoved(MouseEvent event) {
        this.canvasWrapper.mouseMoved((int)event.getX(), (int)event.getY(), false);
    }

    public void onMousePressed(MouseEvent event) {
        switch (event.getButton()) {
            case PRIMARY: {
                this.canvasWrapper.mousePressedPrimary((int)event.getX());
                break;
            }
            case MIDDLE: {
                this.canvasWrapper.mousePressedMiddle((int)event.getX(), (int)event.getY());
                break;
            }
            case SECONDARY: {
                this.canvasWrapper.mousePressedSecondary();
                break;
            }
        }
    }

    public void onMouseReleased(MouseEvent event) {
        switch (event.getButton()) {
            case PRIMARY: {
                this.canvasWrapper.mouseReleasedPrimary();
                break;
            }
        }
    }

    public void onResize() {
        this.canvasWrapper.getScheduleGraphModel().refresh();
    }
}

