/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.schedule.ui.ganttchartview.fx;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.Bounds;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.schedule.model.ResourceAllocationFragment;
import org.fortiss.af3.schedule.model.Schedule;
import org.fortiss.af3.schedule.ui.ganttchartview.fx.AbstractObjectToDrawFX;
import org.fortiss.af3.schedule.ui.ganttchartview.fx.LabelToDrawFX;
import org.fortiss.af3.schedule.ui.ganttchartview.fx.LineToDrawFX;
import org.fortiss.af3.schedule.ui.ganttchartview.fx.ScheduleModelElementToDrawFX;
import org.fortiss.af3.schedule.ui.ganttchartview.fx.ScheduleViewCanvasFX;
import org.fortiss.af3.schedule.ui.ganttchartview.fx.ScheduleViewColorsFX;
import org.fortiss.af3.schedule.ui.ganttchartview.fx.ScheduleViewLayoutDataFX;
import org.fortiss.af3.schedule.ui.ganttchartview.fx.ScheduleViewModelFX;
import org.fortiss.af3.schedule.utils.ScheduleUtils;

public class ScheduleViewGraphModelFX {
    private Map<EObject, Color> objectToColor = new HashMap<EObject, Color>();
    private List<AbstractObjectToDrawFX> graphElementList = new ArrayList<AbstractObjectToDrawFX>();
    private boolean graphElementListIsUpToDate;
    private ScheduleViewCanvasFX canvas;

    public ScheduleViewGraphModelFX(ScheduleViewCanvasFX canvas) {
        this.canvas = canvas;
    }

    public ScheduleModelElementToDrawFX findObjectAt(BigDecimal x, BigDecimal y) {
        ScheduleViewModelFX scheduleModel = this.canvas.getScheduleModel();
        for (AbstractObjectToDrawFX object : this.graphElementList) {
            if (!(object instanceof ScheduleModelElementToDrawFX) || object.getStartingPoint_Y() != y) continue;
            int period = 0;
            while (period < scheduleModel.getNumberOfHyperPeriods()) {
                BigDecimal multiply = BigDecimal.valueOf(period).multiply(scheduleModel.getScheduleLength());
                BigDecimal objectX = object.getStartingPoint_X().add(multiply);
                if (x.compareTo(objectX) >= 0 && x.compareTo(objectX.add(object.getWidth())) <= 0) {
                    return (ScheduleModelElementToDrawFX)object;
                }
                ++period;
            }
        }
        return null;
    }

    public boolean update() {
        if (this.graphElementListIsUpToDate) {
            return false;
        }
        this.graphElementListIsUpToDate = true;
        this.canvas.getScheduleLayoutData().update();
        ScheduleViewModelFX scheduleModel = this.canvas.getScheduleModel();
        int y = 0;
        this.graphElementList.clear();
        this.objectToColor.clear();
        for (Schedule schedule : scheduleModel.getSchedules()) {
            LabelToDrawFX label = LabelToDrawFX.createLabel(schedule, y, 150, ScheduleViewColorsFX.getColor(0), this.objectToColor);
            if (label != null) {
                this.graphElementList.add(label);
            }
            BigDecimal roundOffset = BigDecimal.ZERO;
            BigDecimal schedulePeriod = ScheduleUtils.getHyperPeriod((Schedule)schedule);
            boolean isPeriodSet = schedulePeriod != null && schedulePeriod.compareTo(BigDecimal.ZERO) == 1;
            while (!isPeriodSet || roundOffset.compareTo(scheduleModel.getScheduleLength()) == -1) {
                for (ResourceAllocation resourceAllocation : schedule.getResourceAllocationList()) {
                    Color color = ScheduleViewColorsFX.getColor(resourceAllocation, this.objectToColor);
                    if (color == null) continue;
                    if (resourceAllocation.getFragments().isEmpty()) {
                        ScheduleModelElementToDrawFX object = ScheduleModelElementToDrawFX.createScheduleModelElement(resourceAllocation, roundOffset, y, color);
                        if (object == null) continue;
                        this.graphElementList.add(object);
                        continue;
                    }
                    for (ResourceAllocationFragment fragment : resourceAllocation.getFragments()) {
                        ScheduleModelElementToDrawFX object = ScheduleModelElementToDrawFX.createScheduleModelElement(fragment, roundOffset, y, color);
                        if (object == null) continue;
                        this.graphElementList.add(object);
                    }
                }
                if (!isPeriodSet) break;
                roundOffset = roundOffset.add(schedulePeriod);
            }
            ++y;
        }
        return true;
    }

    public void draw(GraphicsContext gc) {
        ScheduleViewLayoutDataFX scheduleLayoutData = this.canvas.getScheduleLayoutData();
        ScheduleViewModelFX scheduleModel = this.canvas.getScheduleModel();
        Color colorRed = Color.DARKRED;
        Color colorBlack = Color.BLACK;
        Bounds clientArea = this.canvas.getBounds();
        Font font = gc.getFont();
        for (AbstractObjectToDrawFX object : this.graphElementList) {
            if (object instanceof LineToDrawFX) {
                LineToDrawFX.drawLine(gc, (LineToDrawFX)object, colorRed, colorBlack, scheduleLayoutData);
            }
            int period = 0;
            while (period < scheduleModel.getNumberOfHyperPeriods()) {
                BigDecimal startingPoint_Y = object.getStartingPoint_Y();
                int diagramHeight = scheduleLayoutData.getDiagramHeightOfSchedule();
                BigDecimal multiply = BigDecimal.valueOf(diagramHeight).multiply(startingPoint_Y);
                int intValue = multiply.setScale(0, RoundingMode.HALF_UP).intValue();
                int y = 50 + intValue;
                int height = Math.max(1, diagramHeight - 2);
                if (object instanceof LabelToDrawFX && period == 0) {
                    int x = scheduleLayoutData.getDiagramOrigin().x;
                    int intValue2 = object.getWidth().setScale(0, RoundingMode.HALF_UP).intValue();
                    LabelToDrawFX.drawLabel(gc, (LabelToDrawFX)object, x, y, intValue2, height, font);
                } else if (object instanceof ScheduleModelElementToDrawFX) {
                    int width;
                    BigDecimal majorFrame = scheduleModel.getScheduleLength();
                    BigDecimal startingPoint_X = object.getStartingPoint_X();
                    BigDecimal add = BigDecimal.valueOf(period).multiply(majorFrame).add(startingPoint_X);
                    int x = scheduleLayoutData.objectSpaceToDiagramSpaceX(add);
                    if (x + (width = scheduleLayoutData.scaleLengthObjectSpaceToDiagramSpaceX(object.getWidth())) >= 0 && !((double)x > clientArea.getWidth())) {
                        ScheduleModelElementToDrawFX.drawScheduleModelElement(gc, (ScheduleModelElementToDrawFX)object, x, y, width, (int)clientArea.getWidth(), height, font);
                    }
                }
                ++period;
            }
        }
    }

    public void refresh() {
        this.graphElementListIsUpToDate = false;
        this.canvas.repaint();
    }
}

