/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.schedule.ui.ganttchartview.fx;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.List;
import javafx.geometry.Bounds;
import org.eclipse.swt.graphics.Point;
import org.fortiss.af3.schedule.model.Schedule;
import org.fortiss.af3.schedule.ui.ganttchartview.fx.ScheduleViewCanvasFX;
import org.fortiss.af3.schedule.ui.ganttchartview.fx.ScheduleViewModelFX;
import org.fortiss.af3.schedule.utils.MathUtils;
import org.fortiss.af3.schedule.utils.ScheduleUtils;

public class ScheduleViewLayoutDataFX {
    public static final int SCALING_USER_X_MAX = 10;
    public static final int SCALING_USER_X_DEFAULT = 1;
    public static final int MAXIMUM_PRECISION = 6;
    public static final MathContext MATH_CONTEXT_DOUBLE_MAXIMUM_PRECISION = new MathContext(12);
    public static final int DIAGRAM_X_AXIS_LABEL_SIZE = 75;
    public static final int DIAGRAM_OFFSET_LABEL = 150;
    public static final int DIAGRAM_HORIZONTAL_SPACING = 2;
    public static final int DIAGRAM_OFFSET_Y = 50;
    public static final int DIAGRAM_OFFSET_X = 20;
    private ScheduleViewCanvasFX canvas;
    private int scalingUserX = 1;
    private BigDecimal scalingPrecisionX = BigDecimal.ONE;
    private int diagramHeightOfSchedule;
    private int diagramWidthOfGraph;
    private BigDecimal modelLabelInterval;
    private Point diagramOrigin = new Point(0, 0);

    public ScheduleViewLayoutDataFX(ScheduleViewCanvasFX canvas) {
        this.canvas = canvas;
    }

    public int scaleLengthObjectSpaceToDiagramSpaceX(BigDecimal length) {
        return BigDecimal.valueOf(this.scalingUserX).multiply(this.scalingPrecisionX).multiply(length).intValue();
    }

    public BigDecimal scaleLengthDiagramSpaceToObjectSpaceX(int length) {
        BigDecimal multiply = BigDecimal.valueOf(this.scalingUserX).multiply(this.scalingPrecisionX);
        return BigDecimal.valueOf(length).divide(multiply, MATH_CONTEXT_DOUBLE_MAXIMUM_PRECISION);
    }

    public BigDecimal diagramSpaceToObjectSpaceX(int x) {
        return this.scaleLengthDiagramSpaceToObjectSpaceX(x - this.diagramOrigin.x - 20 - 150);
    }

    public BigDecimal diagramSpaceToObjectSpaceY(int diagramY) {
        int y = (int)Math.floor((double)(diagramY - 50) / (double)this.diagramHeightOfSchedule);
        int yRelativeToScheduleRow = diagramY - 50 - y * this.diagramHeightOfSchedule;
        if (yRelativeToScheduleRow <= 1 || yRelativeToScheduleRow > this.diagramHeightOfSchedule - 1) {
            return BigDecimal.valueOf(-1L);
        }
        return BigDecimal.valueOf(y);
    }

    public int objectSpaceToDiagramSpaceX(BigDecimal x) {
        return this.diagramOrigin.x + 20 + 150 + this.scaleLengthObjectSpaceToDiagramSpaceX(x);
    }

    public int objectSpaceToDiagramSpaceY(BigDecimal y) {
        int intValue = y.multiply(BigDecimal.valueOf(this.diagramHeightOfSchedule)).setScale(0, RoundingMode.HALF_UP).intValue();
        return (int)this.canvas.getBounds().getHeight() - 50 - intValue;
    }

    public int getDiagramLeftX() {
        return Math.max(0, 170 + this.diagramOrigin.x);
    }

    public int getDiagramRightX() {
        Bounds a = this.canvas.getBounds();
        int b = this.diagramOrigin.x + this.diagramWidthOfGraph - 75;
        return (int)Math.min(a.getWidth(), (double)b);
    }

    public BigDecimal getObjectVisibleWidth() {
        ScheduleViewModelFX scheduleModel = this.canvas.getScheduleModel();
        int numberOfHyperPeriods = scheduleModel.getNumberOfHyperPeriods();
        BigDecimal w1 = scheduleModel.getScheduleLength().multiply(BigDecimal.valueOf(numberOfHyperPeriods));
        BigDecimal w2 = this.scaleLengthDiagramSpaceToObjectSpaceX((int)this.canvas.getBounds().getWidth());
        return w1.min(w2);
    }

    public void update() {
        ScheduleViewModelFX scheduleModel = this.canvas.getScheduleModel();
        Bounds clientArea = this.canvas.getBounds();
        List<Schedule> schedules = scheduleModel.getSchedules();
        int highestRequiredPrecision = ScheduleUtils.getHighestRequiredPrecision(schedules, (int)6);
        int marginWidth = 245;
        int scheduleWidth = (int)clientArea.getWidth() - marginWidth;
        BigDecimal maxNumLabels = BigDecimal.valueOf(Math.max(1, scheduleWidth / 75));
        BigDecimal xs = BigDecimal.valueOf(10L);
        BigDecimal ys = BigDecimal.ONE.movePointLeft(highestRequiredPrecision);
        int numberOfHyperPeriods = scheduleModel.getNumberOfHyperPeriods();
        BigDecimal objectWidthOfGraph = scheduleModel.getScheduleLength().multiply(BigDecimal.valueOf(numberOfHyperPeriods));
        BigDecimal ya = objectWidthOfGraph.divide(maxNumLabels, MATH_CONTEXT_DOUBLE_MAXIMUM_PRECISION);
        BigDecimal su_x_max = BigDecimal.valueOf(10L);
        BigDecimal a = ya.subtract(ys).divide(BigDecimal.ONE.subtract(su_x_max).multiply(BigDecimal.ONE.subtract(su_x_max)), MATH_CONTEXT_DOUBLE_MAXIMUM_PRECISION);
        BigDecimal su_x = BigDecimal.valueOf(this.scalingUserX);
        this.modelLabelInterval = a.multiply(su_x.subtract(xs)).multiply(su_x.subtract(su_x_max)).add(ys);
        this.modelLabelInterval = MathUtils.roundToNearestQuarterHalfFull((BigDecimal)this.modelLabelInterval).max(BigDecimal.ONE);
        this.scalingPrecisionX = BigDecimal.valueOf(scheduleWidth).divide(this.modelLabelInterval.multiply(maxNumLabels.min(objectWidthOfGraph.divide(this.modelLabelInterval))), MATH_CONTEXT_DOUBLE_MAXIMUM_PRECISION);
        this.diagramWidthOfGraph = this.scaleLengthObjectSpaceToDiagramSpaceX(objectWidthOfGraph) + marginWidth;
        this.diagramHeightOfSchedule = Math.max(1, (int)((clientArea.getHeight() - 100.0) / (double)schedules.size()));
    }

    public int getScalingUserX() {
        return this.scalingUserX;
    }

    public void setScalingUserX(int scalingUserX) {
        this.scalingUserX = scalingUserX;
    }

    public int getDiagramHeightOfSchedule() {
        return this.diagramHeightOfSchedule;
    }

    public int getDiagramWidthOfGraph() {
        return this.diagramWidthOfGraph;
    }

    public BigDecimal getModelLabelInterval() {
        return this.modelLabelInterval;
    }

    public Point getDiagramOrigin() {
        return this.diagramOrigin;
    }
}

