/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.schedule.ui.properties;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fortiss.af3.allocation.IAllocationService;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.platform.model.IPlatformCommunicationResource;
import org.fortiss.af3.platform.model.IPlatformMemoryResource;
import org.fortiss.af3.platform.model.IPlatformProcessingResource;
import org.fortiss.af3.platform.model.IPlatformResource;
import org.fortiss.af3.platform.model.Route;
import org.fortiss.af3.platform.model.allocation.IAllocationTypeCommunication;
import org.fortiss.af3.platform.model.allocation.IAllocationTypeExecutionUnit;
import org.fortiss.af3.platform.model.allocation.IAllocationTypeMemoryUnit;
import org.fortiss.af3.platform.model.allocation.IAllocationTypePlatformUnit;
import org.fortiss.af3.platform.utils.PlatformArchitectureUtils;
import org.fortiss.af3.schedule.model.AF3SchedulePackage;
import org.fortiss.af3.schedule.model.PeriodicFlexibilityTimeTrigger;
import org.fortiss.af3.schedule.model.PeriodicTimeTrigger;
import org.fortiss.af3.schedule.model.RateConstraintTrigger;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.schedule.model.ResourceAllocationTrigger;
import org.fortiss.af3.schedule.model.SchedulableEntity;
import org.fortiss.af3.schedule.model.SystemSchedule;
import org.fortiss.af3.schedule.model.TimeTrigger;
import org.fortiss.af3.schedule.utils.AF3ScheduleModelElementFactory;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.databinding.NumberPositiveZeroValidator;
import org.fortiss.tooling.kernel.ui.extension.base.EReferencePropertySectionBase;
import org.fortiss.tooling.kernel.ui.util.ObservableUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class ResourceAllocationPropertySection
extends EReferencePropertySectionBase<ResourceAllocation, IModelElement> {
    private final String PERIODIC_TRIGGER_COMBO_VALUE = "Periodic";
    private final String PERIODIC_FLEXIBILIY_TRIGGER_COMBO_VALUE = "Flexible";
    private final String RATE_CONSTRAINT_TRIGGER_COMBO_VALUE = "Rate Constraint";
    private static final String PERIOD_LABEL = "Period [s]";
    private static final String MINT_LABEL = "MINT [s]";
    private static final String PHASE_LABEL = "Phase [s]";
    private static final String JITTER_LABEL = "Jitter [s]";
    private static final String PRIORITY_LABEL = "Priority";
    private static final String FLEXIBILITY_LABEL = "Flexibility";
    private Text durationText;
    private ComboViewer triggerCombo;
    private Text periodMintText;
    private Label periodMintLabel;
    private Text phaseJitterText;
    private Label phaseJitterLabel;
    private Text priorityText;
    private Label priorityLabel;
    private Text flexiblityCoefficientText;
    private Label flexiblityCoefficientLabel;
    private boolean userSelection;
    private ResourceAllocation resourceAllocation;

    public ResourceAllocationPropertySection() {
        super("Schedulable Entity");
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.durationText = this.createDecoratedFormText("Duration [s]");
        this.triggerCombo = this.createDecoratedComboViewer("Trigger");
        this.triggerCombo.add((Object)"Periodic");
        this.triggerCombo.add((Object)"Flexible");
        this.triggerCombo.setSelection((ISelection)new StructuredSelection((Object)"Periodic"));
        this.triggerCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PeriodicTimeTrigger trigger;
                if (!ResourceAllocationPropertySection.this.userSelection) {
                    return;
                }
                BigDecimal periodMint = ResourceAllocationPropertySection.this.getValue(ResourceAllocationPropertySection.this.periodMintText);
                BigDecimal phaseJitter = ResourceAllocationPropertySection.this.getValue(ResourceAllocationPropertySection.this.phaseJitterText);
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Object newValue = sel.getFirstElement();
                if (newValue == "Periodic" && !(ResourceAllocationPropertySection.this.resourceAllocation.getTrigger() instanceof PeriodicTimeTrigger)) {
                    trigger = AF3ScheduleModelElementFactory.createPeriodicTimeTrigger((BigDecimal)periodMint, (BigDecimal)phaseJitter);
                    ResourceAllocationPropertySection.this.displayPeriodicTimeTrigger((ResourceAllocationTrigger)trigger);
                } else if (newValue == "Flexible" && !(ResourceAllocationPropertySection.this.resourceAllocation.getTrigger() instanceof PeriodicFlexibilityTimeTrigger)) {
                    trigger = AF3ScheduleModelElementFactory.createPeriodicFlexibilityTimeTrigger((BigDecimal)phaseJitter);
                    ResourceAllocationPropertySection.this.displayPeriodicFlexibilityTimeTrigger((ResourceAllocationTrigger)trigger);
                } else if (newValue == "Rate Constraint" && !(ResourceAllocationPropertySection.this.resourceAllocation.getTrigger() instanceof RateConstraintTrigger)) {
                    trigger = AF3ScheduleModelElementFactory.createRateConstraintTrigger((BigDecimal)periodMint, (BigDecimal)phaseJitter);
                    ResourceAllocationPropertySection.this.displayRateConstraintTrigger((ResourceAllocationTrigger)trigger);
                } else {
                    trigger = null;
                    ResourceAllocationPropertySection.this.displayNoTrigger();
                }
                if (trigger != null) {
                    ITopLevelElement modelContext = IPersistencyService.getInstance().getTopLevelElementFor((EObject)ResourceAllocationPropertySection.this.resourceAllocation);
                    modelContext.runAsCommand(new Runnable((ResourceAllocationTrigger)trigger){
                        private final /* synthetic */ ResourceAllocationTrigger val$trigger;
                        {
                            this.val$trigger = resourceAllocationTrigger;
                        }

                        @Override
                        public void run() {
                            (this).ResourceAllocationPropertySection.this.resourceAllocation.setTrigger(this.val$trigger);
                        }
                    });
                }
            }
        });
        this.periodMintText = this.createDecoratedText("");
        this.periodMintLabel = this.createFormEntry((Control)this.periodMintText, PERIOD_LABEL);
        this.phaseJitterText = this.createDecoratedText("");
        this.phaseJitterLabel = this.createFormEntry((Control)this.phaseJitterText, PHASE_LABEL);
        this.flexiblityCoefficientText = this.createDecoratedText("");
        this.flexiblityCoefficientLabel = this.createFormEntry((Control)this.flexiblityCoefficientText, FLEXIBILITY_LABEL);
        this.priorityText = this.createDecoratedText("");
        this.priorityLabel = this.createFormEntry((Control)this.priorityText, PRIORITY_LABEL);
    }

    private BigDecimal getValue(Text text) {
        boolean numberFormatError = false;
        BigDecimal rval = null;
        try {
            rval = new BigDecimal(text.getText());
        }
        catch (NumberFormatException e) {
            numberFormatError = true;
        }
        if (numberFormatError) {
            rval = BigDecimal.ZERO;
        }
        return rval;
    }

    private void setPeriodMintPhaseJitterPriorityFlexibilityEnable(boolean enablePeriodMint, boolean enablePhaseJitter, boolean enablePriority, boolean enableFlexiblityCoefficient) {
        this.periodMintText.setEnabled(enablePeriodMint);
        this.phaseJitterText.setEnabled(enablePhaseJitter);
        this.priorityText.setEnabled(enablePriority);
        this.flexiblityCoefficientText.setEnabled(enableFlexiblityCoefficient);
    }

    private void hideDynamicTextLabels() {
        this.periodMintText.setText("");
        this.phaseJitterText.setText("");
        this.priorityText.setText("");
        this.periodMintLabel.setText("");
        this.phaseJitterLabel.setText("");
        this.priorityLabel.setText("");
        this.flexiblityCoefficientLabel.setText("");
    }

    private void displayNoTrigger() {
        this.triggerCombo.setSelection(null);
        this.hideDynamicTextLabels();
        this.periodMintLabel.setText("Period [s] / MINT [s]");
        this.phaseJitterLabel.setText("Phase [s] / Jitter [s]");
        this.priorityText.setText("");
        this.flexiblityCoefficientText.setText("");
        this.setPeriodMintPhaseJitterPriorityFlexibilityEnable(false, false, false, false);
    }

    private void displayPeriodicTimeTrigger(ResourceAllocationTrigger trigger) {
        this.hideDynamicTextLabels();
        this.periodMintLabel.setText(PERIOD_LABEL);
        this.phaseJitterLabel.setText(PHASE_LABEL);
        this.bindPeriodMint(trigger, AF3SchedulePackage.Literals.PERIODIC_TIME_TRIGGER__PERIOD);
        this.bindPhaseJitter(trigger, AF3SchedulePackage.Literals.TIME_TRIGGER__START_TIME);
        this.setPeriodMintPhaseJitterPriorityFlexibilityEnable(true, true, false, false);
    }

    private void displayPeriodicFlexibilityTimeTrigger(ResourceAllocationTrigger trigger) {
        this.hideDynamicTextLabels();
        this.phaseJitterLabel.setText(PHASE_LABEL);
        this.flexiblityCoefficientLabel.setText(FLEXIBILITY_LABEL);
        this.bindPhaseJitter(trigger, AF3SchedulePackage.Literals.TIME_TRIGGER__START_TIME);
        this.bindFlexibilityCoefficient(trigger);
        this.setPeriodMintPhaseJitterPriorityFlexibilityEnable(false, true, false, true);
    }

    private void displayRateConstraintTrigger(ResourceAllocationTrigger trigger) {
        this.hideDynamicTextLabels();
        this.periodMintLabel.setText(MINT_LABEL);
        this.phaseJitterLabel.setText(JITTER_LABEL);
        this.priorityLabel.setText(PRIORITY_LABEL);
        this.bindPeriodMint(trigger, AF3SchedulePackage.Literals.RATE_CONSTRAINT_TRIGGER__MINT);
        this.bindPhaseJitter(trigger, AF3SchedulePackage.Literals.RATE_CONSTRAINT_TRIGGER__JITTER);
        this.bindPriority(trigger);
        this.setPeriodMintPhaseJitterPriorityFlexibilityEnable(true, true, true, false);
    }

    private void bindPeriodMint(ResourceAllocationTrigger trigger, EAttribute eAttribute) {
        this.bindPositiveBigDecimalValue((Control)this.periodMintText, ObservableUtils.observeValue((EObject)trigger, (EStructuralFeature)eAttribute), 12);
    }

    private void bindPhaseJitter(ResourceAllocationTrigger trigger, EAttribute eAttribute) {
        this.bindBigDecimalValue((Control)this.phaseJitterText, ObservableUtils.observeValue((EObject)trigger, (EStructuralFeature)eAttribute), (IValidator)NumberPositiveZeroValidator.NUMBER_POSITIVE_ZERO_VALIDATOR, 12);
    }

    private void bindDuration(ResourceAllocation resourceAllocation) {
        this.bindPositiveBigDecimalValue((Control)this.durationText, ObservableUtils.observeValue((EObject)resourceAllocation, (EStructuralFeature)AF3SchedulePackage.Literals.RESOURCE_ALLOCATION__DURATION), 12);
    }

    private void bindPriority(ResourceAllocationTrigger trigger) {
        this.bindIntegerValue((Control)this.priorityText, ObservableUtils.observeValue((EObject)trigger, (EStructuralFeature)AF3SchedulePackage.Literals.RATE_CONSTRAINT_TRIGGER__PRIORITY), (IValidator)NumberPositiveZeroValidator.NUMBER_POSITIVE_ZERO_VALIDATOR);
    }

    private void bindFlexibilityCoefficient(ResourceAllocationTrigger trigger) {
        this.bindBigDecimalValue((Control)this.flexiblityCoefficientText, ObservableUtils.observeValue((EObject)trigger, (EStructuralFeature)AF3SchedulePackage.Literals.PERIODIC_FLEXIBILITY_TIME_TRIGGER__FLEXIBILITY), (IValidator)NumberPositiveZeroValidator.NUMBER_POSITIVE_ZERO_VALIDATOR, 12);
    }

    protected void setSectionInput(Object input) {
        super.setSectionInput(input);
        this.resourceAllocation = (ResourceAllocation)input;
    }

    public void refresh() {
        super.refresh();
        this.bindDuration(this.resourceAllocation);
        ResourceAllocationTrigger trigger = this.resourceAllocation.getTrigger();
        this.userSelection = false;
        this.triggerCombo.remove((Object)"Rate Constraint");
        this.triggerCombo.remove((Object)"Flexible");
        if (this.resourceAllocation.getResource() instanceof IPlatformCommunicationResource) {
            this.triggerCombo.add((Object)"Rate Constraint");
        } else {
            this.triggerCombo.add((Object)"Flexible");
        }
        if (trigger == null) {
            this.displayNoTrigger();
        } else if (trigger instanceof PeriodicTimeTrigger) {
            PeriodicTimeTrigger periodicTrigger = (PeriodicTimeTrigger)trigger;
            this.periodMintText.setText(periodicTrigger.getPeriod().toString());
            this.phaseJitterText.setText(periodicTrigger.getStartTime().toString());
            this.priorityText.setText("");
            this.flexiblityCoefficientText.setText("");
            this.triggerCombo.setSelection((ISelection)new StructuredSelection((Object)"Periodic"));
            this.displayPeriodicTimeTrigger(trigger);
        } else if (trigger instanceof PeriodicFlexibilityTimeTrigger) {
            this.periodMintText.setText("");
            this.phaseJitterText.setText(((PeriodicFlexibilityTimeTrigger)trigger).getStartTime().toString());
            this.priorityText.setText("");
            this.flexiblityCoefficientText.setText("");
            this.triggerCombo.setSelection((ISelection)new StructuredSelection((Object)"Flexible"));
            this.displayPeriodicFlexibilityTimeTrigger(trigger);
        } else if (trigger instanceof RateConstraintTrigger) {
            RateConstraintTrigger rateContraintTrigger = (RateConstraintTrigger)trigger;
            this.periodMintText.setText(rateContraintTrigger.getMint().toString());
            this.phaseJitterText.setText(rateContraintTrigger.getJitter().toString());
            this.priorityText.setText(String.valueOf(rateContraintTrigger.getPriority()));
            this.flexiblityCoefficientText.setText("");
            this.triggerCombo.setSelection((ISelection)new StructuredSelection((Object)"Rate Constraint"));
            this.displayRateConstraintTrigger(trigger);
        } else assert (false);
        this.userSelection = true;
        boolean hasFragments = !this.resourceAllocation.getFragments().isEmpty();
        boolean isTimeTriggerd = this.resourceAllocation.getTrigger() instanceof TimeTrigger;
        this.durationText.setEnabled(this.durationText.isEnabled() && !hasFragments);
        this.phaseJitterText.setEnabled(this.phaseJitterText.isEnabled() && (!hasFragments || !isTimeTriggerd));
    }

    private AllocationTable getAllocationTable(AllocationTableCollection atc, IPlatformResource resource) {
        Class<IAllocationTypeExecutionUnit> allocationType;
        IProjectRootElement model = (IProjectRootElement)KernelModelElementUtils.getParentElement((EObject)resource, IProjectRootElement.class, (boolean)false);
        if (resource instanceof IPlatformProcessingResource) {
            allocationType = IAllocationTypeExecutionUnit.class;
        } else if (resource instanceof IPlatformMemoryResource) {
            allocationType = IAllocationTypeMemoryUnit.class;
        } else {
            return null;
        }
        Predicate<AllocationTable> atFilter = t -> t.getTargetView() == model && allocationType.isAssignableFrom(t.getClass());
        return atc.getAllocationTables().stream().filter(atFilter).findFirst().orElse(null);
    }

    protected List<IModelElement> getValues(ResourceAllocation input) {
        SystemSchedule systemSchedule = (SystemSchedule)KernelModelElementUtils.getParentElement((EObject)input, SystemSchedule.class, (boolean)true);
        AllocationTableCollection atc = systemSchedule.getAllocationTableCollection();
        if (atc == null) {
            return Collections.emptyList();
        }
        IPlatformResource resource = input.getResource();
        AllocationTable at = this.getAllocationTable(atc, resource);
        if (at == null) {
            return Collections.emptyList();
        }
        if (resource instanceof IPlatformCommunicationResource) {
            Class entryType = PlatformArchitectureUtils.getHardwareLayerEntryType(at.getClass(), IAllocationTypeCommunication.class);
            Collection allRoutes = LambdaUtils.filterByType((Collection)at.getTargetElements(entryType), Route.class);
            Stream routes = allRoutes.stream().map(r -> r.getAllSegments().stream().filter(s -> s.getEntity() == resource)).flatMap(Function.identity());
            return routes.collect(Collectors.toList());
        }
        ArrayList<IModelElement> rval = new ArrayList<IModelElement>();
        IAllocationService as = IAllocationService.getInstance();
        for (Class entryType : as.getAllocationEntryTypes(at.getClass(), new Class[]{IAllocationTypePlatformUnit.class})) {
            EList sourceElements = at.getSourceElements((IModelElement)resource, entryType);
            rval.addAll((Collection<IModelElement>)sourceElements);
            if (!(resource instanceof IPlatformMemoryResource)) continue;
            for (IConnector output : EcoreUtils.pickInstanceOf(IConnector.class, (List)sourceElements)) {
                List inputs = output.getOutgoing().stream().map(s -> s.getTarget()).collect(Collectors.toList());
                rval.addAll(inputs);
            }
        }
        return rval;
    }

    protected IModelElement getModelValue(ResourceAllocation input) {
        return input.getSchedulableEntity().getModelElement();
    }

    protected void setModelValue(ResourceAllocation input, IModelElement newValue) {
        if (input.getSchedulableEntity() == null || input.getSchedulableEntity().getClass() != SchedulableEntity.class) {
            input.setSchedulableEntity(AF3ScheduleModelElementFactory.createSchedulableEntity(null));
        }
        input.getSchedulableEntity().setModelElement(newValue);
    }
}

