/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.schedule.ui.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fortiss.af3.allocation.IAllocationService;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.platform.model.IPlatformCommunicationResource;
import org.fortiss.af3.platform.model.IPlatformResource;
import org.fortiss.af3.platform.model.Route;
import org.fortiss.af3.platform.model.Segment;
import org.fortiss.af3.platform.model.allocation.IAllocationTypeCommunication;
import org.fortiss.af3.platform.model.allocation.IAllocationTypeHardwareLayer;
import org.fortiss.af3.platform.model.allocation.IAllocationTypePlatformUnit;
import org.fortiss.af3.platform.utils.PlatformArchitectureUtils;
import org.fortiss.af3.schedule.model.AF3SchedulePackage;
import org.fortiss.af3.schedule.model.ResourceSchedule;
import org.fortiss.af3.schedule.model.SystemSchedule;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.ui.extension.base.EReferencePropertySectionBase;
import org.fortiss.tooling.kernel.ui.util.ObservableUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class ResourceSchedulePropertySection
extends EReferencePropertySectionBase<ResourceSchedule, IPlatformResource> {
    private ResourceSchedule resourceSchedule;
    private Text hyperPeriodText;

    public ResourceSchedulePropertySection() {
        super("Resource");
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.hyperPeriodText = this.createDecoratedFormText("Hyper Period [s]");
    }

    protected void setSectionInput(Object input) {
        super.setSectionInput(input);
        this.resourceSchedule = (ResourceSchedule)input;
    }

    public void refresh() {
        super.refresh();
        this.bindPositiveBigDecimalValue((Control)this.hyperPeriodText, ObservableUtils.observeValue((EObject)this.resourceSchedule, (EStructuralFeature)AF3SchedulePackage.Literals.RESOURCE_SCHEDULE__HYPER_PERIOD), 12);
    }

    protected List<IPlatformResource> getValues(ResourceSchedule input) {
        SystemSchedule systemSchedule = (SystemSchedule)KernelModelElementUtils.getParentElement((EObject)input, SystemSchedule.class, (boolean)true);
        AllocationTableCollection atc = systemSchedule.getAllocationTableCollection();
        if (atc == null) {
            return Collections.emptyList();
        }
        HashSet<IPlatformCommunicationResource> resources = new HashSet<IPlatformCommunicationResource>();
        IAllocationService as = IAllocationService.getInstance();
        for (AllocationTable at : atc.getAllocationTables(ECollections.asEList((Object[])new Class[]{IAllocationTypeHardwareLayer.class}))) {
            for (Class type : as.getAllocationEntryTypes(at.getClass(), new Class[]{IAllocationTypeHardwareLayer.class})) {
                resources.addAll((Collection<IPlatformCommunicationResource>)EcoreUtils.pickInstanceOf(IPlatformResource.class, (List)at.getTargetElements(type)));
            }
            for (Route route : this.getHardwareLayerTargetElements(at, IAllocationTypeCommunication.class, Route.class)) {
                for (Segment segment : route.getAllSegments()) {
                    IModelElement entity = segment.getEntity();
                    if (!(entity instanceof IPlatformCommunicationResource)) continue;
                    resources.add((IPlatformCommunicationResource)entity);
                }
            }
        }
        return new ArrayList<IPlatformResource>(resources);
    }

    private <T extends EObject> List<T> getHardwareLayerTargetElements(AllocationTable at, Class<? extends IAllocationTypePlatformUnit> allocationType, Class<T> targetElementType) {
        Class entryType = PlatformArchitectureUtils.getHardwareLayerEntryType(at.getClass(), allocationType);
        return entryType != null ? EcoreUtils.pickInstanceOf(targetElementType, (List)at.getTargetElements(entryType)) : Collections.emptyList();
    }

    protected IPlatformResource getModelValue(ResourceSchedule input) {
        return input.getResource();
    }

    protected void setModelValue(ResourceSchedule input, IPlatformResource newValue) {
        input.setResource(newValue);
    }
}

