/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.schedule.ui.utils;

import java.math.BigDecimal;
import java.util.List;
import org.conqat.ide.commons.ui.ui.WorkbenchUtils;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.fortiss.af3.schedule.model.Schedule;
import org.fortiss.af3.schedule.model.SubSchedule;
import org.fortiss.af3.schedule.ui.AF3ScheduleUIActivator;
import org.fortiss.af3.schedule.ui.ganttchartview.ScheduleView;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class ScheduleUIUtils {
    public static final int TEMPORAL_VALUES_MAXIMUM_FRACTION_DIGITS = 12;

    public static void showScheduleView(List<Schedule> schedule, BigDecimal majorFrame) {
        Display display = Display.getDefault();
        display.syncExec(() -> {
            AF3ScheduleUIActivator plugin = AF3ScheduleUIActivator.getDefault();
            try {
                IWorkbenchPage activeWorkbenchPage = WorkbenchUtils.getActiveWorkbenchPage();
                if (activeWorkbenchPage == null) {
                    LoggingUtils.error((Plugin)plugin, (String)"Could not open schedule view since the active workbench page could not be determined.");
                    return;
                }
                ScheduleView scheduleView = (ScheduleView)activeWorkbenchPage.showView("org.fortiss.af3.schedule.ui.ganttchartview.fx.ScheduleViewFX");
                scheduleView.setSchedule(schedule, majorFrame);
            }
            catch (PartInitException e) {
                LoggingUtils.error((Plugin)plugin, (String)"Failed to open schedule view.", (Throwable)e);
            }
        });
    }

    public static void showSubScheduleView(SubSchedule subSchedule) {
        try {
            ScheduleView scheduleView = null;
            Object secondaryId = "SubSchedule (id=" + subSchedule.getId() + ", resource=" + String.valueOf(subSchedule.eResource().getURI()) + ")";
            secondaryId = ((String)secondaryId).replaceAll(":", "_");
            scheduleView = (ScheduleView)WorkbenchUtils.getActiveWorkbenchPage().showView("org.fortiss.af3.schedule.ui.ganttchartview.fx.ScheduleViewFX", (String)secondaryId, 1);
            scheduleView.setSchedule(subSchedule);
        }
        catch (PartInitException e1) {
            e1.printStackTrace();
        }
    }
}

