/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.schedule.ui.utils;

import java.math.BigDecimal;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.schedule.model.ResourceAllocationFragment;
import org.fortiss.af3.schedule.ui.ganttchartview.ScheduleModelElementToDraw;
import org.fortiss.af3.schedule.utils.ScheduleUtils;

public class ScheduleViewUtils {
    public static String truncateStringToWidth(String text, int width, GC gc) {
        int max = Integer.highestOneBit(text.length());
        int sum = 0;
        while (max > 0) {
            if (max + sum <= text.length()) {
                Point extent = gc.stringExtent(text.substring(0, max + sum));
                if (extent.x <= width) {
                    sum += max;
                }
            }
            max >>= 1;
        }
        return text.substring(0, sum);
    }

    public static void drawSubscriptedCaptionCentered(String caption, String subscript, Rectangle bounds, GC gc, Font captionFont, Font subscriptFont) {
        Font font = gc.getFont();
        gc.setFont(subscriptFont);
        Point subscriptExtent = gc.stringExtent(subscript);
        gc.setFont(captionFont);
        Object actualName = ScheduleViewUtils.truncateStringToWidth(caption, bounds.width - subscriptExtent.x, gc);
        if (((String)actualName).length() < caption.length()) {
            actualName = ((String)actualName).substring(0, Math.max(0, ((String)actualName).length() - 1)) + "..";
        }
        Point nameExtent = gc.stringExtent((String)actualName);
        int totalWidth = nameExtent.x + subscriptExtent.x;
        int totalHeight = nameExtent.y + (!subscript.isEmpty() ? subscriptExtent.y : 0);
        if (totalWidth > bounds.width || totalHeight > bounds.height + 4) {
            return;
        }
        gc.drawString((String)actualName, bounds.x + (bounds.width - totalWidth) / 2, bounds.y + (bounds.height - nameExtent.y) / 2, true);
        gc.setFont(subscriptFont);
        gc.drawString(subscript, bounds.x + (bounds.width - totalWidth) / 2 + nameExtent.x, bounds.y + (bounds.height + nameExtent.y) / 2 - subscriptExtent.y, true);
        gc.setFont(font);
    }

    public static void drawInfoLabel(GC gc, String period, Rectangle bounds) {
        gc.drawString(ScheduleViewUtils.truncateStringToWidth(period, bounds.width, gc), bounds.x + 2, bounds.y, true);
    }

    public static void drawSubscriptedCaptionCentered(String name, String subscript, Rectangle bounds, GC gc, Font normalFont, Font subscriptFont, float angle) {
        Transform transform = new Transform(gc.getDevice());
        transform.translate((float)bounds.x, (float)bounds.y);
        transform.rotate(angle);
        gc.setTransform(transform);
        bounds.x = 0;
        bounds.y = 0;
        ScheduleViewUtils.drawSubscriptedCaptionCentered(name, subscript, bounds, gc, normalFont, subscriptFont);
        gc.setTransform(null);
        transform.dispose();
    }

    public static BigDecimal getPhase(ScheduleModelElementToDraw o) {
        EObject object = o.getObject();
        if (object instanceof ResourceAllocation) {
            return ScheduleUtils.getPhase((ResourceAllocation)((ResourceAllocation)object));
        }
        if (object instanceof ResourceAllocationFragment) {
            return ScheduleUtils.getPhase((ResourceAllocationFragment)((ResourceAllocationFragment)object));
        }
        return BigDecimal.valueOf(-1L);
    }

    public static BigDecimal getDuration(ScheduleModelElementToDraw o) {
        EObject object = o.getObject();
        if (object instanceof ResourceAllocation) {
            return ((ResourceAllocation)object).getDuration();
        }
        if (object instanceof ResourceAllocationFragment) {
            return ((ResourceAllocationFragment)object).getDuration();
        }
        return BigDecimal.valueOf(-1L);
    }
}

