/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.schedule.ui.utils;

import java.math.BigDecimal;
import javafx.geometry.Bounds;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.schedule.model.ResourceAllocationFragment;
import org.fortiss.af3.schedule.ui.ganttchartview.fx.ScheduleModelElementToDrawFX;
import org.fortiss.af3.schedule.utils.ScheduleUtils;

public class ScheduleViewUtilsFX {
    public static String truncateStringToWidth(String text, int width, GraphicsContext gc) {
        int max = Integer.highestOneBit(text.length());
        int sum = 0;
        while (max > 0) {
            if (max + sum <= text.length() && ScheduleViewUtilsFX.textWidth(gc, text.substring(0, max + sum)).getWidth() <= (double)width) {
                sum += max;
            }
            max >>= 1;
        }
        return text.substring(0, sum);
    }

    private static Bounds textWidth(GraphicsContext gc, String textToMeasure) {
        Text textField = new Text(textToMeasure);
        textField.setFont(gc.getFont());
        return textField.getLayoutBounds();
    }

    public static void drawSubscriptedCaptionCentered(String caption, String subscript, Rectangle bounds, GraphicsContext gc, Font captionFont, Font subscriptFont) {
        Font font = gc.getFont();
        gc.setFont(subscriptFont);
        Bounds subscriptExtent = ScheduleViewUtilsFX.textWidth(gc, subscript);
        gc.setFont(captionFont);
        Object actualName = ScheduleViewUtilsFX.truncateStringToWidth(caption, (int)(bounds.getWidth() - subscriptExtent.getWidth()), gc);
        if (((String)actualName).length() < caption.length()) {
            actualName = ((String)actualName).substring(0, Math.max(0, ((String)actualName).length() - 1)) + "..";
        }
        Bounds nameExtent = ScheduleViewUtilsFX.textWidth(gc, (String)actualName);
        double totalWidth = nameExtent.getWidth() + subscriptExtent.getWidth();
        double totalHeight = nameExtent.getHeight() + (!subscript.isEmpty() ? subscriptExtent.getHeight() : 0.0);
        if (totalWidth > bounds.getWidth() || totalHeight > bounds.getHeight() + 4.0) {
            return;
        }
        gc.setFill((Paint)Color.BLACK);
        gc.fillText((String)actualName, bounds.getX() + (bounds.getWidth() - totalWidth) / 2.0, bounds.getY() + (bounds.getHeight() + nameExtent.getHeight()) / 2.0);
        gc.setFont(subscriptFont);
        gc.fillText(subscript, bounds.getX() + (bounds.getWidth() - totalWidth) / 2.0 + nameExtent.getWidth(), bounds.getY() + (bounds.getHeight() + nameExtent.getHeight()) / 2.0 - subscriptExtent.getHeight());
        gc.setFont(font);
    }

    public static void drawInfoLabel(GraphicsContext gc, String period, Rectangle bounds) {
        gc.setFill((Paint)Color.BLACK);
        gc.fillText(ScheduleViewUtilsFX.truncateStringToWidth(period, (int)bounds.getWidth(), gc), bounds.getX() + 2.0, bounds.getY() + gc.getFont().getSize());
    }

    public static BigDecimal getPhase(ScheduleModelElementToDrawFX o) {
        EObject object = o.getObject();
        if (object instanceof ResourceAllocation) {
            return ScheduleUtils.getPhase((ResourceAllocation)((ResourceAllocation)object));
        }
        if (object instanceof ResourceAllocationFragment) {
            return ScheduleUtils.getPhase((ResourceAllocationFragment)((ResourceAllocationFragment)object));
        }
        return BigDecimal.valueOf(-1L);
    }

    public static BigDecimal getDuration(ScheduleModelElementToDrawFX o) {
        EObject object = o.getObject();
        if (object instanceof ResourceAllocation) {
            return ((ResourceAllocation)object).getDuration();
        }
        if (object instanceof ResourceAllocationFragment) {
            return ((ResourceAllocationFragment)object).getDuration();
        }
        return BigDecimal.valueOf(-1L);
    }
}

