/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.allocation.ui.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.ide.commons.ui.selection.SelectionUtils;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.allocation.IAllocationService;
import org.fortiss.af3.allocation.model.AllocationEntry;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.allocation.ui.editor.AllocationTableEditorGUI;
import org.fortiss.af3.allocation.ui.editor.ModelListenerEditorBase;
import org.fortiss.af3.allocation.ui.editor.treeviewer.TreeViewerManager;
import org.fortiss.af3.allocation.utils.AllocationUtils;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.ui.util.HierarchicalNameViewerComparator;
import org.fortiss.tooling.kernel.ui.util.KernelUIUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public abstract class AllocationTableEditor<T extends AllocationTable>
extends ModelListenerEditorBase<T> {
    private Class<? extends AllocationEntry> allocationEntryType;
    private Class<? extends IModelElement> sourceEntityType;
    private Class<? extends IModelElement> targetEntityType;
    private IModelElement sourceSuperOrdinateElement;
    private IModelElement targetSuperOrdinateElement;
    private ViewElementFilter sourceViewElementFilter;
    private ViewElementFilter targetViewElementFilter;
    private boolean uniqueSourceView;
    private boolean hasSourceViewHiddenRootElement;
    private List<? extends IModelElement> sourceViewModelElements;
    private List<? extends IModelElement> targetViewModelElements;
    private Collection<IModelElement> sourceSuperOrdinateElements;
    private Collection<IModelElement> targetSuperOrdinateElements;
    private AllocationTableEditorGUI gui;
    private TreeViewerManager<T> treeViewerManager;
    private static Object comboEmptySelectionMarker = new Object();

    AllocationTableEditor(Class<? extends AllocationEntry> allocationEntryType, ViewElementFilter sourceViewElementFilter, ViewElementFilter targetViewElementFilter, boolean uniqueSourceView, boolean hasSourceViewHiddenRootElement, List<EStructuralFeature> observedFeatures) {
        super(AllocationTableEditor.getObservableFeatures(observedFeatures, allocationEntryType));
        this.allocationEntryType = allocationEntryType;
        this.sourceViewElementFilter = sourceViewElementFilter;
        this.targetViewElementFilter = targetViewElementFilter;
        this.uniqueSourceView = uniqueSourceView;
        this.hasSourceViewHiddenRootElement = hasSourceViewHiddenRootElement;
    }

    private static List<EStructuralFeature> getObservableFeatures(List<EStructuralFeature> observableFeatures, Class<? extends AllocationEntry> entryType) {
        HashSet<EStructuralFeature> set = new HashSet<EStructuralFeature>();
        set.addAll(observableFeatures != null ? observableFeatures : Collections.emptyList());
        IAllocationService as = IAllocationService.getInstance();
        Class parentEntryType = as.getParentEntryType(entryType);
        if (parentEntryType != null) {
            set.addAll((Collection<EStructuralFeature>)EcoreUtils.getEClassForClass((Class)parentEntryType).getEAllStructuralFeatures());
        }
        return new ArrayList<EStructuralFeature>(set);
    }

    protected AllocationTableEditor(Class<? extends AllocationEntry> allocationEntryType, ViewElementFilter sourceViewElementFilter, ViewElementFilter targetViewElementFilter, boolean uniqueSourceView, boolean hasSourceViewHiddenRootElement) {
        this(allocationEntryType, sourceViewElementFilter, targetViewElementFilter, uniqueSourceView, hasSourceViewHiddenRootElement, Collections.emptyList());
    }

    protected AllocationTableEditor(Class<? extends AllocationEntry> allocationEntryType) {
        this(allocationEntryType, null, null, true, false, null);
    }

    private void checkConfiguration() {
        AllocationUtils.checkAllocationEntryType(this.allocationEntryType);
        if (this.getEditedObject() == null) {
            return;
        }
        IAllocationService as = IAllocationService.getInstance();
        if (this.getSourceModelTypes().isEmpty()) {
            throw new RuntimeException("Source model type must be set.");
        }
        if (this.getTargetModelTypes().isEmpty()) {
            throw new RuntimeException("Target model type must be set.");
        }
        if (as.getSourceEntityTypes(this.allocationEntryType).isEmpty()) {
            throw new RuntimeException("List of source entity types must not be empty.");
        }
        if (as.getTargetEntityTypes(this.allocationEntryType).isEmpty()) {
            throw new RuntimeException("List of target entity types must not be empty.");
        }
    }

    public Class<? extends AllocationEntry> getAllocationEntryType() {
        return this.allocationEntryType;
    }

    private Collection<Class<? extends IProjectRootElement>> getSourceModelTypes() {
        IAllocationService as = IAllocationService.getInstance();
        Class allocationTableType = AllocationUtils.getAllocationTableType(((AllocationTable)this.getEditedObject()).getClass());
        return as.getSourceModelTypes(allocationTableType);
    }

    private Collection<Class<? extends IProjectRootElement>> getTargetModelTypes() {
        IAllocationService as = IAllocationService.getInstance();
        Class allocationTableType = AllocationUtils.getAllocationTableType(((AllocationTable)this.getEditedObject()).getClass());
        return as.getTargetModelTypes(allocationTableType);
    }

    public Class<? extends IModelElement> getSourceEntityType() {
        return this.sourceEntityType;
    }

    private void setSourceEntityType(Class<? extends IModelElement> sourceEntityType) {
        this.sourceEntityType = sourceEntityType;
        this.sourceViewModelElements = null;
    }

    public Class<? extends IModelElement> getTargetEntityType() {
        return this.targetEntityType;
    }

    private void setTargetEntityType(Class<? extends IModelElement> targetEntityType) {
        this.targetEntityType = targetEntityType;
        this.targetViewModelElements = null;
    }

    public IModelElement getSourceSuperOrdinateElement() {
        return this.sourceSuperOrdinateElement;
    }

    private void setSourceSuperOrdinateElement(IModelElement sourceSuperOrdinateElement) {
        this.sourceSuperOrdinateElement = sourceSuperOrdinateElement;
        sourceSuperOrdinateElement = null;
    }

    public IModelElement getTargetSuperOrdinateElement() {
        return this.targetSuperOrdinateElement;
    }

    private void setTargetSuperOrdinateElement(IModelElement targetSuperOrdinateElement) {
        this.targetSuperOrdinateElement = targetSuperOrdinateElement;
        this.targetSuperOrdinateElements = null;
    }

    public boolean hasSourceViewHiddenRootElement() {
        return this.hasSourceViewHiddenRootElement;
    }

    @Override
    protected boolean isEditedModel(Object object) {
        Stream<Class<IProjectRootElement>> modelTypes = Stream.concat(this.getSourceModelTypes().stream(), this.getTargetModelTypes().stream());
        return ReflectionUtils.isInstanceOfAny((Object)object, (Class[])((Class[])modelTypes.toArray(Class[]::new)));
    }

    protected void refresh(IProjectRootElement model) {
        if (model != null) {
            Collection<Class<? extends IProjectRootElement>> sourceModelTypes = this.getSourceModelTypes();
            Collection<Class<? extends IProjectRootElement>> targetModelTypes = this.getTargetModelTypes();
            this.updateModelSelectionComboBox(this.gui.getComboViewerSource(), this.getModels(sourceModelTypes), ((AllocationTable)this.getEditedObject()).getSourceView());
            Collection sourceEntityTypes = IAllocationService.getInstance().getSourceEntityTypes(this.allocationEntryType);
            this.updateEntityTypeComboBox(this.gui.getComboViewerSourceEntityType(), sourceEntityTypes, ((AllocationTable)this.getEditedObject()).getSourceView(), this::setSourceEntityType);
            this.updateSuperOrdinateElementComboBox(this.gui.getComboViewerSourceSuperOrdinateElement(), this.getSourceSuperOrdinateElements(), this::setSourceSuperOrdinateElement);
            this.updateModelSelectionComboBox(this.gui.getComboViewerTarget(), this.getModels(targetModelTypes), ((AllocationTable)this.getEditedObject()).getTargetView());
            Collection targetEntityTypes = IAllocationService.getInstance().getTargetEntityTypes(this.allocationEntryType);
            this.updateEntityTypeComboBox(this.gui.getComboViewerTargetEntityType(), targetEntityTypes, ((AllocationTable)this.getEditedObject()).getTargetView(), this::setTargetEntityType);
            this.updateSuperOrdinateElementComboBox(this.gui.getComboViewerTargetSuperOrdinateElement(), this.getTargetSuperOrdinateElements(), this::setTargetSuperOrdinateElement);
        } else {
            this.updateModelSelectionComboBox(this.gui.getComboViewerSource(), Collections.emptyList(), null);
            this.updateEntityTypeComboBox(this.gui.getComboViewerSourceEntityType(), Collections.emptyList(), null, this::setSourceEntityType);
            this.updateModelSelectionComboBox(this.gui.getComboViewerTarget(), Collections.emptyList(), null);
            this.updateEntityTypeComboBox(this.gui.getComboViewerTargetEntityType(), Collections.emptyList(), null, this::setTargetEntityType);
        }
        this.treeViewerManager.refreshTreeViewer();
    }

    public void update(IProjectRootElement model) {
        this.refresh(model);
        this.treeViewerManager.updateTreeViewer();
    }

    @Override
    protected void comboViewerOpened(ComboViewer viewer) {
        if (viewer == this.gui.getComboViewerSource()) {
            this.updateModelSelectionComboBox(this.gui.getComboViewerSource(), this.getModels(this.getSourceModelTypes()), ((AllocationTable)this.getEditedObject()).getSourceView());
            this.gui.getComboViewerSource().refresh();
        } else if (viewer == this.gui.getComboViewerTarget()) {
            this.updateModelSelectionComboBox(this.gui.getComboViewerTarget(), this.getModels(this.getTargetModelTypes()), ((AllocationTable)this.getEditedObject()).getTargetView());
            this.gui.getComboViewerTarget().refresh();
        }
    }

    private boolean isEntityType(Object object, Collection<Class<? extends IModelElement>> entityTypes) {
        return entityTypes != null && entityTypes.stream().anyMatch(et -> et.isAssignableFrom(object.getClass()));
    }

    @Override
    protected boolean isEditedEntity(Object object) {
        if (object instanceof AllocationEntry) {
            return true;
        }
        Class<?> objectType = object.getClass();
        if (this.getSourceEntityType() != null && this.getSourceEntityType().isAssignableFrom(objectType)) {
            return true;
        }
        if (this.getTargetEntityType() != null && this.getTargetEntityType().isAssignableFrom(objectType)) {
            return true;
        }
        IAllocationService as = IAllocationService.getInstance();
        Collection sourceEntityTypes = as.getSourceEntityTypes(this.allocationEntryType);
        Collection targetEntityTypes = as.getTargetEntityTypes(this.allocationEntryType);
        if (this.isEntityType(object, sourceEntityTypes) || this.isEntityType(object, targetEntityTypes)) {
            return true;
        }
        Class parentEntryType = as.getParentEntryType(this.getAllocationEntryType());
        return parentEntryType != null && (this.isEntityType(object, as.getSourceEntityTypes(parentEntryType)) || this.isEntityType(object, as.getTargetEntityTypes(parentEntryType)));
    }

    @Override
    protected boolean modelSelectionChanged(IProjectRootElement model, Consumer<IProjectRootElement> modelSetter, Supplier<IProjectRootElement> modelGetter) {
        boolean changeSelection = true;
        if (!((AllocationTable)this.getEditedObject()).getAllocationEntries().isEmpty()) {
            changeSelection = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Reset Allocation", (String)"Selecting a different source or target view will reset the allocation. Are you sure?");
        }
        if (changeSelection) {
            KernelModelElementUtils.runAsCommand((EObject)this.getEditedObject(), () -> ((AllocationTable)this.getEditedObject()).clearAllocationEntries());
            boolean rval = super.modelSelectionChanged(model, modelSetter, modelGetter);
            this.update(model);
            return rval;
        }
        return false;
    }

    private void updateEntityChanged(IModelElement entity) {
        IAllocationService as = IAllocationService.getInstance();
        Collection sourceEntityTypes = IAllocationService.getInstance().getSourceEntityTypes(this.allocationEntryType);
        Collection targetEntityTypes = IAllocationService.getInstance().getTargetEntityTypes(this.allocationEntryType);
        Class parentEntryType = as.getParentEntryType(this.allocationEntryType);
        boolean updateNeeded = false;
        if (this.isEntityType(entity, sourceEntityTypes)) {
            this.updateEntityTypeComboBox(this.gui.getComboViewerSourceEntityType(), sourceEntityTypes, ((AllocationTable)this.getEditedObject()).getSourceView(), this::setSourceEntityType);
            updateNeeded = true;
        } else if (this.isEntityType(entity, targetEntityTypes)) {
            this.updateEntityTypeComboBox(this.gui.getComboViewerTargetEntityType(), targetEntityTypes, ((AllocationTable)this.getEditedObject()).getTargetView(), this::setTargetEntityType);
            updateNeeded = true;
        } else if (parentEntryType != null && (parentEntryType.isAssignableFrom(entity.getClass()) || this.isEntityType(entity, as.getSourceEntityTypes(parentEntryType)) || this.isEntityType(entity, as.getTargetEntityTypes(parentEntryType)))) {
            this.updateSuperOrdinateElementComboBox(this.gui.getComboViewerSourceSuperOrdinateElement(), this.getSourceSuperOrdinateElements(), this::setSourceSuperOrdinateElement);
            this.updateSuperOrdinateElementComboBox(this.gui.getComboViewerTargetSuperOrdinateElement(), this.getTargetSuperOrdinateElements(), this::setTargetSuperOrdinateElement);
            updateNeeded = true;
        } else {
            Collection srcMutexEntityTypes = as.getSourceEntityMutuallyExclusiveEntryTypes(this.getAllocationEntryType());
            Collection tgtMutexEntityTypes = as.getTargetEntityMutuallyExclusiveEntryTypes(this.getAllocationEntryType());
            boolean isSelf = this.getAllocationEntryType().isAssignableFrom(entity.getClass());
            boolean bl = updateNeeded = !isSelf && (LambdaUtils.isAssignableFromAny((Collection)srcMutexEntityTypes, (Object)entity) || LambdaUtils.isAssignableFromAny((Collection)tgtMutexEntityTypes, (Object)entity));
        }
        if (updateNeeded) {
            this.treeViewerManager.updateTreeViewer();
            this.sourceViewModelElements = null;
            this.targetViewModelElements = null;
            this.sourceSuperOrdinateElement = null;
            this.targetSuperOrdinateElement = null;
        }
    }

    @Override
    protected void addEntity(IModelElement entity) {
        this.updateEntityChanged(entity);
    }

    @Override
    protected void removeEntity(IModelElement entity) {
        this.updateEntityChanged(entity);
    }

    @Override
    protected void renameEntity(IModelElement entity) {
        IProjectRootElement rootElement = (IProjectRootElement)KernelModelElementUtils.getParentElement((EObject)entity, IProjectRootElement.class, (boolean)true);
        this.refresh(rootElement);
        if (rootElement == ((AllocationTable)this.getEditedObject()).getSourceView() || rootElement == ((AllocationTable)this.getEditedObject()).getTargetView()) {
            this.gui.getTreeViewer().refresh();
        }
    }

    @Override
    protected void valueSet(EObject eObject) {
        this.update((IProjectRootElement)KernelModelElementUtils.getParentElement((EObject)eObject, IProjectRootElement.class, (boolean)true));
    }

    protected TreeViewerManager<T> createTreeViewerManager(TreeViewer treeViewer) {
        return new TreeViewerManager(this, treeViewer);
    }

    @Override
    public void createPartControl(Composite parent) {
        this.checkConfiguration();
        this.gui = new AllocationTableEditorGUI(parent, 0);
        this.treeViewerManager = this.createTreeViewerManager(this.gui.getTreeViewer());
        this.treeViewerManager.setUpdateRefreshEnabled(false);
        IAllocationService as = IAllocationService.getInstance();
        IProjectRootElement sourceView = null;
        IProjectRootElement targetView = null;
        Collection<Object> sourceModels = Collections.emptyList();
        Collection<Object> targetModels = Collections.emptyList();
        if (this.getEditedObject() != null) {
            IProjectRootElement view;
            targetView = ((AllocationTable)this.getEditedObject()).getTargetView();
            targetModels = this.getModels(this.getTargetModelTypes());
            if (targetView == null && !targetModels.isEmpty()) {
                view = targetView = (IProjectRootElement)LambdaUtils.getFirst(targetModels).orElse(null);
                KernelModelElementUtils.runAsCommand((EObject)this.getEditedObject(), () -> ((AllocationTable)this.getEditedObject()).setTargetView(view));
            }
            sourceView = ((AllocationTable)this.getEditedObject()).getSourceView();
            sourceModels = this.getModels(this.getSourceModelTypes());
            if (sourceView == null && !sourceModels.isEmpty()) {
                view = sourceView = (IProjectRootElement)LambdaUtils.getFirst(sourceModels).orElse(null);
                KernelModelElementUtils.runAsCommand((EObject)this.getEditedObject(), () -> ((AllocationTable)this.getEditedObject()).setSourceView(view));
            }
        }
        this.setupModelSelectionComboBox(this.gui.getComboViewerSource(), arg_0 -> ((AllocationTable)((AllocationTable)this.getEditedObject())).setSourceView(arg_0), () -> ((AllocationTable)((AllocationTable)this.getEditedObject())).getSourceView());
        this.updateModelSelectionComboBox(this.gui.getComboViewerSource(), sourceModels, sourceView);
        this.setupModelSelectionComboBox(this.gui.getComboViewerTarget(), arg_0 -> ((AllocationTable)((AllocationTable)this.getEditedObject())).setTargetView(arg_0), () -> ((AllocationTable)((AllocationTable)this.getEditedObject())).getTargetView());
        this.updateModelSelectionComboBox(this.gui.getComboViewerTarget(), targetModels, targetView);
        Collection sourceEntityTypes = as.getSourceEntityTypes(this.allocationEntryType);
        this.setupEntityTypeComboBox(this.gui.getComboViewerSourceEntityType(), this::setSourceEntityType, this::getSourceEntityType);
        this.updateEntityTypeComboBox(this.gui.getComboViewerSourceEntityType(), sourceEntityTypes, sourceView, this::setSourceEntityType);
        Collection targetEntityTypes = as.getTargetEntityTypes(this.allocationEntryType);
        this.setupEntityTypeComboBox(this.gui.getComboViewerTargetEntityType(), this::setTargetEntityType, this::getTargetEntityType);
        this.updateEntityTypeComboBox(this.gui.getComboViewerTargetEntityType(), targetEntityTypes, targetView, this::setTargetEntityType);
        this.setupSuperOrdinateElementComboBox(this.gui.getComboViewerSourceSuperOrdinateElement(), this::setSourceSuperOrdinateElement, this::getSourceSuperOrdinateElement, this.gui.getComboViewerTargetSuperOrdinateElement(), this::getTargetSuperOrdinateElements, this::setTargetSuperOrdinateElement);
        this.setupSuperOrdinateElementComboBox(this.gui.getComboViewerTargetSuperOrdinateElement(), this::setTargetSuperOrdinateElement, this::getTargetSuperOrdinateElement, this.gui.getComboViewerSourceSuperOrdinateElement(), this::getSourceSuperOrdinateElements, this::setSourceSuperOrdinateElement);
        this.updateSuperOrdinateElementComboBox(this.gui.getComboViewerSourceSuperOrdinateElement(), this.getSourceSuperOrdinateElements(), this::setSourceSuperOrdinateElement);
        this.updateSuperOrdinateElementComboBox(this.gui.getComboViewerTargetSuperOrdinateElement(), this.getTargetSuperOrdinateElements(), this::setTargetSuperOrdinateElement);
        this.gui.getCheckboxShowSourceModelHierarchy().addSelectionListener((SelectionListener)new SourceModelHierarchyCheckBoxSelectionListener());
        Display.getCurrent().asyncExec(() -> {
            super.createPartControl(parent);
            this.treeViewerManager.setUpdateRefreshEnabled(true);
            this.treeViewerManager.updateTreeViewer();
        });
    }

    public Collection<IModelElement> getSourceSuperOrdinateElements() {
        if (this.sourceSuperOrdinateElements != null) {
            return this.sourceSuperOrdinateElements;
        }
        Class parentEntryType = IAllocationService.getInstance().getParentEntryType(this.getAllocationEntryType());
        if (parentEntryType == null) {
            return null;
        }
        this.sourceSuperOrdinateElements = new HashSet<IModelElement>();
        for (IModelElement element : this.getSourceViewModelElements()) {
            if (!AllocationUtils.isAllocated((AllocationTable)((AllocationTable)this.getEditedObject()), (Class)parentEntryType, (IModelElement)((IModelElement)element.eContainer()), (IModelElement)this.targetSuperOrdinateElement)) continue;
            this.sourceSuperOrdinateElements.add((IModelElement)element.eContainer());
        }
        return this.sourceSuperOrdinateElements;
    }

    public Collection<IModelElement> getTargetSuperOrdinateElements() {
        if (this.targetSuperOrdinateElements != null) {
            return this.targetSuperOrdinateElements;
        }
        Class parentEntryType = IAllocationService.getInstance().getParentEntryType(this.getAllocationEntryType());
        if (parentEntryType == null) {
            return null;
        }
        this.targetSuperOrdinateElements = new HashSet<IModelElement>();
        for (IModelElement element : this.getTargetViewModelElements()) {
            if (!AllocationUtils.isAllocated((AllocationTable)((AllocationTable)this.getEditedObject()), (Class)parentEntryType, (IModelElement)this.sourceSuperOrdinateElement, (IModelElement)((IModelElement)element.eContainer()))) continue;
            this.targetSuperOrdinateElements.add((IModelElement)element.eContainer());
        }
        return this.targetSuperOrdinateElements;
    }

    public boolean isShowModelHierarchy() {
        return this.gui.getCheckboxShowSourceModelHierarchy().getSelection();
    }

    private void setupEntityTypeComboBox(ComboViewer comboViewer, final Consumer<Class<? extends IModelElement>> setter, final Supplier<Class<? extends IModelElement>> getter) {
        comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Class) {
                    return ((Class)element).getSimpleName();
                }
                return null;
            }
        });
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Class entityType = (Class)SelectionUtils.checkAndPickFirstSafe((ISelection)event.getSelection(), Class.class);
                if (entityType != null && !entityType.equals(getter.get())) {
                    setter.accept(entityType);
                    AllocationTableEditor.this.treeViewerManager.updateTreeViewer();
                }
            }
        });
    }

    private void updateEntityTypeComboBox(ComboViewer comboViewer, Collection<Class<? extends IModelElement>> entityTypes, IProjectRootElement model, Consumer<Class<? extends IModelElement>> setter) {
        List usedEntityTypes;
        if (model == null) {
            usedEntityTypes = Collections.emptyList();
        } else {
            Predicate<Class> hasEntity = t -> EcoreUtils.getFirstChildWithType((EObject)model, (Class)t) != null || EcoreUtils.getFirstChildWithType((EObject)this.getEditedObject(), (Class)t) != null;
            usedEntityTypes = entityTypes.stream().filter(hasEntity).collect(Collectors.toList());
        }
        Combo combo = comboViewer.getCombo();
        combo.setEnabled(usedEntityTypes.size() > 1);
        if (!usedEntityTypes.isEmpty()) {
            Class entityType = (Class)SelectionUtils.checkAndPickFirstSafe((ISelection)comboViewer.getSelection(), Class.class);
            if (entityType == null || !usedEntityTypes.contains(entityType)) {
                entityType = (Class)usedEntityTypes.stream().findFirst().get();
                setter.accept(entityType);
            }
            comboViewer.setInput(usedEntityTypes);
            if (entityType != SelectionUtils.checkAndPickFirstSafe((ISelection)comboViewer.getSelection(), Class.class)) {
                comboViewer.setSelection((ISelection)new StructuredSelection((Object)entityType));
            }
        } else {
            setter.accept(null);
            comboViewer.setInput(null);
            if (SelectionUtils.checkAndPickFirstSafe((ISelection)comboViewer.getSelection(), Class.class) != null) {
                comboViewer.setSelection(null);
            }
        }
    }

    private <M extends IModelElement> void setupSuperOrdinateElementComboBox(final ComboViewer comboViewer, final Consumer<M> setter, final Supplier<M> getter, final ComboViewer comboViewer2, final Supplier<Collection<M>> getSuperOrdinateElements2, final Consumer<M> setter2) {
        comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return KernelUIUtils.getName((Object)element);
            }
        });
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IModelElement element = (IModelElement)SelectionUtils.checkAndPickFirstSafe((ISelection)event.getSelection(), IModelElement.class);
                if (element == null || !element.equals(getter.get())) {
                    setter.accept(element);
                    if (comboViewer == AllocationTableEditor.this.gui.getComboViewerSourceSuperOrdinateElement()) {
                        AllocationTableEditor.this.updateSuperOrdinateElementComboBox(comboViewer2, (Collection)getSuperOrdinateElements2.get(), setter2);
                    }
                    AllocationTableEditor.this.treeViewerManager.updateTreeViewer();
                }
            }
        });
        comboViewer.setComparator((ViewerComparator)new HierarchicalNameViewerComparator(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                if (o1 == comboEmptySelectionMarker) {
                    return -1;
                }
                if (o2 == comboEmptySelectionMarker) {
                    return 1;
                }
                return super.compare(viewer, o1, o2);
            }
        });
    }

    private <M extends IModelElement> void updateSuperOrdinateElementComboBox(ComboViewer comboViewer, Collection<M> superOrdinateElements, Consumer<M> setter) {
        Combo combo = comboViewer.getCombo();
        combo.setEnabled(superOrdinateElements != null);
        if (superOrdinateElements != null && !superOrdinateElements.isEmpty()) {
            Object selectedElement;
            IModelElement superOrdinateElement = (IModelElement)SelectionUtils.checkAndPickFirstSafe((ISelection)comboViewer.getSelection(), IModelElement.class);
            if (!superOrdinateElements.contains(superOrdinateElement)) {
                superOrdinateElement = null;
                setter.accept(null);
            }
            comboViewer.setInput(superOrdinateElements);
            comboViewer.add(comboEmptySelectionMarker);
            Object object = selectedElement = superOrdinateElement != null ? superOrdinateElement : comboEmptySelectionMarker;
            if (superOrdinateElement != SelectionUtils.checkAndPickFirstSafe((ISelection)comboViewer.getSelection(), IModelElement.class)) {
                comboViewer.setSelection((ISelection)new StructuredSelection(selectedElement));
            }
        } else {
            setter.accept(null);
            comboViewer.setInput(null);
            if (SelectionUtils.checkAndPickFirstSafe((ISelection)comboViewer.getSelection(), IModelElement.class) != null) {
                comboViewer.setSelection(null);
            }
        }
    }

    private Collection<IProjectRootElement> getModels(Collection<Class<? extends IProjectRootElement>> types) {
        if (this.uniqueSourceView && types.containsAll(this.getSourceModelTypes())) {
            for (AllocationTableCollection atc : KernelModelElementUtils.getRootElements((EObject)this.getEditedObject(), AllocationTableCollection.class)) {
                for (AllocationTable at : EcoreUtils.pickInstanceOf(((AllocationTable)this.getEditedObject()).getClass(), (List)atc.getAllocationTables())) {
                    if (at == this.getEditedObject() || at.getTargetView() != ((AllocationTable)this.getEditedObject()).getTargetView()) continue;
                    return Arrays.asList(at.getSourceView());
                }
            }
        }
        return KernelModelElementUtils.getRootElements((EObject)this.getEditedObject(), types);
    }

    private <S extends IModelElement> List<S> getModelViewElements(IProjectRootElement modelView, Class<? extends IModelElement> selectedEntityType, Collection<Class<? extends IModelElement>> entityTypes, ViewElementFilter elementFilter) {
        if (modelView == null || selectedEntityType == null) {
            return Collections.emptyList();
        }
        Collection modelElements = EcoreUtils.getChildrenWithType((EObject)modelView, selectedEntityType, entityTypes);
        return LambdaUtils.filterList((Collection)modelElements, (Predicate)(elementFilter != null ? elementFilter : e -> true));
    }

    public <S extends IModelElement> List<? extends IModelElement> getSourceViewModelElements() {
        if (this.sourceViewModelElements == null) {
            IAllocationService as = IAllocationService.getInstance();
            this.sourceViewModelElements = this.getModelViewElements(((AllocationTable)this.getEditedObject()).getSourceView(), this.getSourceEntityType(), as.getSourceEntityTypes(this.allocationEntryType), this.sourceViewElementFilter);
        }
        return this.sourceViewModelElements;
    }

    public List<? extends IModelElement> getTargetViewModelElements() {
        IAllocationService as = IAllocationService.getInstance();
        this.targetViewModelElements = this.getModelViewElements(((AllocationTable)this.getEditedObject()).getTargetView(), this.getTargetEntityType(), as.getTargetEntityTypes(this.allocationEntryType), this.targetViewElementFilter);
        return this.targetViewModelElements;
    }

    public AllocationTableEditorGUI getGUI() {
        return this.gui;
    }

    public String getToolTipSuffix(IModelElement element) {
        return null;
    }

    private class SourceModelHierarchyCheckBoxSelectionListener
    implements SelectionListener {
        private SourceModelHierarchyCheckBoxSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.updateTreeViewerShowSourceModelHierarchy();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void updateTreeViewerShowSourceModelHierarchy() {
            AllocationTableEditor.this.treeViewerManager.updateTreeViewer();
        }
    }

    public static interface ViewElementFilter
    extends Predicate<IModelElement> {
    }
}

