/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.allocation.ui.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.fortiss.af3.allocation.IAllocationService;
import org.fortiss.af3.allocation.model.AF3AllocationPackage;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.allocation.model.ParameterEntry;
import org.fortiss.af3.allocation.model.ParameterTable;
import org.fortiss.af3.allocation.model.ParameterTableReference;
import org.fortiss.af3.allocation.ui.editor.AllocationTableEditorGUI;
import org.fortiss.af3.allocation.ui.editor.ArchitectureParameterEditorGUI;
import org.fortiss.af3.allocation.ui.editor.ArchitectureParameterTableEditorBase;
import org.fortiss.af3.allocation.ui.editor.ModelListenerEditorBase;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.service.IElementCompositorService;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public abstract class ArchitectureParameterEditorBase<A extends ParameterTableReference, T extends ParameterTable>
extends ModelListenerEditorBase<A> {
    private Class<T> paramTableType;
    private Collection<Class<? extends AllocationTable>> archAllocationTableTypes;
    private ArchitectureParameterEditorGUI gui;
    private ArchitectureParameterTableEditorBase<A, T> parameterTableEditor;

    public ArchitectureParameterEditorBase(Class<T> paramTableType, Class<? extends ParameterEntry> paramEntryType) {
        super(Arrays.asList(AF3AllocationPackage.Literals.ALLOCATION_TABLE__SOURCE_VIEW, AF3AllocationPackage.Literals.ALLOCATION_TABLE__TARGET_VIEW));
        this.paramTableType = paramTableType;
        this.archAllocationTableTypes = ArchitectureParameterEditorBase.getArchitectureAllocationTableTypes(paramEntryType);
    }

    private static Collection<Class<? extends AllocationTable>> getArchitectureAllocationTableTypes(Class<? extends ParameterEntry> paramEntryType) {
        IAllocationService as = IAllocationService.getInstance();
        Collection paramTableTypes = as.getAllocationTableTypesForEntryType(paramEntryType);
        HashSet<Class<? extends AllocationTable>> rval = new HashSet<Class<? extends AllocationTable>>();
        for (Class parameterTableType : paramTableTypes) {
            HashSet atTypes = new HashSet();
            for (Class targetViewType : as.getTargetModelTypes(parameterTableType)) {
                atTypes.addAll(as.getAllocationTableTypesForTargetView(targetViewType));
            }
            for (Class sourceViewType : as.getSourceModelTypes(parameterTableType)) {
                atTypes.retainAll(as.getAllocationTableTypesForSourceView(sourceViewType));
            }
            rval.addAll(atTypes);
        }
        rval.removeIf(t -> ParameterTable.class.isAssignableFrom((Class<?>)t));
        return rval;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.parameterTableEditor != null) {
            this.parameterTableEditor.dispose();
        }
    }

    private void setParameterTableFromRootElement(IProjectRootElement atc) {
        ParameterTable paramTable = atc != null ? (ParameterTable)EcoreUtils.getFirstChildWithType((EObject)atc, this.paramTableType) : null;
        ((ParameterTableReference)this.getEditedObject()).getParameterTables().removeIf(t -> this.paramTableType.isAssignableFrom(t.getClass()));
        if (paramTable != null) {
            ((ParameterTableReference)this.getEditedObject()).getParameterTables().add((Object)paramTable);
        }
        if (this.parameterTableEditor != null) {
            this.parameterTableEditor.update(paramTable);
        }
    }

    private AllocationTableCollection getParameterTableRootElement() {
        return (AllocationTableCollection)KernelModelElementUtils.getParentElement(this.getParameterTable(), AllocationTableCollection.class, (boolean)false);
    }

    private T getParameterTable() {
        return (T)((ParameterTable)EcoreUtils.pickFirstInstanceOf(this.paramTableType, (List)((ParameterTableReference)this.getEditedObject()).getParameterTables()));
    }

    protected List<IProjectRootElement> getArchitectureAllocationTableCollections() {
        IAllocationService as = IAllocationService.getInstance();
        ArrayList<IProjectRootElement> rval = new ArrayList<IProjectRootElement>();
        Predicate<AllocationTable> hasSourceView = at -> at.getSourceView() == this.getEditedObject();
        for (Class<? extends AllocationTable> atType : this.archAllocationTableTypes) {
            Collection targetModelTypes = as.getTargetModelTypes(atType);
            Predicate<AllocationTable> isCorrectAllocationTableType = at -> atType.isAssignableFrom(at.getClass());
            Predicate<AllocationTable> hasTargetView = at -> targetModelTypes.stream().anyMatch(t -> t.isAssignableFrom(at.getTargetView().getClass()));
            Predicate<AllocationTableCollection> filterATC = atc -> atc.getAllocationTables().stream().anyMatch(isCorrectAllocationTableType.and(hasSourceView).and(hasTargetView));
            List atcs = KernelModelElementUtils.getRootElements((EObject)this.getEditedObject(), AllocationTableCollection.class);
            List atcsWithArchitectureToTargetViewTable = atcs.stream().filter(filterATC).collect(Collectors.toList());
            for (AllocationTableCollection atc2 : atcsWithArchitectureToTargetViewTable) {
                if (EcoreUtils.pickFirstInstanceOf(this.paramTableType, (List)atc2.getAllocationTables()) != null) continue;
                ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor(this.getEditedObject());
                ParameterTable paramTable = (ParameterTable)EcoreUtil.create((EClass)EcoreUtils.getEClassForClass(this.paramTableType));
                paramTable.setSourceView((IProjectRootElement)this.getEditedObject());
                AllocationTable architectureToHardwareAllocationTable = (AllocationTable)EcoreUtils.pickFirstInstanceOf(atType, (List)atc2.getAllocationTables());
                paramTable.setTargetView(architectureToHardwareAllocationTable.getTargetView());
                topLevel.runAsCommand(() -> {
                    IElementCompositorService.getInstance().compose((EObject)atc2, (EObject)paramTable, null);
                    this.setParameterTableFromRootElement((IProjectRootElement)atc2);
                });
            }
            rval.addAll(atcsWithArchitectureToTargetViewTable);
        }
        return rval;
    }

    protected abstract ArchitectureParameterTableEditorBase<A, T> createParameterTableEditor(A var1);

    @Override
    public void createPartControl(Composite parent) {
        this.gui = new ArchitectureParameterEditorGUI(parent, 0);
        this.setupModelSelectionComboBox(this.gui.getComboViewerAllocation(), this::setParameterTableFromRootElement, this::getParameterTableRootElement);
        if (!this.getArchitectureAllocationTableCollections().isEmpty() && this.getParameterTable() != null) {
            this.parameterTableEditor = this.createParameterTableEditor((ParameterTableReference)this.getEditedObject());
            this.parameterTableEditor.createPartControl(this.gui.getParameterTableComposite());
            AllocationTableEditorGUI parameterTableEditorGui = this.parameterTableEditor.getGUI();
            parameterTableEditorGui.getComboViewerSource().getControl().setEnabled(false);
            parameterTableEditorGui.getComboViewerTarget().getControl().setEnabled(false);
        } else {
            String atNames = this.archAllocationTableTypes.stream().map(t -> t.getSimpleName()).collect(Collectors.joining(", "));
            Label label = new Label(this.gui.getParameterTableComposite(), 0);
            label.setText("\n\n\n  Please create an Allocation with any of the following allocation tables in order to define parameters (and restart this editor): \"" + atNames + "\"");
        }
        this.refresh();
        super.createPartControl(parent);
    }

    private void refresh() {
        ParameterTable parameterTable;
        List<IProjectRootElement> allocationTableCollections = this.getArchitectureAllocationTableCollections();
        AllocationTableCollection selectedAtc = null;
        if (!allocationTableCollections.isEmpty() && (selectedAtc = this.getParameterTableRootElement()) == null) {
            selectedAtc = allocationTableCollections.get(0);
        }
        this.updateModelSelectionComboBox(this.gui.getComboViewerAllocation(), allocationTableCollections, (IProjectRootElement)selectedAtc);
        T currentParamTable = this.getParameterTable();
        AllocationTableCollection atc = selectedAtc;
        if (currentParamTable != null && currentParamTable.getAllocationTableCollection() != atc && atc != null && (parameterTable = (ParameterTable)EcoreUtils.getFirstChildWithType((EObject)atc, this.paramTableType)) != this.getParameterTable()) {
            KernelModelElementUtils.runAsCommand((EObject)this.getEditedObject(), () -> this.lambda$11((IProjectRootElement)atc));
        }
    }

    @Override
    protected boolean modelSelectionChanged(IProjectRootElement model, Consumer<IProjectRootElement> modelSetter, Supplier<IProjectRootElement> modelGetter) {
        boolean rval = super.modelSelectionChanged(model, modelSetter, modelGetter);
        KernelModelElementUtils.runAsCommand((EObject)model, () -> this.setParameterTableFromRootElement(model));
        return rval;
    }

    @Override
    protected boolean isEditedEntity(Object object) {
        return this.archAllocationTableTypes.stream().anyMatch(t -> t.isAssignableFrom(object.getClass()));
    }

    @Override
    protected void addEntity(IModelElement entity) {
        this.refresh();
    }

    @Override
    protected void removeEntity(IModelElement entity) {
        this.refresh();
    }

    @Override
    protected void renameEntity(IModelElement entity) {
        this.refresh();
    }

    @Override
    protected void valueSet(EObject eObject) {
        this.refresh();
    }

    @Override
    protected boolean isEditedModel(Object object) {
        return false;
    }

    @Override
    protected void comboViewerOpened(ComboViewer viewer) {
    }

    private /* synthetic */ void lambda$11(IProjectRootElement iProjectRootElement) {
        this.setParameterTableFromRootElement(iProjectRootElement);
    }
}

