/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.allocation.ui.editor;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.fortiss.af3.allocation.model.AF3AllocationPackage;
import org.fortiss.af3.allocation.model.AllocationEntry;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.ui.editor.GEFEditorBase;
import org.fortiss.tooling.kernel.model.FortissToolingKernelPackage;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.ui.util.KernelUIUtils;
import org.fortiss.tooling.kernel.ui.util.SelectionUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public abstract class ModelListenerEditorBase<T extends EObject>
extends GEFEditorBase<T> {
    private FileProject fileProject;
    private List<EStructuralFeature> observedFeatures;
    private Adapter fileProjectListener = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            int eventType = notification.getEventType();
            if (eventType == 8) {
                return;
            }
            if (ModelListenerEditorBase.this.getEditedObject() == null) {
                return;
            }
            Object notifier = notification.getNotifier();
            Object oldValue = notification.getOldValue();
            Object newValue = notification.getNewValue();
            Display display = Display.getDefault();
            Object feature = notification.getFeature();
            if (eventType == 3) {
                boolean isRightNotifier;
                boolean bl = isRightNotifier = !(notifier instanceof AllocationEntry) || ModelListenerEditorBase.this.observedFeatures.contains(feature);
                if (isRightNotifier && ModelListenerEditorBase.this.isEditedEntity(newValue)) {
                    IModelElement entity = (IModelElement)newValue;
                    display.syncExec(() -> ModelListenerEditorBase.this.addEntity(entity));
                }
            } else if (eventType == 4) {
                boolean isRightNotifier;
                boolean bl = isRightNotifier = !(notifier instanceof AllocationEntry) || ModelListenerEditorBase.this.observedFeatures.contains(feature);
                if (isRightNotifier && ModelListenerEditorBase.this.isEditedEntity(oldValue)) {
                    IModelElement entity = (IModelElement)oldValue;
                    display.syncExec(() -> ModelListenerEditorBase.this.removeEntity(entity));
                }
            } else if (eventType == 1) {
                EObject value;
                if (feature == FortissToolingKernelPackage.Literals.INAMED_ELEMENT__NAME) {
                    if (notifier instanceof IModelElement) {
                        display.syncExec(() -> ModelListenerEditorBase.this.renameEntity((IModelElement)notifier));
                    }
                } else if ((ModelListenerEditorBase.this.observedFeatures.contains(feature) || feature.equals(AF3AllocationPackage.Literals.ALLOCATION_TABLE__SOURCE_VIEW) || feature.equals(AF3AllocationPackage.Literals.ALLOCATION_TABLE__TARGET_VIEW)) && notifier instanceof EObject && (value = (EObject)notifier).eContainer() != null) {
                    display.syncExec(() -> ModelListenerEditorBase.this.valueSet(value));
                }
            }
        }
    };

    public ModelListenerEditorBase(List<EStructuralFeature> observedFeatures) {
        this.observedFeatures = observedFeatures;
    }

    protected abstract boolean isEditedModel(Object var1);

    protected abstract boolean isEditedEntity(Object var1);

    protected abstract void addEntity(IModelElement var1);

    protected abstract void removeEntity(IModelElement var1);

    protected abstract void renameEntity(IModelElement var1);

    protected abstract void valueSet(EObject var1);

    protected abstract void comboViewerOpened(ComboViewer var1);

    protected void setupModelSelectionComboBox(ComboViewer comboViewer, Consumer<IProjectRootElement> modelSetter, Supplier<IProjectRootElement> modelGetter) {
        comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return KernelUIUtils.getName((Object)element);
            }
        });
        comboViewer.addSelectionChangedListener((ISelectionChangedListener)new ModelViewComboBoxSelectionListener(modelSetter, modelGetter));
        comboViewer.getCombo().addFocusListener((FocusListener)new ModelViewComboBoxFocusListener(comboViewer));
    }

    protected void updateModelSelectionComboBox(ComboViewer comboViewer, Collection<IProjectRootElement> models, IProjectRootElement selectedModel) {
        comboViewer.setInput(models);
        Combo combo = comboViewer.getCombo();
        if (combo.getItemCount() == 0) {
            combo.deselectAll();
        } else if (combo.getSelectionIndex() == -1) {
            int i = 0;
            while (i < combo.getItems().length) {
                if (comboViewer.getElementAt(i) == selectedModel) {
                    combo.select(i);
                    break;
                }
                ++i;
            }
        }
    }

    protected boolean modelSelectionChanged(IProjectRootElement model, Consumer<IProjectRootElement> modelSetter, Supplier<IProjectRootElement> modelGetter) {
        IProjectRootElement oldModel = modelGetter.get();
        if (model != oldModel) {
            KernelModelElementUtils.runAsCommand((EObject)this.getEditedObject(), () -> modelSetter.accept(model));
            return true;
        }
        return false;
    }

    protected FileProject getFileProject() {
        return (FileProject)EcoreUtils.getFirstParentWithType((EObject)this.getEditedObject(), FileProject.class);
    }

    public void createPartControl(Composite parent) {
        this.fileProject = this.getFileProject();
        this.fileProject.eAdapters().add((Object)this.fileProjectListener);
    }

    public void dispose() {
        super.dispose();
        this.fileProject.eAdapters().remove((Object)this.fileProjectListener);
    }

    private class ModelViewComboBoxFocusListener
    implements FocusListener {
        private ComboViewer comboViewer;

        public ModelViewComboBoxFocusListener(ComboViewer comboViewer) {
            this.comboViewer = comboViewer;
        }

        public void focusLost(FocusEvent e) {
        }

        public void focusGained(FocusEvent e) {
            ModelListenerEditorBase.this.comboViewerOpened(this.comboViewer);
        }
    }

    private class ModelViewComboBoxSelectionListener
    implements ISelectionChangedListener {
        private Consumer<IProjectRootElement> modelSetter;
        private Supplier<IProjectRootElement> modelGetter;

        public ModelViewComboBoxSelectionListener(Consumer<IProjectRootElement> modelSetter, Supplier<IProjectRootElement> modelGetter) {
            this.modelSetter = modelSetter;
            this.modelGetter = modelGetter;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            IProjectRootElement rootElement = (IProjectRootElement)SelectionUtils.checkAndPickFirst((ISelection)selection, IProjectRootElement.class);
            if (rootElement != null && ModelListenerEditorBase.this.modelSelectionChanged(rootElement, this.modelSetter, this.modelGetter)) {
                this.setViewFromSelection(selection, this.modelSetter, this.modelGetter);
            }
        }

        private void setViewFromSelection(ISelection selection, Consumer<IProjectRootElement> modelSetter, Supplier<IProjectRootElement> modelGetter) {
            IProjectRootElement newModel = (IProjectRootElement)SelectionUtils.checkAndPickFirst((ISelection)selection, IProjectRootElement.class);
            if (newModel != null && newModel != modelGetter.get()) {
                KernelModelElementUtils.runAsCommand((EObject)ModelListenerEditorBase.this.getEditedObject(), () -> modelSetter.accept(newModel));
            }
        }
    }
}

