/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.allocation.ui.editor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.TreeViewer;
import org.fortiss.af3.allocation.model.ParameterEntry;
import org.fortiss.af3.allocation.model.ParameterTable;
import org.fortiss.af3.allocation.ui.editor.AllocationTableEditor;
import org.fortiss.af3.allocation.ui.editor.treeviewer.ParameterTableTreeViewerManager;
import org.fortiss.af3.allocation.ui.editor.treeviewer.TreeViewerManager;
import org.fortiss.tooling.base.model.element.IAnnotatedSpecification;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class ParameterTableEditor<T extends ParameterTable>
extends AllocationTableEditor<T> {
    private Class<? extends IAnnotatedSpecification> annotationType;
    private Collection<Class<? extends IAnnotatedSpecification>> sourceEntityAnnotationTypes;

    private static List<EStructuralFeature> getStructuralFeatures(Class<? extends IAnnotatedSpecification> annotationType, Collection<Class<? extends IAnnotatedSpecification>> sourceEntityAnnotationTypes, Collection<Class<? extends IAnnotatedSpecification>> extraAnnotationTypes) {
        HashSet rval = new HashSet(EcoreUtils.getEClassForClass(annotationType).getEAllStructuralFeatures());
        if (sourceEntityAnnotationTypes != null) {
            for (Class<? extends IAnnotatedSpecification> clazz : sourceEntityAnnotationTypes) {
                rval.addAll(EcoreUtils.getEClassForClass(clazz).getEAllStructuralFeatures());
            }
        }
        if (extraAnnotationTypes != null) {
            for (Class<? extends IAnnotatedSpecification> clazz : extraAnnotationTypes) {
                rval.addAll(EcoreUtils.getEClassForClass(clazz).getEAllStructuralFeatures());
            }
        }
        return rval.stream().collect(Collectors.toList());
    }

    public ParameterTableEditor(Class<? extends ParameterEntry> allocationEntryType, Class<? extends IAnnotatedSpecification> annotationType, Collection<Class<? extends IAnnotatedSpecification>> sourceEntityAnnotationTypes, AllocationTableEditor.ViewElementFilter sourceViewElementFilter, AllocationTableEditor.ViewElementFilter targetViewElementFilter, Collection<Class<? extends IAnnotatedSpecification>> extraAnnotationTypes) {
        super(allocationEntryType, sourceViewElementFilter, targetViewElementFilter, false, false, ParameterTableEditor.getStructuralFeatures(annotationType, sourceEntityAnnotationTypes, extraAnnotationTypes));
        this.annotationType = annotationType;
        this.sourceEntityAnnotationTypes = sourceEntityAnnotationTypes;
    }

    public ParameterTableEditor(Class<? extends ParameterEntry> allocationEntryType, Class<? extends IAnnotatedSpecification> annotationType) {
        this(allocationEntryType, annotationType, Collections.emptyList(), null, null, null);
    }

    @Override
    protected TreeViewerManager<T> createTreeViewerManager(TreeViewer treeViewer) {
        return new ParameterTableTreeViewerManager(this, treeViewer, this.annotationType, this.sourceEntityAnnotationTypes);
    }

    @Override
    protected void valueSet(EObject eObject) {
        this.getGUI().getTreeViewer().refresh();
    }
}

