/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.allocation.ui.editor.treeviewer;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.fortiss.af3.allocation.model.ParameterEntry;
import org.fortiss.af3.allocation.model.ParameterTable;
import org.fortiss.af3.allocation.ui.editor.treeviewer.ParameterTableTreeViewerManager;
import org.fortiss.af3.allocation.utils.AllocationUtils;
import org.fortiss.tooling.base.model.element.IAnnotatedSpecification;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class ParameterEntryTreeViewerEditingSupport<T extends ParameterTable>
extends EditingSupport {
    private T parameterTable;
    private ParameterTableTreeViewerManager<T> treeViewerManager;
    private Class<? extends ParameterEntry> parameterEntryType;
    private IModelElement targetElement;
    private Class<? extends IAnnotatedSpecification> annotationType;
    private boolean hasSourceViewHiddenRootElement;
    private CellEditor cellEditor;

    public ParameterEntryTreeViewerEditingSupport(T parameterTable, ParameterTableTreeViewerManager<T> treeViewerManager, Class<? extends ParameterEntry> parameterEntryType, IModelElement targetElement, Class<? extends IAnnotatedSpecification> annotationType, boolean hasSourceViewHiddenRootElement, ColumnViewer viewer) {
        super(viewer);
        this.parameterTable = parameterTable;
        this.treeViewerManager = treeViewerManager;
        this.parameterEntryType = parameterEntryType;
        this.targetElement = targetElement;
        this.annotationType = annotationType;
        this.hasSourceViewHiddenRootElement = hasSourceViewHiddenRootElement;
        this.cellEditor = this.createCellEditor(annotationType);
    }

    private CellEditor createCellEditor(Class<? extends IAnnotatedSpecification> annotationType) {
        EClass eClass = EcoreUtils.getEClassForClass(annotationType);
        EList featureList = eClass.getEStructuralFeatures();
        if (featureList.size() != 1 || !(featureList.get(0) instanceof EAttribute)) {
            return null;
        }
        EAttribute annotationEAttribute = (EAttribute)featureList.get(0);
        EClassifier type = annotationEAttribute.getEType();
        if (type instanceof EEnum) {
            EList allLiterals = ((EEnum)type).getELiterals();
            List entries = allLiterals.stream().map(l -> l.getLiteral()).collect(Collectors.toList());
            ComboBoxViewerCellEditor comboCellEditor = new ComboBoxViewerCellEditor((Composite)this.getViewer().getControl(), 8);
            comboCellEditor.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            comboCellEditor.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            entries.add(0, "");
            comboCellEditor.setInput(entries);
            return comboCellEditor;
        }
        if (type instanceof EClass) {
            return null;
        }
        return new TextCellEditor((Composite)this.getViewer().getControl(), 0);
    }

    protected boolean canEdit(Object element) {
        if (element instanceof IModelElement) {
            IModelElement sourceElement = (IModelElement)element;
            return this.treeViewerManager.isModifiableAllocationEntry(this.parameterEntryType, sourceElement, this.targetElement, null, this.hasSourceViewHiddenRootElement);
        }
        return false;
    }

    protected CellEditor getCellEditor(Object element) {
        return this.cellEditor;
    }

    protected Object getValue(Object element) {
        if (element instanceof IModelElement) {
            String value = AllocationUtils.getParameterEntryValue(this.parameterTable, (IModelElement)((IModelElement)element), (IModelElement)this.targetElement, this.parameterEntryType, this.annotationType);
            return value != null ? value : "";
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        if (element instanceof IModelElement) {
            IModelElement sourceElement = (IModelElement)element;
            this.treeViewerManager.setAllocationEntryValue(this.parameterEntryType, sourceElement, this.targetElement, value);
            this.getViewer().refresh(true);
        }
    }
}

