/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.allocation.ui.editor.treeviewer;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.fortiss.af3.allocation.model.ParameterEntry;
import org.fortiss.af3.allocation.model.ParameterTable;
import org.fortiss.af3.allocation.ui.editor.ParameterTableEditor;
import org.fortiss.af3.allocation.utils.AllocationUtils;
import org.fortiss.tooling.base.annotation.AnnotationEntry;
import org.fortiss.tooling.base.model.element.IAnnotatedSpecification;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.ui.annotation.view.AnnotationViewUtils;
import org.fortiss.tooling.kernel.ui.util.KernelUIUtils;

public class ParameterEntryTreeViewerLabelProvider<T extends ParameterTable>
extends ColumnLabelProvider {
    private ParameterTableEditor<T> parameterTableEditor;
    private Class<? extends ParameterEntry> parameterEntryType;
    private Class<? extends IModelElement> sourceEntityType;
    private IModelElement targetElement;
    private Class<? extends IAnnotatedSpecification> annotationType;

    public ParameterEntryTreeViewerLabelProvider(ParameterTableEditor<T> parameterTableEditor, Class<? extends ParameterEntry> parameterEntryType, Class<? extends IModelElement> sourceEntityType, IModelElement targetElement, Class<? extends IAnnotatedSpecification> annotationType) {
        this.parameterTableEditor = parameterTableEditor;
        this.parameterEntryType = parameterEntryType;
        this.sourceEntityType = sourceEntityType;
        this.targetElement = targetElement;
        this.annotationType = annotationType;
    }

    private boolean isApplicable(Object element) {
        return element instanceof IModelElement && this.sourceEntityType.isAssignableFrom(element.getClass());
    }

    public String getText(Object element) {
        if (this.isApplicable(element)) {
            return AllocationUtils.getParameterEntryValue((ParameterTable)((ParameterTable)this.parameterTableEditor.getEditedObject()), (IModelElement)((IModelElement)element), (IModelElement)this.targetElement, this.parameterEntryType, this.annotationType);
        }
        return null;
    }

    private String getParameterToolTipLabelPrefix(IModelElement sourceElement) {
        String parameterToolTipLabel = AllocationUtils.getParameterEntryName((ParameterTable)((ParameterTable)this.parameterTableEditor.getEditedObject()), (IModelElement)sourceElement, (IModelElement)this.targetElement, this.parameterEntryType, this.annotationType);
        return parameterToolTipLabel + " of\n";
    }

    public String getToolTipText(Object object) {
        if (this.isApplicable(object)) {
            IModelElement sourceElement = (IModelElement)object;
            String toolTipText = this.getParameterToolTipLabelPrefix(sourceElement) + KernelUIUtils.getName((Object)sourceElement) + " \n\u2192\n" + KernelUIUtils.getName((Object)this.targetElement);
            String toolTipSuffix = this.parameterTableEditor.getToolTipSuffix(this.targetElement);
            if (toolTipSuffix != null) {
                toolTipText = toolTipText + "\n" + toolTipSuffix;
            }
            return toolTipText;
        }
        return null;
    }

    public int getToolTipStyle(Object object) {
        return 0x1000000;
    }

    public Color getBackground(Object object) {
        if (this.isApplicable(object)) {
            AnnotationEntry annotationEntry = AllocationUtils.getAnnotationEntry((ParameterTable)((ParameterTable)this.parameterTableEditor.getEditedObject()), (IModelElement)((IModelElement)object), (IModelElement)this.targetElement, this.parameterEntryType, this.annotationType);
            Color color = super.getBackground(object);
            if (annotationEntry != null) {
                return AnnotationViewUtils.getSWTBackgroundColorForEntry((AnnotationEntry)annotationEntry, this.annotationType, (Color)color);
            }
            return color;
        }
        return AnnotationViewUtils.READ_ONLY_EMPTY_ANNOTATION_BACKGROUND_COLOR_SWT;
    }
}

