/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.allocation.ui.editor.treeviewer;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TreeViewer;
import org.fortiss.af3.allocation.model.AllocationEntry;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.model.ParameterEntry;
import org.fortiss.af3.allocation.model.ParameterTable;
import org.fortiss.af3.allocation.ui.editor.AllocationTableEditor;
import org.fortiss.af3.allocation.ui.editor.ParameterTableEditor;
import org.fortiss.af3.allocation.ui.editor.treeviewer.ParameterEntryTreeViewerEditingSupport;
import org.fortiss.af3.allocation.ui.editor.treeviewer.ParameterEntryTreeViewerLabelProvider;
import org.fortiss.af3.allocation.ui.editor.treeviewer.ParameterSourceElementTreeViewerEditingSupport;
import org.fortiss.af3.allocation.ui.editor.treeviewer.ParameterSourceElementTreeViewerLabelProvider;
import org.fortiss.af3.allocation.ui.editor.treeviewer.TreeViewerFirstColumnLabelProvider;
import org.fortiss.af3.allocation.ui.editor.treeviewer.TreeViewerManager;
import org.fortiss.af3.allocation.utils.AllocationUtils;
import org.fortiss.tooling.base.annotation.AnnotationEntry;
import org.fortiss.tooling.base.annotation.IAnnotationValueService;
import org.fortiss.tooling.base.model.element.IAnnotatedSpecification;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class ParameterTableTreeViewerManager<T extends ParameterTable>
extends TreeViewerManager<T> {
    private static final int SOURCE_ENTITY_ANNOTATION_COLUMN_DEFAULT_WIDTH = 100;
    private Class<? extends IAnnotatedSpecification> annotationType;
    private Collection<Class<? extends IAnnotatedSpecification>> sourceEntityAnnotationTypes;

    public ParameterTableTreeViewerManager(AllocationTableEditor<T> allocationTableEditor, TreeViewer treeViewer, Class<? extends IAnnotatedSpecification> annotationType, Collection<Class<? extends IAnnotatedSpecification>> sourceEntityAnnotationTypes) {
        super(allocationTableEditor, treeViewer);
        this.annotationType = annotationType;
        this.sourceEntityAnnotationTypes = sourceEntityAnnotationTypes;
    }

    @Override
    protected ColumnLabelProvider createColumnLabelProvider(Class<? extends AllocationEntry> allocationEntryType, Class<? extends IModelElement> sourceEntityType, IModelElement targetElement) {
        return new ParameterEntryTreeViewerLabelProvider((ParameterTableEditor)this.allocationTableEditor, allocationEntryType, sourceEntityType, targetElement, this.annotationType);
    }

    @Override
    protected EditingSupport createEditingSupport(AllocationTable allocationTable, Class<? extends AllocationEntry> allocationEntryType, IModelElement targetElement) {
        return new ParameterEntryTreeViewerEditingSupport<ParameterTable>((ParameterTable)allocationTable, this, allocationEntryType, targetElement, this.annotationType, this.allocationTableEditor.hasSourceViewHiddenRootElement(), (ColumnViewer)this.treeViewer);
    }

    @Override
    protected String getColumnLabel(int columnWidth, IModelElement targetElement, boolean showContainerName, TreeViewerFirstColumnLabelProvider<T> firstColumnLabelProvider) {
        String columnLabel = super.getColumnLabel(columnWidth, targetElement, showContainerName, firstColumnLabelProvider);
        String parameterName = AllocationUtils.getParameterEntryName((ParameterTable)((ParameterTable)this.allocationTableEditor.getEditedObject()), null, (IModelElement)targetElement, this.allocationTableEditor.getAllocationEntryType(), this.annotationType);
        return parameterName + ": " + columnLabel;
    }

    @Override
    protected TreeViewerFirstColumnLabelProvider<T> createFirstColumns(List<Integer> columnWidths) {
        TreeViewerFirstColumnLabelProvider firstColumnLabelProvider = super.createFirstColumns(columnWidths);
        int i = 1;
        for (Class<? extends IAnnotatedSpecification> at : this.sourceEntityAnnotationTypes) {
            int width = 100;
            if (i < columnWidths.size()) {
                width = columnWidths.get(i);
            }
            this.createSourceEntityAnnotationColumn(at, width, i);
            ++i;
        }
        return firstColumnLabelProvider;
    }

    private void createSourceEntityAnnotationColumn(Class<? extends IAnnotatedSpecification> annotationType, int width, int number) {
        EList modelElements;
        String columnLabel = null;
        if (this.allocationTableEditor.getEditedObject() != null && !(modelElements = EcoreUtils.pickInstanceOf(this.allocationTableEditor.getSourceEntityType(), this.allocationTableEditor.getSourceViewModelElements())).isEmpty()) {
            columnLabel = ParameterTableTreeViewerManager.getAnnotationName((IModelElement)modelElements.get(0), annotationType);
        }
        if (columnLabel == null) {
            columnLabel = annotationType.getSimpleName();
        }
        ParameterSourceElementTreeViewerLabelProvider labelProvider = new ParameterSourceElementTreeViewerLabelProvider(annotationType, this.allocationTableEditor.getSourceEntityType());
        ParameterSourceElementTreeViewerEditingSupport editingSupport = new ParameterSourceElementTreeViewerEditingSupport(annotationType, this.allocationTableEditor.getSourceEntityType(), (ColumnViewer)this.treeViewer);
        this.createTreeViewerColumn(width, columnLabel, null, null, labelProvider, editingSupport, number);
    }

    public static Class<? extends IAnnotatedSpecification> getAnnotationType(AnnotationEntry annotationEntry, Class<? extends IAnnotatedSpecification> annotationType) {
        return annotationEntry.getSpecification(annotationType).getClass();
    }

    public static String getAnnotationName(IModelElement element, Class<? extends IAnnotatedSpecification> annotationType) {
        AnnotationEntry annotationEntry = IAnnotationValueService.getInstance().getAnnotationEntry(element);
        String annotationName = annotationEntry.getSpecificationAnnotationName(ParameterTableTreeViewerManager.getAnnotationType(annotationEntry, annotationType));
        return annotationName;
    }

    public void setAllocationEntryValue(Class<? extends ParameterEntry> entryType, IModelElement sourceElement, IModelElement targetElement, Object value) {
        ParameterTable parameterTable = (ParameterTable)this.allocationTableEditor.getEditedObject();
        KernelModelElementUtils.runAsCommand((EObject)parameterTable, () -> {
            if (value != null && !value.equals("")) {
                AllocationUtils.setParameterEntryValue((ParameterTable)parameterTable, (IModelElement)sourceElement, (IModelElement)targetElement, (Object)value, (Class)entryType, this.annotationType);
            } else {
                AllocationUtils.deleteAllocationEntry((AllocationTable)parameterTable, (Class)entryType, (IModelElement)sourceElement, (IModelElement)targetElement, (boolean)false);
            }
        });
        modifiableCache.clear();
    }
}

