/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.allocation.ui.editor.treeviewer;

import org.eclipse.jface.viewers.ColumnViewer;
import org.fortiss.af3.allocation.model.AllocationEntry;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.ui.editor.treeviewer.TreeViewerManager;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.ui.viewers.CheckBoxEditingSupport;

public class TreeViewerCheckBoxEditingSupport<T extends AllocationTable>
extends CheckBoxEditingSupport {
    private TreeViewerManager<T> treeViewerManager;
    private Class<? extends AllocationEntry> allocationEntryType;
    private IModelElement targetElement;
    private Class<? extends AllocationEntry> parentEntryType;
    private boolean hasSourceViewHiddenRootElement;

    public TreeViewerCheckBoxEditingSupport(TreeViewerManager<T> treeViewerManager, Class<? extends AllocationEntry> allocationEntryType, IModelElement targetElement, Class<? extends AllocationEntry> parentEntryType, boolean hasSourceViewHiddenRootElement, ColumnViewer viewer) {
        super(viewer);
        this.treeViewerManager = treeViewerManager;
        this.allocationEntryType = allocationEntryType;
        this.targetElement = targetElement;
        this.parentEntryType = parentEntryType;
        this.hasSourceViewHiddenRootElement = hasSourceViewHiddenRootElement;
    }

    protected boolean canEdit(Object element) {
        if (element instanceof IModelElement) {
            IModelElement sourceElement = (IModelElement)element;
            return this.treeViewerManager.isModifiableAllocationEntry(this.allocationEntryType, sourceElement, this.targetElement, this.parentEntryType, this.hasSourceViewHiddenRootElement);
        }
        return false;
    }

    protected Boolean getBooleanValue(Object element) {
        if (element instanceof IModelElement) {
            IModelElement sourceElement = (IModelElement)element;
            return this.treeViewerManager.isAllocated(this.allocationEntryType, sourceElement, this.targetElement);
        }
        return false;
    }

    protected void setBooleanValue(Object element, Boolean value) {
        if (element instanceof IModelElement) {
            IModelElement sourceElement = (IModelElement)element;
            if (value.booleanValue() != this.treeViewerManager.isAllocated(this.allocationEntryType, sourceElement, this.targetElement)) {
                this.treeViewerManager.setAllocationEntryValue(this.allocationEntryType, sourceElement, this.targetElement, value);
                this.getViewer().refresh();
            }
        }
    }
}

