/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.allocation.ui.editor.treeviewer;

import org.eclipse.swt.graphics.Image;
import org.fortiss.af3.allocation.model.AllocationEntry;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.ui.editor.treeviewer.TreeViewerManager;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.ui.viewers.CheckBoxLabelProvider;
import org.fortiss.tooling.kernel.ui.util.KernelUIUtils;

public class TreeViewerCheckBoxLabelProvider<T extends AllocationTable>
extends CheckBoxLabelProvider {
    private TreeViewerManager<T> treeViewerManager;
    private Class<? extends AllocationEntry> allocationEntryType;
    private Class<? extends IModelElement> sourceEntityType;
    private IModelElement targetElement;
    private Class<? extends AllocationEntry> parentEntryType;
    private boolean hasSourceViewHiddenRootElement;

    public TreeViewerCheckBoxLabelProvider(TreeViewerManager<T> treeViewerManager, Class<? extends AllocationEntry> allocationEntryType, Class<? extends IModelElement> sourceEntityType, IModelElement targetElement, Class<? extends AllocationEntry> parentEntryType, boolean hasSourceViewHiddenRootElement) {
        this.treeViewerManager = treeViewerManager;
        this.allocationEntryType = allocationEntryType;
        this.sourceEntityType = sourceEntityType;
        this.targetElement = targetElement;
        this.parentEntryType = parentEntryType;
        this.hasSourceViewHiddenRootElement = hasSourceViewHiddenRootElement;
    }

    protected boolean isChecked(Object element) {
        if (element instanceof IModelElement) {
            IModelElement sourceElement = (IModelElement)element;
            return this.treeViewerManager.isAllocated(this.allocationEntryType, sourceElement, this.targetElement);
        }
        return false;
    }

    protected boolean isEnabled(Object element) {
        if (element instanceof IModelElement) {
            IModelElement sourceElement = (IModelElement)element;
            return this.treeViewerManager.isModifiableAllocationEntry(this.allocationEntryType, sourceElement, this.targetElement, this.parentEntryType, this.hasSourceViewHiddenRootElement);
        }
        return false;
    }

    public Image getImage(Object element) {
        if (element != null && this.sourceEntityType.isAssignableFrom(element.getClass())) {
            return super.getImage(element);
        }
        return null;
    }

    public String getToolTipText(Object object) {
        if (object instanceof IModelElement) {
            return KernelUIUtils.getName((Object)object) + " \n\u2192\n" + KernelUIUtils.getName((Object)this.targetElement);
        }
        return null;
    }

    public int getToolTipStyle(Object object) {
        return 0x1000000;
    }
}

