/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.allocation.ui.editor.treeviewer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.ide.commons.ui.jface.TreeContentProviderBase;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.ui.editor.AllocationTableEditor;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.ui.extension.IModelElementHandler;
import org.fortiss.tooling.kernel.ui.service.IModelElementHandlerService;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class TreeViewerContentProvider<T extends AllocationTable>
extends TreeContentProviderBase {
    private final AllocationTableEditor<T> allocationTableEditor;
    private Map<Object, Object[]> childrenCache = new HashMap<Object, Object[]>();
    private Map<Object, Object> parentCache = new HashMap<Object, Object>();

    public TreeViewerContentProvider(AllocationTableEditor<T> allocationTableEditor) {
        this.allocationTableEditor = allocationTableEditor;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = this.childrenCache.get(parentElement);
        if (children != null) {
            return children;
        }
        Class<IModelElement> sourceEntityType = this.allocationTableEditor.getSourceEntityType();
        if (sourceEntityType != null && this.allocationTableEditor.isShowModelHierarchy()) {
            EObject node;
            IModelElementHandlerService modelElementHandlerService;
            IModelElementHandler nodeHandler;
            if (parentElement instanceof EObject && (nodeHandler = (modelElementHandlerService = IModelElementHandlerService.getInstance()).getModelElementHandler(node = (EObject)parentElement)) != null) {
                ArrayList<EObject> rval = new ArrayList<EObject>();
                for (EObject subNode : nodeHandler.getSubnodes(node)) {
                    boolean containsSourceEntity;
                    IModelElementHandler subNodeHandler = modelElementHandlerService.getModelElementHandler(subNode);
                    if (subNodeHandler == null) continue;
                    boolean isAtomicSourceEntity = sourceEntityType.isAssignableFrom(subNode.getClass()) && subNodeHandler.getSubnodes(subNode).isEmpty();
                    boolean bl = containsSourceEntity = EcoreUtils.getFirstChildWithType((EObject)subNode, sourceEntityType) != null;
                    if (!isAtomicSourceEntity && !containsSourceEntity) continue;
                    rval.add(subNode);
                }
                rval.addAll((Collection<EObject>)EcoreUtils.pickInstanceOf(sourceEntityType, (List)nodeHandler.getConnectors(node)));
                if (!rval.isEmpty()) {
                    children = rval.toArray();
                }
            }
        } else if (parentElement == ((AllocationTable)this.allocationTableEditor.getEditedObject()).getSourceView()) {
            children = this.allocationTableEditor.getSourceViewModelElements().toArray();
        }
        if (children != null) {
            this.childrenCache.put(parentElement, children);
            return children;
        }
        return new Object[0];
    }

    public void refresh() {
        this.childrenCache.clear();
        this.parentCache.clear();
    }

    public Object getParent(Object inputElement) {
        Object parent = this.parentCache.get(inputElement);
        if (parent != null) {
            return parent;
        }
        if (inputElement == ((AllocationTable)this.allocationTableEditor.getEditedObject()).getSourceView() || !(inputElement instanceof EObject)) {
            return null;
        }
        EObject eobj = (EObject)inputElement;
        do {
            eobj = eobj.eContainer();
            EObject rval = null;
            while (eobj != null && Arrays.stream(this.getChildren(eobj)).anyMatch(e -> e == inputElement)) {
                rval = eobj;
                eobj = eobj.eContainer();
            }
            if (rval == null) continue;
            this.parentCache.put(inputElement, rval);
            return rval;
        } while (eobj != null);
        return null;
    }
}

