/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.allocation.ui.editor.treeviewer;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.ui.editor.AllocationTableEditor;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.ui.util.KernelUIUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class TreeViewerFirstColumnLabelProvider<T extends AllocationTable>
extends ColumnLabelProvider {
    static final String ELLIPSIS = "...";
    private final AllocationTableEditor<T> allocationTableEditor;
    private TreeViewer treeViewer;
    private TreeViewerColumn column;
    private GC gc;

    public TreeViewerFirstColumnLabelProvider(AllocationTableEditor<T> allocationTableEditor, TreeViewer treeViewer, TreeViewerColumn column) {
        this.allocationTableEditor = allocationTableEditor;
        this.treeViewer = treeViewer;
        this.column = column;
        this.gc = new GC((Drawable)treeViewer.getTree());
        allocationTableEditor.getGUI().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TreeViewerFirstColumnLabelProvider.this.gc.dispose();
            }
        });
    }

    public Image getImage(Object element) {
        return KernelUIUtils.getImage((Object)element);
    }

    public String getText(Object element) {
        return this.getTrimmedColumnLabel(element, this.column.getColumn().getWidth(), !this.allocationTableEditor.isShowModelHierarchy(), 0);
    }

    public String getToolTipText(Object object) {
        if (object instanceof INamedElement) {
            return KernelModelElementUtils.computeFullyQualifiedName((INamedElement)((INamedElement)object), (boolean)false);
        }
        return null;
    }

    public String getTrimmedColumnLabel(Object element, int columnWidth, boolean showContainerName, int reservedWidth) {
        String label = showContainerName ? this.getNameWithContainer(element) : KernelUIUtils.getName((Object)element);
        boolean trimLeft = element instanceof IConnector && !this.allocationTableEditor.isShowModelHierarchy();
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.treeViewer.getContentProvider();
        do {
            reservedWidth += 25;
        } while ((element = contentProvider.getParent(element)) != null);
        String rval = this.trimTextToPixelWidth(label, this.gc, columnWidth - reservedWidth, trimLeft);
        return rval;
    }

    private String getNameWithContainer(Object element) {
        String elementName;
        EObject container;
        String containerName = null;
        if (element instanceof IConnector && (container = ((IConnector)element).eContainer()) != null) {
            containerName = KernelUIUtils.getName((Object)container);
        }
        if ((elementName = KernelUIUtils.getName((Object)element)) != null) {
            return containerName != null ? containerName + "." + elementName : elementName;
        }
        return null;
    }

    private String trimTextToPixelWidth(String text, GC gc, int targetWidth, boolean trimLeft) {
        if (targetWidth <= 0) {
            return ELLIPSIS;
        }
        Point sizeText = gc.textExtent(text);
        double ratio = (double)sizeText.x / (double)targetWidth;
        if (ratio <= 1.0) {
            return text;
        }
        int targetLength = (int)((double)text.length() / ratio);
        if (trimLeft) {
            int offset = Math.min(Math.max(text.length() - targetLength + ELLIPSIS.length(), 0), text.length() - 1);
            return ELLIPSIS + text.substring(offset);
        }
        return text.substring(0, Math.max(0, targetLength - ELLIPSIS.length())) + ELLIPSIS;
    }
}

