/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.allocation.ui.editor.treeviewer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.fortiss.af3.allocation.IAllocationService;
import org.fortiss.af3.allocation.model.AllocationEntry;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.ui.editor.AllocationTableEditor;
import org.fortiss.af3.allocation.ui.editor.treeviewer.TreeViewerCheckBoxEditingSupport;
import org.fortiss.af3.allocation.ui.editor.treeviewer.TreeViewerCheckBoxLabelProvider;
import org.fortiss.af3.allocation.ui.editor.treeviewer.TreeViewerContentProvider;
import org.fortiss.af3.allocation.ui.editor.treeviewer.TreeViewerFirstColumnLabelProvider;
import org.fortiss.af3.allocation.utils.AllocationUtils;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.ui.util.HierarchicalNameViewerComparator;
import org.fortiss.tooling.kernel.ui.util.KernelUIUtils;
import org.fortiss.tooling.kernel.utils.HierarchicalNameComparator;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class TreeViewerManager<T extends AllocationTable> {
    private static final int COLUMN_HEADER_OFFSET = 15;
    public static final int ROW_LABEL_OFFSET = 0;
    public static final int ROW_LABEL_INDENT = 25;
    private static final int FIRST_COLUMN_DEFAULT_WIDTH = 150;
    private static final int ENTRY_COLUMN_DEFAULT_WIDTH = 100;
    protected final AllocationTableEditor<T> allocationTableEditor;
    protected TreeViewer treeViewer;
    private HierarchicalNameComparator columnComparator = new HierarchicalNameComparator();
    private TreeViewerContentProvider<T> contentProvider;
    private static MultiKeyMap<Object, Boolean> allocationCache = new MultiKeyMap();
    protected static MultiKeyMap<Object, Boolean> modifiableCache = new MultiKeyMap();
    private boolean updateRefreshEnabled;

    public TreeViewerManager(final AllocationTableEditor<T> allocationTableEditor, TreeViewer treeViewer) {
        this.allocationTableEditor = allocationTableEditor;
        this.treeViewer = treeViewer;
        this.updateRefreshEnabled = true;
        this.contentProvider = new TreeViewerContentProvider<T>(allocationTableEditor);
        treeViewer.setContentProvider(this.contentProvider);
        treeViewer.setComparator((ViewerComparator)new HierarchicalNameViewerComparator());
        treeViewer.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IModelElement sourceSuperOrdinateElement = allocationTableEditor.getSourceSuperOrdinateElement();
                return TreeViewerManager.this.isMatchSuperOrdinateElement(element, sourceSuperOrdinateElement, allocationTableEditor.getSourceSuperOrdinateElements());
            }
        }});
    }

    private boolean isMatchSuperOrdinateElement(Object element, IModelElement selectedSuperOrdinateElement, Collection<? extends IModelElement> superOrdinateElements) {
        if (!(element instanceof EObject)) {
            return false;
        }
        if (selectedSuperOrdinateElement == null) {
            if (superOrdinateElements == null) {
                return true;
            }
            for (IModelElement iModelElement : superOrdinateElements) {
                if (!this.isMatchSuperOrdinateElementInternal(element, iModelElement)) continue;
                return true;
            }
            return false;
        }
        return this.isMatchSuperOrdinateElementInternal(element, selectedSuperOrdinateElement);
    }

    private boolean isMatchSuperOrdinateElementInternal(Object element, IModelElement selectedSuperOrdinateElement) {
        EObject eObj = (EObject)element;
        while (eObj != null) {
            if (eObj == selectedSuperOrdinateElement) {
                return true;
            }
            eObj = eObj.eContainer();
        }
        eObj = selectedSuperOrdinateElement;
        while (eObj != null) {
            if (eObj == element) {
                return true;
            }
            eObj = eObj.eContainer();
        }
        return false;
    }

    public boolean isAllocated(Class<? extends AllocationEntry> entryType, IModelElement sourceElement, IModelElement targetElement) {
        Boolean b = (Boolean)allocationCache.get(entryType, (Object)sourceElement, (Object)targetElement);
        if (b == null) {
            b = AllocationUtils.isAllocated((AllocationTable)((AllocationTable)this.allocationTableEditor.getEditedObject()), entryType, (IModelElement)sourceElement, (IModelElement)targetElement);
            allocationCache.put(entryType, (Object)sourceElement, (Object)targetElement, (Object)b);
        }
        return b;
    }

    public boolean isModifiableAllocationEntry(Class<? extends AllocationEntry> entryType, IModelElement sourceElement, IModelElement targetElement, Class<? extends AllocationEntry> parentEntryType, boolean hasSourceViewHiddenRootElement) {
        Boolean b = (Boolean)modifiableCache.get(entryType, (Object)sourceElement, (Object)targetElement, parentEntryType);
        if (b == null) {
            b = AllocationUtils.isModifiableAllocationEntry((AllocationTable)((AllocationTable)this.allocationTableEditor.getEditedObject()), entryType, (IModelElement)sourceElement, (IModelElement)targetElement, parentEntryType, (boolean)hasSourceViewHiddenRootElement);
            modifiableCache.put(entryType, (Object)sourceElement, (Object)targetElement, parentEntryType, (Object)b);
        }
        return b;
    }

    public void setAllocationEntryValue(Class<? extends AllocationEntry> entryType, IModelElement sourceElement, IModelElement targetElement, boolean value) {
        AllocationTable allocationTable = (AllocationTable)this.allocationTableEditor.getEditedObject();
        KernelModelElementUtils.runAsCommand((EObject)allocationTable, () -> {
            if (value) {
                AllocationUtils.addAllocationEntry((AllocationTable)allocationTable, (Class)entryType, (IModelElement)sourceElement, (IModelElement)targetElement);
                allocationCache.put((Object)entryType, (Object)sourceElement, (Object)targetElement, (Object)value);
            } else {
                AllocationUtils.deleteAllocationEntry((AllocationTable)allocationTable, (Class)entryType, (IModelElement)sourceElement, (IModelElement)targetElement, (boolean)true);
                allocationCache.removeMultiKey((Object)entryType, (Object)sourceElement, (Object)targetElement);
            }
        });
        this.purgeModifiableCache(entryType, sourceElement, targetElement, allocationTable);
    }

    private void purgeModifiableCache(Class<? extends AllocationEntry> entryType, IModelElement sourceElement, IModelElement targetElement, T allocationTable) {
        IAllocationService as = IAllocationService.getInstance();
        Collection entryTypes = as.getAllocationEntryTypes(allocationTable.getClass(), new Class[0]);
        modifiableCache.removeMultiKey(entryType, (Object)sourceElement, (Object)targetElement, null);
        LambdaUtils.asStream((Iterator)sourceElement.eAllContents()).forEach(childSrc -> LambdaUtils.asStream((Iterator)targetElement.eAllContents()).forEach(childTgt -> entryTypes.stream().forEach(et -> modifiableCache.removeMultiKey(et, childSrc, childTgt, (Object)entryType))));
    }

    public void updateTreeViewer() {
        if (!this.updateRefreshEnabled) {
            return;
        }
        allocationCache.clear();
        modifiableCache.clear();
        this.contentProvider.refresh();
        Tree tree = this.treeViewer.getTree();
        tree.setRedraw(false);
        ArrayList<Integer> firstColumnsWidth = new ArrayList<Integer>();
        HashMap<IModelElement, Integer> entryColumnsWidthMap = new HashMap<IModelElement, Integer>();
        TreeColumn[] treeColumnArray = tree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            if (column.getData() == null) {
                firstColumnsWidth.add(column.getWidth());
            } else if (column.getData() instanceof IModelElement) {
                entryColumnsWidthMap.put((IModelElement)column.getData(), column.getWidth());
            }
            column.dispose();
            ++n2;
        }
        AllocationTable allocationTable = (AllocationTable)this.allocationTableEditor.getEditedObject();
        TreeViewerFirstColumnLabelProvider<T> firstColumnLabelProvider = this.createFirstColumns(firstColumnsWidth);
        this.createEntryColumns(firstColumnLabelProvider, entryColumnsWidthMap);
        Display display = Display.getCurrent();
        display.asyncExec(() -> {
            IProjectRootElement input = allocationTable != null ? allocationTable.getSourceView() : null;
            Object currentInput = this.treeViewer.getInput();
            if (currentInput == null || !currentInput.equals(input)) {
                this.treeViewer.setInput((Object)input);
            }
            this.treeViewer.expandToLevel(2);
            this.treeViewer.refresh();
            this.sortColumns();
            tree.setRedraw(true);
        });
    }

    public void refreshTreeViewer() {
        if (!this.updateRefreshEnabled) {
            return;
        }
        this.treeViewer.refresh();
        TreeColumn[] treeColumnArray = this.treeViewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn treeColumn = treeColumnArray[n2];
            if (treeColumn.getData() instanceof INamedElement) {
                treeColumn.setWidth(treeColumn.getWidth());
            }
            ++n2;
        }
        this.sortColumns();
    }

    public boolean setUpdateRefreshEnabled(boolean updateRefreshEnabled) {
        boolean rval = this.updateRefreshEnabled;
        this.updateRefreshEnabled = updateRefreshEnabled;
        return rval;
    }

    protected TreeViewerColumn createTreeViewerColumn(int width, String text, String toolTipText, Image image, ColumnLabelProvider labelProvider, EditingSupport editingSupport, Object columnData) {
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn treeColumn = treeViewerColumn.getColumn();
        treeColumn.setWidth(width);
        treeColumn.setText(text);
        treeColumn.setToolTipText(toolTipText);
        treeColumn.setImage(image);
        treeColumn.setData(columnData);
        if (labelProvider != null) {
            treeViewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
        }
        if (editingSupport != null) {
            treeViewerColumn.setEditingSupport(editingSupport);
        }
        return treeViewerColumn;
    }

    protected TreeViewerFirstColumnLabelProvider<T> createFirstColumns(List<Integer> columnWidths) {
        String columnLabel = "\u2193 Src. | Tgt. \u2192";
        int width = 150;
        if (!columnWidths.isEmpty()) {
            width = columnWidths.get(0);
        }
        final TreeViewerColumn firstColumn = this.createTreeViewerColumn(width, "\u2193 Src. | Tgt. \u2192", null, null, null, null, 0);
        TreeViewerFirstColumnLabelProvider<T> labelProvider = new TreeViewerFirstColumnLabelProvider<T>(this.allocationTableEditor, this.treeViewer, firstColumn);
        firstColumn.setLabelProvider(labelProvider);
        firstColumn.getColumn().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                super.controlResized(e);
                firstColumn.getViewer().refresh();
            }
        });
        return labelProvider;
    }

    private void createEntryColumns(final TreeViewerFirstColumnLabelProvider<T> firstColumnLabelProvider, Map<IModelElement, Integer> columnWidthMap) {
        AllocationTable allocationTable = (AllocationTable)this.allocationTableEditor.getEditedObject();
        List<Object> targetModelElements = allocationTable != null ? this.allocationTableEditor.getTargetViewModelElements() : Collections.emptyList();
        for (final IModelElement targetElement : targetModelElements) {
            if (!this.isMatchSuperOrdinateElement(targetElement, this.allocationTableEditor.getTargetSuperOrdinateElement(), this.allocationTableEditor.getTargetSuperOrdinateElements())) continue;
            int columnWidth = columnWidthMap.get(targetElement) != null ? columnWidthMap.get(targetElement) : 100;
            final boolean showContainerName = targetElement instanceof IConnector;
            String label = this.getColumnLabel(columnWidth, targetElement, showContainerName, firstColumnLabelProvider);
            String toolTipText = firstColumnLabelProvider.getToolTipText(targetElement);
            Image image = KernelUIUtils.getImage((Object)targetElement);
            ColumnLabelProvider labelProvider = this.createColumnLabelProvider(this.allocationTableEditor.getAllocationEntryType(), this.allocationTableEditor.getSourceEntityType(), targetElement);
            EditingSupport editingSupport = this.createEditingSupport(allocationTable, this.allocationTableEditor.getAllocationEntryType(), targetElement);
            final TreeViewerColumn treeViewerColumn = this.createTreeViewerColumn(columnWidth, label, toolTipText, image, labelProvider, editingSupport, targetElement);
            final TreeColumn treeColumn = treeViewerColumn.getColumn();
            treeColumn.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    super.controlResized(e);
                    treeColumn.setText(TreeViewerManager.this.getColumnLabel(treeViewerColumn.getColumn().getWidth(), targetElement, showContainerName, firstColumnLabelProvider));
                }
            });
        }
        this.sortColumns();
    }

    private void sortColumns() {
        TreeColumn[] treeColumns;
        Tree tree = this.treeViewer.getTree();
        TreeColumn[] sortedColumns = tree.getColumns();
        Arrays.sort(sortedColumns, new Comparator<TreeColumn>(){

            @Override
            public int compare(TreeColumn t1, TreeColumn t2) {
                Object d1 = t1.getData();
                Object d2 = t2.getData();
                if (d1 == null) {
                    return -1;
                }
                if (d2 == null) {
                    return 1;
                }
                if (d1 instanceof Integer) {
                    if (d2 instanceof Integer) {
                        return ((Integer)d1).compareTo((Integer)d2);
                    }
                    return -1;
                }
                if (d2 instanceof Integer) {
                    return 1;
                }
                return TreeViewerManager.this.columnComparator.compare(d1, d2);
            }
        });
        int[] columnOrder = new int[sortedColumns.length];
        int i = 0;
        TreeColumn[] treeColumnArray = treeColumns = tree.getColumns();
        int n = treeColumns.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            int index = 0;
            TreeColumn[] treeColumnArray2 = sortedColumns;
            int n3 = sortedColumns.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeColumn sc = treeColumnArray2[n4];
                if (column == sc) {
                    columnOrder[index] = i;
                    break;
                }
                ++index;
                ++n4;
            }
            ++i;
            ++n2;
        }
        tree.setColumnOrder(columnOrder);
    }

    protected String getColumnLabel(int columnWidth, IModelElement targetElement, boolean showContainerName, TreeViewerFirstColumnLabelProvider<T> firstColumnLabelProvider) {
        return firstColumnLabelProvider.getTrimmedColumnLabel(targetElement, columnWidth, showContainerName, 15);
    }

    protected ColumnLabelProvider createColumnLabelProvider(Class<? extends AllocationEntry> allocationEntryType, Class<? extends IModelElement> sourceEntityType, IModelElement targetElement) {
        IAllocationService as = IAllocationService.getInstance();
        return new TreeViewerCheckBoxLabelProvider(this, allocationEntryType, sourceEntityType, targetElement, as.getParentEntryType(allocationEntryType), this.allocationTableEditor.hasSourceViewHiddenRootElement());
    }

    protected EditingSupport createEditingSupport(AllocationTable allocationTable, Class<? extends AllocationEntry> allocationEntryType, IModelElement targetElement) {
        IAllocationService as = IAllocationService.getInstance();
        return new TreeViewerCheckBoxEditingSupport(this, allocationEntryType, targetElement, as.getParentEntryType(allocationEntryType), this.allocationTableEditor.hasSourceViewHiddenRootElement(), (ColumnViewer)this.treeViewer);
    }
}

