/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.timing.ui.handler;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.timing.model.EventChain;
import org.fortiss.af3.timing.ui.AF3TimingUIActivator;
import org.fortiss.af3.timing.ui.handler.TimingSpecificationElementHandlerBase;

public class EventChainHandler
extends TimingSpecificationElementHandlerBase<EventChain> {
    @Override
    protected String getPluginId() {
        return AF3TimingUIActivator.PLUGIN_ID;
    }

    protected String getIconPath(EventChain element) {
        return "icons/event_chain.png";
    }

    public String getName(EventChain eventChain) {
        String stimulusLabel = this.getEventLabel(eventChain.getStimulus());
        String responseLabel = this.getEventLabel(eventChain.getResponse());
        return stimulusLabel + " \u2192 " + responseLabel;
    }

    public List<EObject> getSubnodes(EventChain eventChain) {
        return Stream.concat(eventChain.getSubchains().stream(), eventChain.getConstraints().stream()).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public int getNavigatorViewWeight(EventChain eventChain) {
        EventChain parentChain = eventChain.getParentChain();
        if (parentChain != null) {
            return parentChain.getSubchains().indexOf((Object)eventChain);
        }
        return super.getNavigatorViewWeight((EObject)eventChain);
    }
}

