/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.timing.ui.properties;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fortiss.af3.timing.model.EntityEvent;
import org.fortiss.af3.timing.model.Event;
import org.fortiss.af3.timing.model.EventConstraint;
import org.fortiss.af3.timing.model.TimingConstraint;
import org.fortiss.af3.timing.model.TimingSpecification;
import org.fortiss.af3.timing.ui.properties.EventConstraintPropertySectionBase;
import org.fortiss.af3.timing.utils.TimingModelElementFactory;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.base.EReferenceListPropertySectionBase;
import org.fortiss.tooling.kernel.ui.extension.base.IListPropertySection;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public abstract class EventListConstraintPropertySectionBase<T extends EventConstraint>
extends EventConstraintPropertySectionBase<T>
implements IListPropertySection<T, EntityEvent> {
    private EReferenceListPropertySectionBase.ElementListViewerComposite<T, EntityEvent> listViewerComposite;
    private IModelElement selectedEntity;
    private EntityEvent selectedEvent;

    public EventListConstraintPropertySectionBase(EReference eventRef) {
        super(eventRef);
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.listViewerComposite = new EReferenceListPropertySectionBase.ElementListViewerComposite<T, EntityEvent>(this.composite, 0, this.getWidgetFactory(), this){

            protected boolean isAddButtonEnabled() {
                return super.isAddButtonEnabled() && EventListConstraintPropertySectionBase.this.getModelValue(EventListConstraintPropertySectionBase.this.getSectionInput()) != null;
            }
        };
        this.createFormEntry((Control)this.listViewerComposite, "");
    }

    @Override
    public void refresh() {
        super.refresh();
        this.listViewerComposite.refresh();
    }

    public void addModelListElement(T input, EntityEvent event) {
        this.addEntityEvent(input, event);
        this.selectedEntity = null;
    }

    public void removeModelListElement(T input, EntityEvent event) {
        this.getModelListElements((EObject)input).remove(event);
        TimingSpecification ts = this.getTimingSpecification(input);
        if (ts.getConstraints((Event)event).isEmpty() && ts.getEventChains((Event)event).isEmpty()) {
            EcoreUtil.delete((EObject)event);
        }
    }

    public EntityEvent getSelectedElement() {
        TimingSpecification ts = this.getTimingSpecification((EventConstraint)this.input);
        Class<EntityEvent> entityEventType = this.getEntityEventType();
        IModelElement entity = this.getModelValue((T)((EventConstraint)this.input));
        EntityEvent event = ts.getEvent(entity, entityEventType);
        if (event != null) {
            this.selectedEvent = event;
            return event;
        }
        if (this.selectedEvent != null && entityEventType.isAssignableFrom(this.selectedEvent.getClass()) && this.selectedEvent.getReference() == entity) {
            return this.selectedEvent;
        }
        IPersistencyService ps = IPersistencyService.getInstance();
        ITopLevelElement topLevelElement = ps.getTopLevelElementFor((EObject)this.input);
        topLevelElement.runAsNonDirtyingCommand(() -> {
            this.selectedEvent = TimingModelElementFactory.createEntityEvent((Class)entityEventType, (IModelElement)entity);
        });
        return this.selectedEvent;
    }

    public T getSectionInput() {
        return (T)((EventConstraint)this.input);
    }

    @Override
    protected List<IModelElement> getValues(T input) {
        List<IModelElement> rval = super.getValues(input);
        TimingSpecification ts = this.getTimingSpecification(input);
        Class<?> eventReferenceType = input.getClass();
        if (TimingConstraint.class.isAssignableFrom(eventReferenceType)) {
            Class<?> constraintType = eventReferenceType;
            for (EntityEvent event : ts.getEvents(this.getEntityEventType())) {
                if (EcoreUtils.pickInstanceOf(constraintType, (List)ts.getConstraints((Event)event)).isEmpty()) continue;
                rval.remove(event.getEntity());
            }
        }
        return rval;
    }

    protected final IModelElement getModelValue(T input) {
        return this.selectedEntity;
    }

    @Override
    protected final void setModelValue(T input, IModelElement newValue) {
        this.selectedEntity = newValue;
    }
}

