/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.timing.ui.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fortiss.af3.timing.ITimingSpecificationService;
import org.fortiss.af3.timing.model.EntityEvent;
import org.fortiss.af3.timing.model.Event;
import org.fortiss.af3.timing.model.EventReference;
import org.fortiss.af3.timing.model.TimingSpecification;
import org.fortiss.af3.timing.ui.properties.TimeValuePropertySectionTextManager;
import org.fortiss.af3.timing.utils.TimingModelElementFactory;
import org.fortiss.af3.timing.utils.TimingUtils;
import org.fortiss.tooling.base.model.element.ElementPackage;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.ui.extension.base.EReferencePropertySectionBase;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public abstract class EventReferencePropertySectionBase<I extends EventReference>
extends EReferencePropertySectionBase<I, IModelElement> {
    private EventReferencePropertySectionSyncAdapter syncAdapter;
    protected EReference eventRef;
    private ComboViewer entityEventTypeComboViewer;
    private boolean entityEventTypeComboViewerUserSelection = false;
    protected I input;
    private TimeValuePropertySectionTextManager timeValueTexts = new TimeValuePropertySectionTextManager();

    public EventReferencePropertySectionBase(String label, EReference eventRef, EReference otherEventRef) {
        super(label);
        this.eventRef = eventRef;
        if (otherEventRef != null) {
            this.syncAdapter = new EventReferencePropertySectionSyncAdapter(otherEventRef);
        }
    }

    public EventReferencePropertySectionBase(EReference eventRef) {
        this("Model element", eventRef, null);
    }

    protected void createTimeValueTextFormEntry(String label, EAttribute eAttribute, IValidator validator) {
        this.timeValueTexts.createTimeValueTextFormEntry(arg_0 -> ((EventReferencePropertySectionBase)this).createDecoratedFormText(arg_0), label, eAttribute, validator);
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.entityEventTypeComboViewer = this.createEntityEventTypeComboViewer();
    }

    protected boolean isTimeValueTextsEnabled() {
        EObject entity = this.getModelValue(this.input);
        boolean hasEntity = entity != null;
        boolean hasOtherEntity = true;
        if (this.syncAdapter != null) {
            Object otherEvent = this.input.eGet((EStructuralFeature)this.syncAdapter.getOtherEventRef());
            boolean bl = hasOtherEntity = otherEvent instanceof Event && ((Event)otherEvent).getEntity() != null;
        }
        return hasEntity && hasOtherEntity;
    }

    private ComboViewer createEntityEventTypeComboViewer() {
        final ComboViewer entityEventTypeComboViewer = this.createDecoratedComboViewer("Event type");
        ITimingSpecificationService tss = ITimingSpecificationService.getInstance();
        String initialSection = null;
        for (Class eventType : tss.getEntityEventTypes()) {
            String eventTypeName = tss.getEventTypeName(eventType);
            entityEventTypeComboViewer.add((Object)eventTypeName);
            if (initialSection != null) continue;
            initialSection = eventTypeName;
        }
        entityEventTypeComboViewer.setSelection((ISelection)new StructuredSelection(initialSection));
        entityEventTypeComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Class<EntityEvent> newValue = EventReferencePropertySectionBase.this.getEntityEventType(event.getSelection());
                Class<EntityEvent> oldValue = EventReferencePropertySectionBase.this.getEntityEventTypeModelValue(EventReferencePropertySectionBase.this.input);
                if (EventReferencePropertySectionBase.this.entityEventTypeComboViewerUserSelection) {
                    if (oldValue != null && !newValue.isAssignableFrom(oldValue)) {
                        KernelModelElementUtils.runAsCommand(EventReferencePropertySectionBase.this.input, () -> EventReferencePropertySectionBase.this.setEntityEventTypeModelValue(EventReferencePropertySectionBase.this.input, oldValue, newValue));
                        List<IModelElement> values = EventReferencePropertySectionBase.this.getValues(EventReferencePropertySectionBase.this.input);
                        if (values.isEmpty()) {
                            EventReferencePropertySectionBase.this.entityEventTypeComboViewerUserSelection = false;
                            ITimingSpecificationService tss = ITimingSpecificationService.getInstance();
                            entityEventTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)tss.getEventTypeName(oldValue)));
                            EventReferencePropertySectionBase.this.entityEventTypeComboViewerUserSelection = true;
                        } else if (!values.contains(EventReferencePropertySectionBase.this.getModelValue(EventReferencePropertySectionBase.this.input))) {
                            KernelModelElementUtils.runAsCommand(EventReferencePropertySectionBase.this.input, () -> EventReferencePropertySectionBase.this.setModelValue(EventReferencePropertySectionBase.this.input, null));
                        }
                    }
                    EventReferencePropertySectionBase.this.refresh();
                }
            }
        });
        return entityEventTypeComboViewer;
    }

    private Class<? extends EntityEvent> getEntityEventTypeModelValue(I input) {
        EntityEvent event = this.getEntityEvent(input);
        return event != null ? event.getClass() : null;
    }

    private void setEntityEventTypeModelValue(I input, Class<? extends EntityEvent> oldEntityEventType, Class<? extends EntityEvent> newEntityEventType) {
        IModelElement element = (IModelElement)this.getModelValue(input);
        TimingSpecification ts = this.getTimingSpecification(input);
        if (ts.getEvent(element, newEntityEventType) == null) {
            EntityEvent oldEvent = ts.getEvent(element, oldEntityEventType);
            if (TimingUtils.getCanonicalEventReferences((TimingSpecification)ts, (Event)oldEvent).size() == 1) {
                EcoreUtil.delete((EObject)oldEvent);
            }
            EntityEvent event = TimingModelElementFactory.createEntityEvent(newEntityEventType, (IModelElement)element);
            this.addEntityEvent(input, event);
        }
    }

    public void refresh() {
        super.refresh();
        if (this.input == null) {
            return;
        }
        this.entityEventTypeComboViewerUserSelection = false;
        Class<EntityEvent> entityEventType = this.getEntityEventTypeModelValue(this.input);
        if (entityEventType != null) {
            ITimingSpecificationService tss = ITimingSpecificationService.getInstance();
            String eventTypeName = tss.getEventTypeName(entityEventType);
            this.entityEventTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)eventTypeName));
        }
        this.entityEventTypeComboViewerUserSelection = true;
        this.timeValueTexts.refresh((EObject)this.input, this.isTimeValueTextsEnabled(), (arg_0, arg_1, arg_2, arg_3) -> ((EventReferencePropertySectionBase)this).bindBigDecimalValue(arg_0, arg_1, arg_2, arg_3));
    }

    public void dispose() {
        super.dispose();
        if (this.syncAdapter != null) {
            this.syncAdapter.remove();
        }
    }

    protected void setSectionInput(Object input) {
        if (this.syncAdapter != null) {
            this.syncAdapter.remove();
        }
        super.setSectionInput(input);
        this.input = (EventReference)input;
        if (this.syncAdapter != null) {
            this.syncAdapter.add();
        }
    }

    protected EObject getModelValue(I input) {
        EntityEvent event = this.getEntityEvent(input);
        return event != null ? event.getEntity() : null;
    }

    protected void setModelValue(I input, IModelElement newValue) {
        EntityEvent event = this.getEntityEvent(input);
        TimingSpecification ts = this.getTimingSpecification(input);
        if (event == null && (event = ts.getEvent(newValue, this.getEntityEventType())) != null) {
            input.setEvent((Event)event, this.eventRef);
            return;
        }
        if (event == null || TimingUtils.getCanonicalEventReferences((TimingSpecification)ts, (Event)event).size() > 1) {
            EntityEvent newEvent = TimingModelElementFactory.createEntityEvent(this.getEntityEventType(), (IModelElement)newValue);
            this.addEntityEvent(input, newEvent);
        } else {
            event.setReference(newValue);
        }
        this.timeValueTexts.updateEnabledTextControls(this.isTimeValueTextsEnabled());
    }

    protected List<IModelElement> getValues(I input) {
        EReference otherEventRef;
        Object otherEvent;
        Class<EntityEvent> entityEventType = this.getEntityEventType();
        TimingSpecification ts = this.getTimingSpecification(input);
        if (ts == null || entityEventType == null) {
            return Collections.emptyList();
        }
        ArrayList<IModelElement> rval = new ArrayList<IModelElement>();
        ITimingSpecificationService tss = ITimingSpecificationService.getInstance();
        for (IProjectRootElement rootElement : ts.getRootElements()) {
            for (Class elementType : tss.getElementTypes(entityEventType)) {
                rval.addAll((Collection<IModelElement>)EcoreUtils.getChildrenWithType((EObject)rootElement, (Class)elementType));
            }
        }
        if (this.syncAdapter != null && (otherEvent = input.eGet((EStructuralFeature)(otherEventRef = this.syncAdapter.getOtherEventRef()))) instanceof Event && this.getEntityEventType().isAssignableFrom(otherEvent.getClass())) {
            rval.remove(((Event)otherEvent).getEntity());
        }
        return rval;
    }

    protected TimingSpecification getTimingSpecification(I input) {
        return (TimingSpecification)KernelModelElementUtils.getParentElement(input, TimingSpecification.class, (boolean)false);
    }

    private Class<? extends EntityEvent> getEntityEventType(ISelection selection) {
        IStructuredSelection structuredSelection;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).getFirstElement() instanceof String) {
            String label = (String)structuredSelection.getFirstElement();
            ITimingSpecificationService tss = ITimingSpecificationService.getInstance();
            Class eventType = label != null ? tss.getEventType(label) : null;
            return EntityEvent.class.isAssignableFrom(eventType) ? eventType : null;
        }
        return null;
    }

    protected Class<? extends EntityEvent> getEntityEventType() {
        return this.getEntityEventType(this.entityEventTypeComboViewer.getSelection());
    }

    private EntityEvent getEntityEvent(I input) {
        Object obj = input.eGet((EStructuralFeature)this.eventRef);
        return obj instanceof EntityEvent ? (EntityEvent)obj : null;
    }

    protected void addEntityEvent(I input, EntityEvent event) {
        TimingSpecification ts = this.getTimingSpecification(input);
        EntityEvent eventToSet = ts.getEvent(event.getEntity(), event.getClass());
        if (eventToSet == null) {
            ts.addEvent((Event)event);
            eventToSet = event;
        }
        input.setEvent((Event)eventToSet, this.eventRef);
    }

    private class EventReferencePropertySectionSyncAdapter
    extends AdapterImpl {
        private EReference otherEventRef;
        private I registeredInput = null;

        public EventReferencePropertySectionSyncAdapter(EReference otherEventRef) {
            this.otherEventRef = otherEventRef;
        }

        public EReference getOtherEventRef() {
            return this.otherEventRef;
        }

        public void notifyChanged(Notification msg) {
            if (msg.getEventType() != 1) {
                return;
            }
            Object feature = msg.getFeature();
            if (feature == ElementPackage.Literals.IMODEL_ELEMENT_REFERENCE__REFERENCE) {
                EventReferencePropertySectionBase.this.refresh();
            } else if (feature == this.otherEventRef) {
                Object oldValue = msg.getOldValue();
                if (oldValue instanceof EObject) {
                    ((EObject)oldValue).eAdapters().remove((Object)this);
                }
                this.remove();
                this.add();
                EventReferencePropertySectionBase.this.refresh();
            }
        }

        public void remove() {
            if (this.registeredInput != null) {
                this.registeredInput.eAdapters().remove((Object)this);
                EObject eObj = (EObject)this.registeredInput.eGet((EStructuralFeature)this.otherEventRef);
                if (eObj != null) {
                    eObj.eAdapters().remove((Object)this);
                }
                this.registeredInput = null;
            }
        }

        public void add() {
            if (EventReferencePropertySectionBase.this.input != null) {
                this.registeredInput = EventReferencePropertySectionBase.this.input;
                EventReferencePropertySectionBase.this.input.eAdapters().add((Object)this);
                EObject eObj = (EObject)EventReferencePropertySectionBase.this.input.eGet((EStructuralFeature)this.otherEventRef);
                if (eObj != null) {
                    eObj.eAdapters().add((Object)this);
                }
            }
        }
    }
}

