/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.timing.ui.properties;

import java.math.BigDecimal;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fortiss.af3.timing.model.AF3TimingPackage;
import org.fortiss.af3.timing.model.ReactionConstraint;
import org.fortiss.af3.timing.ui.properties.EventChainConstraintPropertySectionBase;
import org.fortiss.tooling.kernel.ui.databinding.NumberPositiveZeroValidator;

public class ReactionConstraintPropertySection
extends EventChainConstraintPropertySectionBase<ReactionConstraint> {
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.createTimeValueTextFormEntry("Minimum", AF3TimingPackage.Literals.REACTION_CONSTRAINT__MINIMUM, (IValidator)new MinMaxValidator(this){

            @Override
            protected boolean isMaxGreaterEqualMin(BigDecimal min) {
                BigDecimal max = ((ReactionConstraint)input).getMaximum();
                return min == null || max == null || min.compareTo(max) != 1;
            }
        });
        this.createTimeValueTextFormEntry("Maximum", AF3TimingPackage.Literals.REACTION_CONSTRAINT__MAXIMUM, (IValidator)new MinMaxValidator(this){

            @Override
            protected boolean isMaxGreaterEqualMin(BigDecimal max) {
                BigDecimal min = ((ReactionConstraint)input).getMinimum();
                return min == null || max == null || max.compareTo(min) != -1;
            }
        });
    }

    private abstract class MinMaxValidator
    extends NumberPositiveZeroValidator {
        private MinMaxValidator() {
        }

        protected IStatus doValidate(Number number) {
            IStatus status = super.doValidate(number);
            if (!status.isOK()) {
                return status;
            }
            if (!(number instanceof BigDecimal)) {
                ValidationStatus.cancel((String)("Input is not a BigDecimal, but of type " + number.getClass().getSimpleName()));
            }
            if (!this.isMaxGreaterEqualMin((BigDecimal)number)) {
                return ValidationStatus.cancel((String)"Maximum must be larger the minimum");
            }
            return ValidationStatus.ok();
        }

        protected abstract boolean isMaxGreaterEqualMin(BigDecimal var1);
    }
}

