/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.timing.ui.properties;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.fortiss.af3.timing.ui.properties.QuadConsumer;
import org.fortiss.tooling.kernel.ui.util.ObservableUtils;

public class TimeValuePropertySectionTextManager {
    private Map<Text, BindingValue> textBindingMap = new HashMap<Text, BindingValue>();
    protected static final int TEMPORAL_VALUES_MAXIMUM_FRACTION_DIGITS = 12;

    public Text createTimeValueTextFormEntry(Function<String, Text> createDecoratedFormText, String label, EAttribute eAttribute, IValidator validator) {
        Text text = createDecoratedFormText.apply(label + " [s]");
        this.textBindingMap.put(text, new BindingValue(eAttribute, validator));
        return text;
    }

    public void refresh(EObject input, boolean isTextControlsEnabled, QuadConsumer<Control, IObservableValue<?>, IValidator, Integer> bindBigDecimalValue) {
        this.updateEnabledTextControls(isTextControlsEnabled);
        for (Map.Entry<Text, BindingValue> entry : this.textBindingMap.entrySet()) {
            BindingValue binding = entry.getValue();
            IObservableValue observeValue = ObservableUtils.observeValue((EObject)input, (EStructuralFeature)binding.eAttribute);
            bindBigDecimalValue.accept((Control)entry.getKey(), observeValue, binding.validator, 12);
        }
    }

    public void updateEnabledTextControls(boolean isTextControlsEnabled) {
        for (Text text : this.textBindingMap.keySet()) {
            text.setEnabled(isTextControlsEnabled);
        }
    }

    private class BindingValue {
        public EAttribute eAttribute;
        public IValidator validator;

        public BindingValue(EAttribute eAttribute, IValidator validator) {
            this.eAttribute = eAttribute;
            this.validator = validator;
        }
    }
}

