/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class TextStyledTextActionHandler {
    private DeleteActionHandler textDeleteAction = new DeleteActionHandler();
    private CutActionHandler textCutAction = new CutActionHandler();
    private CopyActionHandler textCopyAction = new CopyActionHandler();
    private PasteActionHandler textPasteAction = new PasteActionHandler();
    private SelectAllActionHandler textSelectAllAction = new SelectAllActionHandler();
    private IAction deleteAction;
    private IAction cutAction;
    private IAction copyAction;
    private IAction pasteAction;
    private IAction selectAllAction;
    private IPropertyChangeListener deleteActionListener = new PropertyChangeListener((IAction)this.textDeleteAction);
    private IPropertyChangeListener cutActionListener = new PropertyChangeListener((IAction)this.textCutAction);
    private IPropertyChangeListener copyActionListener = new PropertyChangeListener((IAction)this.textCopyAction);
    private IPropertyChangeListener pasteActionListener = new PropertyChangeListener((IAction)this.textPasteAction);
    private IPropertyChangeListener selectAllActionListener = new PropertyChangeListener((IAction)this.textSelectAllAction);
    private Listener textControlListener = new TextControlListener();
    private Control activeTextControl;
    private IActionBars actionBars;
    private MouseAdapter mouseAdapter = new MouseAdapter(){

        public void mouseUp(MouseEvent e) {
            TextStyledTextActionHandler.this.updateActionsEnableState();
        }
    };
    private KeyAdapter keyAdapter = new KeyAdapter(){

        public void keyReleased(KeyEvent e) {
            TextStyledTextActionHandler.this.updateActionsEnableState();
        }
    };

    public TextStyledTextActionHandler(IActionBars actionBar) {
        this.actionBars = actionBar;
        this.updateActionBars();
    }

    public void updateActionBars() {
        this.actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.textCutAction);
        this.actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.textCopyAction);
        this.actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.textPasteAction);
        this.actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.textSelectAllAction);
        this.actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.textDeleteAction);
    }

    public void addText(StyledText textControl) {
        if (textControl == null) {
            return;
        }
        textControl.addListener(26, this.textControlListener);
        textControl.addListener(27, this.textControlListener);
        textControl.addKeyListener((KeyListener)this.keyAdapter);
        textControl.addMouseListener((MouseListener)this.mouseAdapter);
        if (textControl.isFocusControl()) {
            this.activeTextControl = textControl;
            this.updateActionsEnableState();
        }
    }

    public void addText(Text textControl) {
        if (textControl == null) {
            return;
        }
        textControl.addListener(26, this.textControlListener);
        textControl.addListener(27, this.textControlListener);
        textControl.addKeyListener((KeyListener)this.keyAdapter);
        textControl.addMouseListener((MouseListener)this.mouseAdapter);
        if (textControl.isFocusControl()) {
            this.activeTextControl = textControl;
            this.updateActionsEnableState();
        }
    }

    public void dispose() {
        this.setCutAction(null);
        this.setCopyAction(null);
        this.setPasteAction(null);
        this.setSelectAllAction(null);
        this.setDeleteAction(null);
    }

    public void removeText(Text textControl) {
        if (textControl == null) {
            return;
        }
        textControl.removeListener(26, this.textControlListener);
        textControl.removeListener(27, this.textControlListener);
        textControl.removeMouseListener((MouseListener)this.mouseAdapter);
        textControl.removeKeyListener((KeyListener)this.keyAdapter);
        this.activeTextControl = null;
        this.updateActionsEnableState();
    }

    public void removeText(StyledText textControl) {
        if (textControl == null) {
            return;
        }
        textControl.removeListener(26, this.textControlListener);
        textControl.removeListener(27, this.textControlListener);
        textControl.removeMouseListener((MouseListener)this.mouseAdapter);
        textControl.removeKeyListener((KeyListener)this.keyAdapter);
        this.activeTextControl = null;
        this.updateActionsEnableState();
    }

    public void setCopyAction(IAction action) {
        if (this.copyAction == action) {
            return;
        }
        if (this.copyAction != null) {
            this.copyAction.removePropertyChangeListener(this.copyActionListener);
        }
        this.copyAction = action;
        if (this.copyAction != null) {
            this.copyAction.addPropertyChangeListener(this.copyActionListener);
        }
        this.textCopyAction.updateEnabledState();
    }

    public void setCutAction(IAction action) {
        if (this.cutAction == action) {
            return;
        }
        if (this.cutAction != null) {
            this.cutAction.removePropertyChangeListener(this.cutActionListener);
        }
        this.cutAction = action;
        if (this.cutAction != null) {
            this.cutAction.addPropertyChangeListener(this.cutActionListener);
        }
        this.textCutAction.updateEnabledState();
    }

    public void setPasteAction(IAction action) {
        if (this.pasteAction == action) {
            return;
        }
        if (this.pasteAction != null) {
            this.pasteAction.removePropertyChangeListener(this.pasteActionListener);
        }
        this.pasteAction = action;
        if (this.pasteAction != null) {
            this.pasteAction.addPropertyChangeListener(this.pasteActionListener);
        }
        this.textPasteAction.updateEnabledState();
    }

    public void setSelectAllAction(IAction action) {
        if (this.selectAllAction == action) {
            return;
        }
        if (this.selectAllAction != null) {
            this.selectAllAction.removePropertyChangeListener(this.selectAllActionListener);
        }
        this.selectAllAction = action;
        if (this.selectAllAction != null) {
            this.selectAllAction.addPropertyChangeListener(this.selectAllActionListener);
        }
        this.textSelectAllAction.updateEnabledState();
    }

    public void setDeleteAction(IAction action) {
        if (this.deleteAction == action) {
            return;
        }
        if (this.deleteAction != null) {
            this.deleteAction.removePropertyChangeListener(this.deleteActionListener);
        }
        this.deleteAction = action;
        if (this.deleteAction != null) {
            this.deleteAction.addPropertyChangeListener(this.deleteActionListener);
        }
        this.textDeleteAction.updateEnabledState();
    }

    private void updateActionsEnableState() {
        this.textCutAction.updateEnabledState();
        this.textCopyAction.updateEnabledState();
        this.textPasteAction.updateEnabledState();
        this.textSelectAllAction.updateEnabledState();
        this.textDeleteAction.updateEnabledState();
    }

    private class CopyActionHandler
    extends Action {
        protected CopyActionHandler() {
            super(IDEWorkbenchMessages.Copy);
            this.setId("TextCopyActionHandler");
            this.setEnabled(false);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.text_copy_action_context");
        }

        public void runWithEvent(Event event) {
            if (TextStyledTextActionHandler.this.activeTextControl != null && !TextStyledTextActionHandler.this.activeTextControl.isDisposed()) {
                if (TextStyledTextActionHandler.this.activeTextControl instanceof StyledText) {
                    ((StyledText)TextStyledTextActionHandler.this.activeTextControl).copy();
                }
                if (TextStyledTextActionHandler.this.activeTextControl instanceof Text) {
                    ((Text)TextStyledTextActionHandler.this.activeTextControl).copy();
                }
                TextStyledTextActionHandler.this.updateActionsEnableState();
                return;
            }
            if (TextStyledTextActionHandler.this.copyAction != null) {
                TextStyledTextActionHandler.this.copyAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (TextStyledTextActionHandler.this.activeTextControl != null && !TextStyledTextActionHandler.this.activeTextControl.isDisposed()) {
                if (TextStyledTextActionHandler.this.activeTextControl instanceof StyledText) {
                    this.setEnabled(((StyledText)TextStyledTextActionHandler.this.activeTextControl).getSelectionCount() > 0);
                }
                if (TextStyledTextActionHandler.this.activeTextControl instanceof Text) {
                    this.setEnabled(((Text)TextStyledTextActionHandler.this.activeTextControl).getSelectionCount() > 0);
                }
                return;
            }
            if (TextStyledTextActionHandler.this.copyAction != null) {
                this.setEnabled(TextStyledTextActionHandler.this.copyAction.isEnabled());
                return;
            }
            this.setEnabled(false);
        }
    }

    private class CutActionHandler
    extends Action {
        protected CutActionHandler() {
            super(IDEWorkbenchMessages.Cut);
            this.setId("TextCutActionHandler");
            this.setEnabled(false);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.text_cut_action_context");
        }

        public void runWithEvent(Event event) {
            if (TextStyledTextActionHandler.this.activeTextControl != null && !TextStyledTextActionHandler.this.activeTextControl.isDisposed()) {
                if (TextStyledTextActionHandler.this.activeTextControl instanceof StyledText) {
                    ((StyledText)TextStyledTextActionHandler.this.activeTextControl).cut();
                }
                if (TextStyledTextActionHandler.this.activeTextControl instanceof Text) {
                    ((Text)TextStyledTextActionHandler.this.activeTextControl).cut();
                }
                TextStyledTextActionHandler.this.updateActionsEnableState();
                return;
            }
            if (TextStyledTextActionHandler.this.cutAction != null) {
                TextStyledTextActionHandler.this.cutAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (TextStyledTextActionHandler.this.activeTextControl != null && !TextStyledTextActionHandler.this.activeTextControl.isDisposed()) {
                if (TextStyledTextActionHandler.this.activeTextControl instanceof StyledText) {
                    this.setEnabled(((StyledText)TextStyledTextActionHandler.this.activeTextControl).getEditable() && ((StyledText)TextStyledTextActionHandler.this.activeTextControl).getSelectionCount() > 0);
                }
                if (TextStyledTextActionHandler.this.activeTextControl instanceof Text) {
                    this.setEnabled(((Text)TextStyledTextActionHandler.this.activeTextControl).getEditable() && ((Text)TextStyledTextActionHandler.this.activeTextControl).getSelectionCount() > 0);
                }
                return;
            }
            if (TextStyledTextActionHandler.this.cutAction != null) {
                this.setEnabled(TextStyledTextActionHandler.this.cutAction.isEnabled());
                return;
            }
            this.setEnabled(false);
        }
    }

    private class DeleteActionHandler
    extends Action {
        protected DeleteActionHandler() {
            super(IDEWorkbenchMessages.Delete);
            this.setId("TextDeleteActionHandler");
            this.setEnabled(false);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.text_delete_action_context");
        }

        public void runWithEvent(Event event) {
            if (TextStyledTextActionHandler.this.activeTextControl != null && !TextStyledTextActionHandler.this.activeTextControl.isDisposed()) {
                Point selection;
                if (TextStyledTextActionHandler.this.activeTextControl instanceof Text) {
                    selection = ((Text)TextStyledTextActionHandler.this.activeTextControl).getSelection();
                    if (selection.y == selection.x && selection.x < ((Text)TextStyledTextActionHandler.this.activeTextControl).getCharCount()) {
                        ((Text)TextStyledTextActionHandler.this.activeTextControl).setSelection(selection.x, selection.x + 1);
                    }
                    ((Text)TextStyledTextActionHandler.this.activeTextControl).insert("");
                }
                if (TextStyledTextActionHandler.this.activeTextControl instanceof StyledText) {
                    selection = ((StyledText)TextStyledTextActionHandler.this.activeTextControl).getSelection();
                    if (selection.y == selection.x && selection.x < ((StyledText)TextStyledTextActionHandler.this.activeTextControl).getCharCount()) {
                        ((StyledText)TextStyledTextActionHandler.this.activeTextControl).setSelection(selection.x, selection.x + 1);
                    }
                    ((StyledText)TextStyledTextActionHandler.this.activeTextControl).insert("");
                }
                TextStyledTextActionHandler.this.updateActionsEnableState();
                return;
            }
            if (TextStyledTextActionHandler.this.deleteAction != null) {
                TextStyledTextActionHandler.this.deleteAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (TextStyledTextActionHandler.this.activeTextControl != null && !TextStyledTextActionHandler.this.activeTextControl.isDisposed()) {
                if (TextStyledTextActionHandler.this.activeTextControl instanceof Text) {
                    this.setEnabled(((Text)TextStyledTextActionHandler.this.activeTextControl).getEditable() && (((Text)TextStyledTextActionHandler.this.activeTextControl).getSelectionCount() > 0 || ((Text)TextStyledTextActionHandler.this.activeTextControl).getCaretPosition() < ((Text)TextStyledTextActionHandler.this.activeTextControl).getCharCount()));
                }
                if (TextStyledTextActionHandler.this.activeTextControl instanceof StyledText) {
                    this.setEnabled(((StyledText)TextStyledTextActionHandler.this.activeTextControl).getEditable() && (((StyledText)TextStyledTextActionHandler.this.activeTextControl).getSelectionCount() > 0 || ((StyledText)TextStyledTextActionHandler.this.activeTextControl).getCaretOffset() < ((StyledText)TextStyledTextActionHandler.this.activeTextControl).getCharCount()));
                }
                return;
            }
            if (TextStyledTextActionHandler.this.deleteAction != null) {
                this.setEnabled(TextStyledTextActionHandler.this.deleteAction.isEnabled());
                return;
            }
            this.setEnabled(false);
        }
    }

    private class PasteActionHandler
    extends Action {
        protected PasteActionHandler() {
            super(IDEWorkbenchMessages.Paste);
            this.setId("TextPasteActionHandler");
            this.setEnabled(false);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.text_paste_action_context");
        }

        public void runWithEvent(Event event) {
            if (TextStyledTextActionHandler.this.activeTextControl != null && !TextStyledTextActionHandler.this.activeTextControl.isDisposed()) {
                if (TextStyledTextActionHandler.this.activeTextControl instanceof StyledText) {
                    ((StyledText)TextStyledTextActionHandler.this.activeTextControl).paste();
                }
                if (TextStyledTextActionHandler.this.activeTextControl instanceof Text) {
                    ((Text)TextStyledTextActionHandler.this.activeTextControl).paste();
                }
                TextStyledTextActionHandler.this.updateActionsEnableState();
                return;
            }
            if (TextStyledTextActionHandler.this.pasteAction != null) {
                TextStyledTextActionHandler.this.pasteAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (TextStyledTextActionHandler.this.activeTextControl != null && !TextStyledTextActionHandler.this.activeTextControl.isDisposed()) {
                boolean canPaste = false;
                if (TextStyledTextActionHandler.this.activeTextControl instanceof StyledText && ((StyledText)TextStyledTextActionHandler.this.activeTextControl).getEditable() || TextStyledTextActionHandler.this.activeTextControl instanceof Text && ((Text)TextStyledTextActionHandler.this.activeTextControl).getEditable()) {
                    Clipboard clipboard = new Clipboard(TextStyledTextActionHandler.this.activeTextControl.getDisplay());
                    TransferData[] td = clipboard.getAvailableTypes();
                    int i = 0;
                    while (i < td.length) {
                        if (TextTransfer.getInstance().isSupportedType(td[i])) {
                            canPaste = true;
                            break;
                        }
                        ++i;
                    }
                    clipboard.dispose();
                }
                this.setEnabled(canPaste);
                return;
            }
            if (TextStyledTextActionHandler.this.pasteAction != null) {
                this.setEnabled(TextStyledTextActionHandler.this.pasteAction.isEnabled());
                return;
            }
            this.setEnabled(false);
        }
    }

    private class PropertyChangeListener
    implements IPropertyChangeListener {
        private IAction actionHandler;

        protected PropertyChangeListener(IAction actionHandler) {
            this.actionHandler = actionHandler;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (TextStyledTextActionHandler.this.activeTextControl != null) {
                return;
            }
            if (event.getProperty().equals("enabled")) {
                Boolean bool = (Boolean)event.getNewValue();
                this.actionHandler.setEnabled(bool.booleanValue());
            }
        }
    }

    private class SelectAllActionHandler
    extends Action {
        protected SelectAllActionHandler() {
            super(IDEWorkbenchMessages.TextAction_selectAll);
            this.setId("TextSelectAllActionHandler");
            this.setEnabled(false);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.text_select_all_action_context");
        }

        public void runWithEvent(Event event) {
            if (TextStyledTextActionHandler.this.activeTextControl != null && !TextStyledTextActionHandler.this.activeTextControl.isDisposed()) {
                if (TextStyledTextActionHandler.this.activeTextControl instanceof StyledText) {
                    ((StyledText)TextStyledTextActionHandler.this.activeTextControl).selectAll();
                }
                if (TextStyledTextActionHandler.this.activeTextControl instanceof Text) {
                    ((Text)TextStyledTextActionHandler.this.activeTextControl).selectAll();
                }
                TextStyledTextActionHandler.this.updateActionsEnableState();
                return;
            }
            if (TextStyledTextActionHandler.this.selectAllAction != null) {
                TextStyledTextActionHandler.this.selectAllAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (TextStyledTextActionHandler.this.activeTextControl != null && !TextStyledTextActionHandler.this.activeTextControl.isDisposed()) {
                if (TextStyledTextActionHandler.this.activeTextControl instanceof StyledText) {
                    this.setEnabled(((StyledText)TextStyledTextActionHandler.this.activeTextControl).getCharCount() > 0);
                }
                if (TextStyledTextActionHandler.this.activeTextControl instanceof Text) {
                    this.setEnabled(((Text)TextStyledTextActionHandler.this.activeTextControl).getCharCount() > 0);
                }
                return;
            }
            if (TextStyledTextActionHandler.this.selectAllAction != null) {
                this.setEnabled(TextStyledTextActionHandler.this.selectAllAction.isEnabled());
                return;
            }
            this.setEnabled(false);
        }
    }

    private class TextControlListener
    implements Listener {
        private TextControlListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 26: {
                    if (event.widget instanceof StyledText) {
                        TextStyledTextActionHandler.this.activeTextControl = (StyledText)event.widget;
                    }
                    if (event.widget instanceof Text) {
                        TextStyledTextActionHandler.this.activeTextControl = (Text)event.widget;
                    }
                    TextStyledTextActionHandler.this.updateActionsEnableState();
                    break;
                }
                case 27: {
                    TextStyledTextActionHandler.this.activeTextControl = null;
                    TextStyledTextActionHandler.this.updateActionsEnableState();
                    break;
                }
            }
        }
    }
}

