/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx;

import java.net.URL;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import org.eclipse.fx.ui.workbench3.FXViewPart;
import org.fortiss.tooling.common.ui.javafx.layout.ICompositeFXController;

public abstract class AF3FXViewPart
extends FXViewPart {
    private String cssLocation;
    private Pane root;
    protected final ICompositeFXController<? extends Node, ? extends Node> controller;

    public AF3FXViewPart(ICompositeFXController<? extends Node, ? extends Node> controller, String cssLocation) throws Exception {
        Platform.setImplicitExit((boolean)false);
        this.cssLocation = cssLocation;
        this.controller = controller;
    }

    protected Scene createFxScene() {
        this.controller.loadLayout();
        Node layout = this.controller.getLayout();
        AnchorPane.setTopAnchor((Node)layout, (Double)0.0);
        AnchorPane.setRightAnchor((Node)layout, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)layout, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)layout, (Double)0.0);
        this.root = new AnchorPane(new Node[]{layout});
        if (this.cssLocation != null && !this.applyStyleSheet(this.root, ((Object)((Object)this)).getClass(), this.cssLocation)) {
            System.err.println("Application of custom CSS \"" + this.cssLocation + "\" failed.");
        }
        Scene scene = new Scene((Parent)this.root);
        return scene;
    }

    protected void setFxFocus() {
    }

    private boolean applyStyleSheet(Pane pane, Class<?> viewerClass, String styleSheetLocation) {
        if (viewerClass == null || styleSheetLocation == null) {
            return false;
        }
        URL cssURL = viewerClass.getResource(styleSheetLocation);
        if (cssURL != null) {
            pane.getStylesheets().add((Object)cssURL.toExternalForm());
            return true;
        }
        return false;
    }
}

