/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.control.treetableview;

import java.util.Collection;
import java.util.HashMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javafx.scene.control.TreeItem;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicStreamContentProvider;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeItem;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeItemBase;

public class DynamicList<T>
extends DynamicTreeItemBase<T> {
    private DynamicTreeContentProviderBase<T> contentProvider;

    public DynamicList(Supplier<Stream<T>> data, DynamicStreamContentProvider<T, Supplier<Stream<T>>> contentProvider) {
        super(data);
        this.contentProvider = contentProvider;
    }

    public DynamicList(Collection<T> data, DynamicTreeContentProviderBase<T> contentProvider) {
        super(data);
        this.contentProvider = contentProvider;
    }

    @Override
    public void update() {
        HashMap<Object, TreeItem> expanded = new HashMap<Object, TreeItem>();
        for (TreeItem c : this.getChildren()) {
            if (!c.isExpanded()) continue;
            expanded.put(c.getValue(), c);
        }
        this.getChildren().clear();
        for (Object element : this.contentProvider.getFilteredSortedChildren(this.getValue())) {
            DynamicTreeItem<Object> dti = new DynamicTreeItem<Object>(element, this.contentProvider);
            this.getChildren().add(dti);
            dti.update();
        }
    }

    public boolean isLeaf() {
        Collection<Object> children = this.contentProvider.getFilteredSortedChildren(this.getValue());
        return children == null || children.isEmpty();
    }
}

