/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.control.treetableview;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.cell.TextFieldTreeTableCell;
import javafx.scene.input.KeyCode;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableUIProviderBase;

public class DynamicTextFieldTreeTableCell<T>
extends TextFieldTreeTableCell<T, String> {
    private boolean escapePressed = false;
    DynamicTreeTableUIProviderBase<T> uiProvider;
    int columnIndex;

    public DynamicTextFieldTreeTableCell(DynamicTreeTableUIProviderBase<T> uiProvider, int columnIndex) {
        this((StringConverter<String>)new DefaultStringConverter());
        this.uiProvider = uiProvider;
        this.columnIndex = columnIndex;
        this.setConverter((StringConverter)new DefaultStringConverter());
    }

    public DynamicTextFieldTreeTableCell(StringConverter<String> converter) {
        super(converter);
        this.setOnKeyPressed(event -> {
            this.escapePressed = event.getCode().equals((Object)KeyCode.ESCAPE);
        });
    }

    public void startEdit() {
        TreeTableRow row = this.getTreeTableRow();
        Object currentEntry = row.getItem();
        boolean isElementEditable = this.uiProvider.isElementEditable(this.columnIndex, currentEntry);
        if (!(currentEntry != null && this.getTreeTableView().isEditable() && this.getTableColumn().isEditable() && this.isEditable() && isElementEditable)) {
            return;
        }
        super.startEdit();
        Node graphic = this.getGraphic();
        if (graphic instanceof TextField) {
            final TextField textField = (TextField)graphic;
            textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> val, Boolean oldVal, Boolean newVal) {
                    if (DynamicTextFieldTreeTableCell.this.escapePressed) {
                        return;
                    }
                    String newValue = textField.getText();
                    DynamicTextFieldTreeTableCell.this.commitEdit(newValue);
                }
            });
        }
    }

    public void cancelEdit() {
        Object currentlyEditedElement;
        String oldValue;
        TextField textField;
        String newValue;
        Node graphic = this.getGraphic();
        if (graphic instanceof TextField && !(newValue = (textField = (TextField)graphic).getText()).equals(oldValue = this.uiProvider.getLabel(this.getTreeTableRow().getItem(), this.columnIndex)) && !this.escapePressed && (currentlyEditedElement = this.getTreeTableRow().getItem()) != null) {
            this.uiProvider.updateValue(this.getTreeTableRow().getItem(), this.columnIndex, newValue);
        }
        this.getTreeTableView().refresh();
        super.cancelEdit();
    }

    public void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        this.uiProvider.styleCell((TreeTableCell<T, ?>)this, this.columnIndex);
    }
}

