/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.control.treetableview;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class DynamicTreeContentProviderBase<T> {
    private String filterExpression = null;

    protected abstract Collection<? extends T> getChildren(T var1);

    protected Comparator<T> getSortingComparator() {
        return (o1, o2) -> 0;
    }

    public void setFilterExpression(String filterExpression) {
        this.filterExpression = filterExpression;
    }

    protected String getFilterExpression() {
        return this.filterExpression;
    }

    protected boolean filter(T element, String filterValue) {
        if (element == null) {
            return false;
        }
        if (filterValue == null || "".equals(filterValue.trim())) {
            return true;
        }
        return element.toString().toLowerCase().contains(filterValue.toLowerCase());
    }

    private Predicate<T> getFilterPredicate() {
        return o -> this.filter(o, this.getFilterExpression());
    }

    public final Collection<? extends T> getFilteredSortedChildren(T parent) {
        Collection<T> l = null;
        l = parent instanceof Collection ? (Collection<T>)parent : this.getChildren(parent);
        if (l == null) {
            return Collections.emptyList();
        }
        return l.stream().filter(this.getFilterPredicate()).sorted(this.getSortingComparator()).collect(Collectors.toList());
    }
}

