/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.control.treetableview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeItemBase;

public class DynamicTreeItem<T>
extends DynamicTreeItemBase<T> {
    private DynamicTreeContentProviderBase<T> contentProvider;

    public DynamicTreeItem(T data, DynamicTreeContentProviderBase<T> viewer) {
        super(data);
        this.contentProvider = viewer;
    }

    @Override
    public void update() {
        ObservableList children = this.getChildren();
        HashMap<Object, Boolean> expanded = new HashMap<Object, Boolean>();
        for (TreeItem child : children) {
            expanded.put(child.getValue(), child.isExpanded());
        }
        Collection<Object> updatedContent = this.contentProvider.getFilteredSortedChildren(this.getValue());
        ArrayList<Object> newlyAddedValues = new ArrayList<Object>(updatedContent);
        for (TreeItem child : children) {
            newlyAddedValues.remove(child.getValue());
        }
        children.removeIf(ti -> !updatedContent.contains(ti.getValue()));
        int i = 0;
        for (Object updatedValue : updatedContent) {
            DynamicTreeItem<Object> child = null;
            if (i < children.size()) {
                if (updatedValue.equals(((TreeItem)children.get(i)).getValue())) {
                    child = (DynamicTreeItem<Object>)children.get(i);
                } else {
                    child = new DynamicTreeItem<Object>(updatedValue, this.contentProvider);
                    child.setExpanded(expanded.getOrDefault(updatedValue, false));
                    if (newlyAddedValues.contains(updatedValue)) {
                        children.add(i, child);
                    } else {
                        children.set(i, child);
                    }
                }
            } else {
                child = new DynamicTreeItem<Object>(updatedValue, this.contentProvider);
                child.setExpanded(expanded.getOrDefault(updatedValue, false));
                children.add(child);
            }
            child.update();
            ++i;
        }
    }

    public boolean isLeaf() {
        Collection<Object> children = this.contentProvider.getFilteredSortedChildren(this.getValue());
        return children == null || children.isEmpty();
    }
}

