/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.control.treetableview;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.cell.CheckBoxTreeTableCell;
import javafx.scene.control.cell.ComboBoxTreeTableCell;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Callback;
import javafx.util.Duration;
import org.apache.commons.lang3.SystemUtils;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTextFieldTreeTableCell;

public abstract class DynamicTreeTableUIProviderBase<T> {
    public String getLabel(T element, int column) {
        return "";
    }

    public String getTooltip(T element, int column) {
        return null;
    }

    public String getInitialEditorContent(T element, int column) {
        return this.getLabel(element, column);
    }

    public Node getIconNode(T element, int column) {
        return null;
    }

    public String getCellStyle(T element, int column) {
        if (element == null) {
            return null;
        }
        Color bgColor = this.getBackgroundColor(column, element);
        if (bgColor != null) {
            double alpha = 0.5;
            String colorStr = DynamicTreeTableUIProviderBase.colorToRgbaString(bgColor, alpha);
            return "-fx-background-color: " + colorStr + ";";
        }
        return null;
    }

    public Color getBackgroundColor(int column, T element) {
        return null;
    }

    public ContextMenu createContextMenu(T element, int column) {
        return null;
    }

    public boolean dragOver(T item, Dragboard dragboard) {
        return false;
    }

    public boolean dropClipboardContent(T element, Dragboard dragboard) {
        return false;
    }

    public boolean isEditable(int column) {
        return false;
    }

    public boolean isElementEditable(int column, T element) {
        return this.isEditable(column);
    }

    public void updateValue(T element, int column, Object value) {
    }

    public void select(T oldValue, T newValue) {
    }

    final void applyToColumn(int i, TreeTableColumn<T, String> column) {
        if (!this.isEditable(i)) {
            column.setCellFactory(this.createReadOnlyCellFactory(i));
            column.setEditable(false);
            column.setOnEditCommit(null);
            return;
        }
        column.setCellFactory(this.createEditableCellFactory(i));
        column.setEditable(true);
        column.setOnEditStart(event -> event.getEventType());
        column.setOnEditCommit(event -> {
            Object element = event.getRowValue().getValue();
            TreeTableColumn tableColumn = event.getTableColumn();
            int colIndex = tableColumn.getTreeTableView().getColumns().indexOf((Object)tableColumn);
            String value = (String)event.getNewValue();
            this.updateValue(element, colIndex, value);
            column.getTreeTableView().refresh();
        });
    }

    final void applyToCheckboxColumn(final int i, final TreeTableColumn<T, Boolean> column) {
        column.setOnEditCommit(null);
        column.setEditable(this.isEditable(i));
        if (!this.isEditable(i)) {
            return;
        }
        column.setCellValueFactory(new Callback<TreeTableColumn.CellDataFeatures<T, Boolean>, ObservableValue<Boolean>>(){

            public ObservableValue<Boolean> call(TreeTableColumn.CellDataFeatures<T, Boolean> param) {
                TreeItem treeItem = param.getValue();
                final Object value = treeItem.getValue();
                String label = DynamicTreeTableUIProviderBase.this.getLabel(value, i).trim().toLowerCase();
                if (!label.equals("true") && !label.equals("false")) {
                    throw new RuntimeException("Wrong type in checkbox table cell. Expected boolean \"true\" or \"false\" but received \"" + label + "\".");
                }
                boolean b = Boolean.valueOf(label);
                SimpleBooleanProperty booleanProp = new SimpleBooleanProperty(b);
                booleanProp.addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                        DynamicTreeTableUIProviderBase.this.updateValue(value, i, newValue);
                        column.getTreeTableView().refresh();
                    }
                });
                return booleanProp;
            }
        });
        column.setCellFactory(this.createEditableCheckboxCellFactory(i));
    }

    final void applyToComboColumn(int columnIndex, TreeTableColumn<T, String> column, Function<T, Map<?, String>> comboValueFactory) {
        column.setCellFactory(this.createEditableComboCellFactory(columnIndex, column, comboValueFactory));
    }

    final void styleCell(TreeTableCell<T, ?> cell, int columnIndex) {
        if (cell.getTreeTableRow() != null) {
            Object data = cell.getTreeTableRow().getItem();
            if (data != null) {
                String tooltipStr;
                Node icon = this.getIconNode(data, columnIndex);
                cell.setGraphic(icon);
                cell.setStyle(this.getCellStyle(data, columnIndex));
                this.addContextMenuToCell(cell, columnIndex);
                if (icon == null) {
                    Text text = new Text(cell.getText());
                    text.setStyle("-fx-text-alignment:justify;");
                    int lineWrapBorder = 5;
                    text.wrappingWidthProperty().bind((ObservableValue)cell.getTableColumn().widthProperty().subtract(lineWrapBorder));
                    cell.setGraphic((Node)text);
                }
                if ((tooltipStr = this.getTooltip(data, columnIndex)) != null) {
                    Tooltip tt = new Tooltip();
                    double fontSize = 14.0;
                    Font font = Font.font((double)fontSize);
                    tt.setText(tooltipStr);
                    tt.setShowDuration(Duration.seconds((double)15.0));
                    tt.setFont(font);
                    cell.setTooltip(tt);
                }
            } else {
                cell.setGraphic(null);
                cell.setStyle(null);
            }
        }
    }

    private static final String colorToRgbaString(Color color, double alpha) {
        return String.format("rgba(%d,%d,%d,%s)", (int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0), alpha);
    }

    private Callback<TreeTableColumn<T, String>, TreeTableCell<T, String>> createEditableCellFactory(int colIndex) {
        return param -> {
            DynamicTextFieldTreeTableCell cell = new DynamicTextFieldTreeTableCell(this, colIndex);
            this.styleCell((TreeTableCell<T, ?>)cell, colIndex);
            return cell;
        };
    }

    private Callback<TreeTableColumn<T, Boolean>, TreeTableCell<T, Boolean>> createEditableCheckboxCellFactory(final int colIndex) {
        return param -> {
            CheckBoxTreeTableCell checkBoxTreeTableCell = new CheckBoxTreeTableCell<T, Boolean>(){

                public void updateItem(Boolean item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    DynamicTreeTableUIProviderBase.this.styleCell(this, colIndex);
                }
            };
            return checkBoxTreeTableCell;
        };
    }

    private Callback<TreeTableColumn<T, String>, TreeTableCell<T, String>> createEditableComboCellFactory(final int columnIndex, TreeTableColumn<T, String> column, Function<T, Map<?, String>> comboValueFactory) {
        ObservableList items = FXCollections.observableArrayList();
        Callback comboCellFactory = param -> new ComboBoxTreeTableCell<T, String>(null, items){

            public void updateItem(String item, boolean empty) {
                super.updateItem((Object)item, empty);
                DynamicTreeTableUIProviderBase.this.styleCell(this, columnIndex);
            }

            public void startEdit() {
                if (this.getItem() == null) {
                    return;
                }
                super.startEdit();
            }
        };
        column.setOnEditStart(event -> {
            Object rowEntry = event.getRowValue().getValue();
            Map comboValueMap = (Map)comboValueFactory.apply(rowEntry);
            items.clear();
            items.addAll(comboValueMap.values());
        });
        column.setOnEditCommit(event -> {
            TreeTableColumn tableColumn = event.getTableColumn();
            int colIndex = tableColumn.getTreeTableView().getColumns().indexOf((Object)tableColumn);
            String valueLabel = (String)event.getNewValue();
            Object rowEntry = event.getRowValue().getValue();
            Map comboValueMap = (Map)comboValueFactory.apply(rowEntry);
            Map<String, Object> valueMapInversed = comboValueMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            this.updateValue(rowEntry, colIndex, valueMapInversed.get(valueLabel));
            column.getTreeTableView().refresh();
        });
        return comboCellFactory;
    }

    public void validateOnCancelEdit(int colIndex, T item) {
    }

    public void validateOnKeyReleased(KeyEvent event, int colIndex, T item, String text) {
    }

    private Callback<TreeTableColumn<T, String>, TreeTableCell<T, String>> createReadOnlyCellFactory(final int colIndex) {
        return param -> {
            TreeTableCell cell = new TreeTableCell<T, String>(){

                protected void updateItem(String item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (!empty && item != null) {
                        DynamicTreeTableUIProviderBase.this.addContextMenuToCell(this, colIndex);
                    }
                    DynamicTreeTableUIProviderBase.this.styleCell(this, colIndex);
                }
            };
            cell.textProperty().bind((ObservableValue)cell.itemProperty());
            return cell;
        };
    }

    private void addContextMenuToCell(TreeTableCell<T, ?> cell, int columnIndex) {
        Object data = cell.getTreeTableRow().getItem();
        ContextMenu menu = this.createContextMenu(data, columnIndex);
        if (SystemUtils.IS_OS_LINUX && menu != null) {
            this.addContextMenuHandler(cell, menu, data);
        }
        cell.setContextMenu(menu);
    }

    private void addContextMenuHandler(TreeTableCell<T, ?> cell, ContextMenu menu, T element) {
        cell.getTreeTableView().addEventHandler(MouseEvent.MOUSE_RELEASED, e -> {
            if (e.getButton() == MouseButton.SECONDARY) {
                TreeItem selected = (TreeItem)cell.getTreeTableView().getSelectionModel().getSelectedItem();
                if (selected != null && selected.getValue() == element) {
                    menu.show((Node)cell, e.getScreenX(), e.getScreenY());
                    e.consume();
                }
            } else {
                menu.hide();
            }
        });
    }
}

