/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.control.treetableview;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.cell.CheckBoxTreeTableCell;
import javafx.scene.input.TransferMode;
import javafx.util.Callback;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicList;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicListContentProvider;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicStreamContentProvider;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeItem;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeItemBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableUIProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeViewerBase;

public final class DynamicTreeTableViewer<T>
extends DynamicTreeViewerBase<T> {
    private final TreeTableView<T> view;
    private final DynamicTreeTableUIProviderBase<T> uiProvider;

    public DynamicTreeTableViewer(TreeTableView<T> view, Supplier<Stream<T>> listFctn, DynamicStreamContentProvider<T, Supplier<Stream<T>>> contentProvider, DynamicTreeTableUIProviderBase<T> uiProvider) {
        this(view, new DynamicList<T>(listFctn, contentProvider), false, 0, (DynamicTreeContentProviderBase<T>)contentProvider, uiProvider);
    }

    public DynamicTreeTableViewer(TreeTableView<T> view, Collection<T> list, DynamicListContentProvider<T> contentProvider, DynamicTreeTableUIProviderBase<T> uiProvider) {
        this(view, new DynamicList<T>(list, contentProvider), false, 0, (DynamicTreeContentProviderBase<T>)contentProvider, uiProvider);
    }

    public DynamicTreeTableViewer(TreeTableView<T> view, T root, boolean showRoot, int revealLevel, DynamicTreeContentProviderBase<T> contentProvider, DynamicTreeTableUIProviderBase<T> uiProvider) {
        this(view, new DynamicTreeItem<T>(root, contentProvider), showRoot, revealLevel, contentProvider, uiProvider);
    }

    public DynamicTreeTableViewer(T root, boolean showRoot, int revealLevel, DynamicTreeContentProviderBase<T> contentProvider, DynamicTreeTableUIProviderBase<T> uiProvider) {
        this(new TreeTableView(), root, showRoot, revealLevel, contentProvider, uiProvider);
    }

    public DynamicTreeTableViewer(TreeTableView<T> view, DynamicTreeItemBase<T> rootItem, boolean showRoot, int revealLevel, DynamicTreeContentProviderBase<T> contentProvider, final DynamicTreeTableUIProviderBase<T> uiProvider) {
        super((Control)view, contentProvider);
        this.uiProvider = uiProvider;
        this.view = view;
        view.setRoot(rootItem);
        view.setShowRoot(showRoot);
        view.setEditable(true);
        view.setPlaceholder((Node)new Label(""));
        view.setRowFactory(new Callback<TreeTableView<T>, TreeTableRow<T>>(){

            public TreeTableRow<T> call(TreeTableView<T> param) {
                TreeTableRow row = new TreeTableRow();
                row.setOnDragOver(evt -> {
                    Object item = row.getItem();
                    if (uiProvider.dragOver(item, evt.getDragboard())) {
                        evt.acceptTransferModes(TransferMode.ANY);
                        evt.consume();
                    }
                });
                row.setOnDragDropped(evt -> {
                    Object item = row.getItem();
                    if (uiProvider.dropClipboardContent(item, evt.getDragboard())) {
                        evt.setDropCompleted(true);
                        evt.consume();
                    }
                });
                return row;
            }
        });
        TreeTableView.TreeTableViewSelectionModel selectionModel = view.getSelectionModel();
        selectionModel.setSelectionMode(SelectionMode.MULTIPLE);
        selectionModel.selectedItemProperty().addListener((obs, oVal, nVal) -> {
            Object ov = oVal != null ? oVal.getValue() : null;
            Object nv = nVal != null ? nVal.getValue() : null;
            uiProvider.select(ov, nv);
        });
        rootItem.update();
        this.expandItem(rootItem, showRoot ? revealLevel : revealLevel + 1);
    }

    public void update() {
        DynamicTreeItemBase rootItem = (DynamicTreeItemBase)this.view.getRoot();
        List<T> selectedValues = this.getSelectedValues();
        this.view.getSelectionModel().clearSelection();
        rootItem.update();
        this.selectValues(rootItem, selectedValues);
        this.view.refresh();
    }

    private List<T> getSelectedValues() {
        ObservableList selectedItems = this.view.getSelectionModel().getSelectedItems();
        return selectedItems.stream().map(c -> c.getValue()).collect(Collectors.toList());
    }

    private Stream<TreeItem<T>> getAllItems() {
        return this.getItems(this.view.getRoot(), i -> false);
    }

    private Stream<TreeItem<T>> getVisibleItems() {
        return this.getItems(this.view.getRoot(), i -> !i.isExpanded());
    }

    private Stream<TreeItem<T>> getItems(TreeItem<T> root, Predicate<TreeItem<T>> prune) {
        Stream<TreeItem<T>> items = Stream.of(root);
        if (!prune.test(root)) {
            for (TreeItem child : root.getChildren()) {
                items = Stream.concat(items, this.getItems(child, prune));
            }
        }
        return items;
    }

    public void navigateTo(T value) {
        if (value == null) {
            return;
        }
        TreeItem item = this.getAllItems().filter(i -> value.equals(i.getValue())).findFirst().orElse(null);
        if (item == null) {
            return;
        }
        TreeItem parent = item.getParent();
        while (parent != null) {
            parent.setExpanded(true);
            parent = parent.getParent();
        }
        int count = (int)this.getVisibleItems().takeWhile(i -> i != item).count();
        this.view.scrollTo(count);
    }

    public void clearSelection() {
        this.view.getSelectionModel().clearSelection();
    }

    public void selectValues(List<T> values) {
        this.selectValues(this.view.getRoot(), values);
    }

    private void selectValues(TreeItem<T> item, List<T> values) {
        if (values.contains(item.getValue())) {
            this.view.getSelectionModel().select(item);
        }
        if (item.isExpanded()) {
            for (TreeItem child : item.getChildren()) {
                this.selectValues(child, values);
            }
        }
    }

    private void expandItem(TreeItem<T> parentItem, int revealLevel) {
        if (revealLevel <= 0) {
            return;
        }
        parentItem.setExpanded(true);
        --revealLevel;
        for (TreeItem child : parentItem.getChildren()) {
            this.expandItem(child, revealLevel);
        }
    }

    public void expandToLevel(int revealLevel) {
        TreeItem root = this.view.getRoot();
        if (root == null) {
            return;
        }
        this.expandItem(root, revealLevel);
    }

    public void expandAllItems() {
        this.expandToLevel(Integer.MAX_VALUE);
    }

    public TreeTableColumn<T, String> addColumn(String headerLabel, int prefWidth) {
        int num = this.view.getColumns().size();
        TreeTableColumn column = new TreeTableColumn(headerLabel);
        column.setPrefWidth((double)prefWidth);
        column.setCellValueFactory(param -> {
            Object data = param.getValue().getValue();
            SimpleObjectProperty cell = new SimpleObjectProperty((Object)this.uiProvider.getLabel(data, num));
            return cell;
        });
        this.uiProvider.applyToColumn(num, column);
        this.view.getColumns().add((Object)column);
        return column;
    }

    public TreeTableColumn<T, Boolean> addCheckboxColumn(String headerLabel, int prefWidth) {
        int num = this.view.getColumns().size();
        TreeTableColumn column = new TreeTableColumn(headerLabel);
        column.setPrefWidth((double)prefWidth);
        column.setCellFactory(CheckBoxTreeTableCell.forTreeTableColumn((TreeTableColumn)column));
        this.uiProvider.applyToCheckboxColumn(num, column);
        this.view.getColumns().add((Object)column);
        return column;
    }

    public TreeTableColumn<T, String> addComboColumn(String headerLabel, int prefWidth, Function<T, Map<?, String>> comboValueFactory) {
        int num = this.view.getColumns().size();
        TreeTableColumn column = new TreeTableColumn(headerLabel);
        column.setPrefWidth((double)prefWidth);
        column.setCellValueFactory(param -> {
            Object data = param.getValue().getValue();
            SimpleObjectProperty cell = new SimpleObjectProperty((Object)this.uiProvider.getLabel(data, num));
            return cell;
        });
        this.uiProvider.applyToComboColumn(num, column, comboValueFactory);
        this.view.getColumns().add((Object)column);
        return column;
    }

    @Deprecated
    public TreeTableColumn<T, String> addColumn(String headerLabel, int prefWidth, boolean readOnly) {
        return this.addColumn(headerLabel, prefWidth);
    }

    public TreeTableView<T> getControl() {
        return this.view;
    }

    @Override
    protected T getSelectedObject() {
        TreeItem selectedItem = (TreeItem)this.view.getSelectionModel().getSelectedItem();
        Object value = selectedItem != null ? selectedItem.getValue() : null;
        return (T)value;
    }
}

