/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.control.treetableview;

import java.util.Collection;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import org.apache.commons.lang3.SystemUtils;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicList;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicListContentProvider;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeItem;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeItemBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeUIProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeViewerBase;

public final class DynamicTreeViewer<T>
extends DynamicTreeViewerBase<T> {
    private final TreeView<T> view;
    private final DynamicTreeItemBase<T> rootItem;
    private final DynamicTreeUIProviderBase<T> uiProvider;
    private ChangeListener<Object> selectionChangeListener = null;

    public DynamicTreeViewer(TreeView<T> view, Collection<T> list, DynamicListContentProvider<T> contentProvider, DynamicTreeUIProviderBase<T> uiProvider) {
        this(view, new DynamicList<T>(list, contentProvider), false, 0, (DynamicTreeContentProviderBase<T>)contentProvider, uiProvider);
    }

    public DynamicTreeViewer(TreeView<T> view, T root, boolean showRoot, int revealLevel, DynamicTreeContentProviderBase<T> contentProvider, DynamicTreeUIProviderBase<T> uiProvider) {
        this(view, new DynamicTreeItem<T>(root, contentProvider), showRoot, revealLevel, contentProvider, uiProvider);
    }

    public DynamicTreeViewer(T root, boolean showRoot, int revealLevel, DynamicTreeContentProviderBase<T> contentProvider, DynamicTreeUIProviderBase<T> uiProvider) {
        this(new TreeView(), root, showRoot, revealLevel, contentProvider, uiProvider);
    }

    public DynamicTreeViewer(TreeView<T> view, DynamicTreeItemBase<T> rootItem, boolean showRoot, int revealLevel, DynamicTreeContentProviderBase<T> contentProvider, DynamicTreeUIProviderBase<T> uiProvider) {
        super((Control)view, contentProvider);
        this.uiProvider = uiProvider;
        this.view = view;
        this.rootItem = rootItem;
        view.setRoot(rootItem);
        view.setShowRoot(showRoot);
        this.configureCellFactory();
        view.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> {
            if (this.selectionChangeListener != null) {
                Object oVal = oldVal != null ? oldVal.getValue() : null;
                Object nVal = newVal != null ? newVal.getValue() : null;
                this.selectionChangeListener.changed(obs, oVal, nVal);
            }
        });
        rootItem.update();
        this.expandItem(rootItem, showRoot ? revealLevel : revealLevel + 1);
    }

    public void update() {
        DynamicTreeItemBase rootItem = (DynamicTreeItemBase)this.view.getRoot();
        rootItem.update();
        this.view.refresh();
    }

    public void setSelection(Object value) {
        DynamicTreeItemBase rootItem = (DynamicTreeItemBase)this.view.getRoot();
        DynamicTreeItemBase<T> item = this.findItem(rootItem, value);
        int row = this.view.getRow(item);
        this.view.getSelectionModel().select(row);
    }

    public DynamicTreeItemBase<T> findItem(T value) {
        return this.findItem(this.rootItem, value);
    }

    public DynamicTreeItemBase<T> findItem(DynamicTreeItemBase<T> item, Object value) {
        if (item == null || value == null || item.getValue() == null) {
            return null;
        }
        if (item.getValue().equals(value)) {
            return item;
        }
        for (TreeItem subItem : item.getChildren()) {
            DynamicTreeItemBase<T> i;
            if (!(subItem instanceof DynamicTreeItemBase) || (i = this.findItem((DynamicTreeItemBase)subItem, value)) == null) continue;
            return i;
        }
        return null;
    }

    public void setSelectionListener(ChangeListener<Object> listener) {
        this.selectionChangeListener = listener;
    }

    private void configureCellFactory() {
        this.view.setCellFactory(param -> {
            TreeCell cell = new TreeCell<T>(){

                public void updateItem(T item, boolean empty) {
                    super.updateItem(item, empty);
                    ContextMenu menu = null;
                    if (!empty && item != null) {
                        menu = DynamicTreeViewer.this.uiProvider.createContextMenu(item);
                        if (SystemUtils.IS_OS_LINUX && menu != null) {
                            DynamicTreeViewer.this.addContextMenuHandler(menu, item);
                        }
                        this.setText(DynamicTreeViewer.this.uiProvider.getLabel(item));
                        this.setGraphic(DynamicTreeViewer.this.uiProvider.getIconNode(item));
                        this.setStyle(DynamicTreeViewer.this.uiProvider.getCellStyle(item));
                        this.setOnDragDetected(evt -> DynamicTreeViewer.this.dragDetected((MouseEvent)evt, this, item));
                        this.setOnDragOver(evt -> DynamicTreeViewer.this.dragOver((DragEvent)evt, item));
                        this.setOnDragDropped(evt -> DynamicTreeViewer.this.dragDropped((DragEvent)evt, item));
                    } else {
                        this.setText(null);
                        this.setGraphic(null);
                        this.setStyle(null);
                    }
                    this.setContextMenu(menu);
                }
            };
            return cell;
        });
    }

    private void addContextMenuHandler(ContextMenu menu, T element) {
        this.view.addEventHandler(MouseEvent.MOUSE_RELEASED, e -> {
            if (e.getButton() == MouseButton.SECONDARY) {
                TreeItem selected = (TreeItem)this.view.getSelectionModel().getSelectedItem();
                if (selected != null && selected.getValue() == element) {
                    menu.show(this.view, e.getScreenX(), e.getScreenY());
                    e.consume();
                }
            } else {
                menu.hide();
            }
        });
    }

    private void dragDetected(MouseEvent evt, TreeCell<T> cell, T item) {
        ClipboardContent cbContent = this.uiProvider.getDragClipboardContent(item);
        if (cbContent != null) {
            Dragboard db = cell.startDragAndDrop(TransferMode.ANY);
            db.setContent((Map)cbContent);
            evt.consume();
        }
    }

    private void dragOver(DragEvent evt, T item) {
        if (this.uiProvider.dragOver(item, evt.getDragboard())) {
            evt.consume();
        }
    }

    private void dragDropped(DragEvent evt, T item) {
        this.uiProvider.dropClipboardContent(item, evt.getDragboard());
    }

    public void collapseItem(TreeItem<T> item) {
        item.setExpanded(false);
    }

    public void collapseAllItems() {
        this.collapseItem(this.rootItem);
    }

    public void expandItem(TreeItem<T> item) {
        while (item.getParent() != null) {
            item = item.getParent();
            item.setExpanded(true);
        }
    }

    private void expandItem(TreeItem<T> parentItem, int revealLevel) {
        if (revealLevel <= 0) {
            return;
        }
        parentItem.setExpanded(true);
        --revealLevel;
        for (TreeItem child : parentItem.getChildren()) {
            this.expandItem(child, revealLevel);
        }
    }

    public void expandAllItems() {
        this.expandAllItems(this.rootItem);
    }

    private void expandAllItems(TreeItem<T> item) {
        item.setExpanded(true);
        for (TreeItem child : item.getChildren()) {
            this.expandAllItems(child);
        }
    }

    public TreeView<T> getControl() {
        return this.view;
    }

    public DynamicTreeUIProviderBase<T> getUIProvider() {
        return this.uiProvider;
    }

    @Override
    protected Object getSelectedObject() {
        DynamicTreeItem item = (DynamicTreeItem)this.view.getSelectionModel().getSelectedItem();
        if (item != null) {
            return item.getValue();
        }
        return null;
    }
}

