/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.control.treetableview;

import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.scene.control.Control;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.IDoubleClickHandler;

abstract class DynamicTreeViewerBase<T> {
    private IDoubleClickHandler doubleClickHandler;
    protected DoubleClickEventDispatcher doubleClickEventDispatcher;
    private final DynamicTreeContentProviderBase<T> contentProvider;

    public DynamicTreeViewerBase(Control control, DynamicTreeContentProviderBase<T> contentProvider) {
        this.contentProvider = contentProvider;
        this.setupEventDispatcher(control);
    }

    protected void setupEventDispatcher(Control control) {
        EventDispatcher original = control.getEventDispatcher();
        control.setEventDispatcher((EventDispatcher)new DoubleClickEventDispatcher(original));
    }

    public final DynamicTreeContentProviderBase<T> getContentProvider() {
        return this.contentProvider;
    }

    public void setDoubleClickHandler(IDoubleClickHandler handler) {
        this.doubleClickHandler = handler;
    }

    protected abstract Object getSelectedObject();

    private class DoubleClickEventDispatcher
    implements EventDispatcher {
        private final EventDispatcher original;

        public DoubleClickEventDispatcher(EventDispatcher original) {
            this.original = original;
        }

        public Event dispatchEvent(Event event, EventDispatchChain tail) {
            MouseEvent mevt;
            if (event instanceof MouseEvent && (mevt = (MouseEvent)event).getButton() == MouseButton.PRIMARY && mevt.getClickCount() >= 2) {
                Object item;
                if (mevt.getEventType().equals(MouseEvent.MOUSE_CLICKED) && DynamicTreeViewerBase.this.doubleClickHandler != null && (item = DynamicTreeViewerBase.this.getSelectedObject()) != null) {
                    DynamicTreeViewerBase.this.doubleClickHandler.doubleClicked(item);
                }
                event.consume();
            }
            return this.original.dispatchEvent(event, tail);
        }
    }
}

