/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.control.treetableview;

import java.lang.reflect.Constructor;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import org.eclipse.jface.resource.ImageDescriptor;
import patched.javafx.embed.swt.SWTFXUtils;

public abstract class TreeContextMenuItem<T>
extends MenuItem {
    private T element;

    protected TreeContextMenuItem(T element, String label) {
        super(label);
        this.init(element);
    }

    protected TreeContextMenuItem(T element, String label, Node graphic) {
        super(label, graphic);
        this.init(element);
    }

    protected TreeContextMenuItem(T element, String label, ImageDescriptor imgDescr) {
        this(element, label, TreeContextMenuItem.getSelectIcon(imgDescr));
    }

    private static Node getSelectIcon(ImageDescriptor imgDescr) {
        WritableImage fxIcon = SWTFXUtils.toFXImage(imgDescr.getImageData(100), null);
        return new ImageView((Image)fxIcon);
    }

    private void init(T element) {
        this.element = element;
        this.setOnAction(this.createOnActionHandler());
    }

    protected T getElement() {
        return this.element;
    }

    public abstract boolean isHidden();

    public abstract boolean isDisabled();

    protected abstract EventHandler<ActionEvent> createOnActionHandler();

    public static <T> ContextMenu createTreeContextMenu(List<Class<? extends TreeContextMenuItem<T>>> contextMenuEntryTypes, T element) {
        boolean previousWasItem = false;
        boolean needSeparator = false;
        ContextMenu menu = new ContextMenu();
        for (Class<TreeContextMenuItem<T>> entryType : contextMenuEntryTypes) {
            if (entryType == null) {
                if (!previousWasItem) continue;
                needSeparator = true;
                previousWasItem = false;
                continue;
            }
            try {
                Constructor<?>[] ctrs = entryType.getConstructors();
                if (ctrs.length != 1) {
                    throw new RuntimeException("Subclasses of TreeContextMenuItem must provide exactly one public constructor");
                }
                Constructor<?> ctr = ctrs[0];
                if (ctr.getParameterCount() != 1) {
                    throw new RuntimeException("The constructor of subclasses of TreeContextMenuItem must take the tree element for which the context menu is created as single argument.");
                }
                TreeContextMenuItem entry = (TreeContextMenuItem)((Object)ctr.newInstance(element));
                if (entry.isHidden()) continue;
                if (needSeparator) {
                    menu.getItems().add((Object)new SeparatorMenuItem());
                    needSeparator = false;
                }
                menu.getItems().add((Object)entry);
                entry.setDisable(entry.isDisabled());
                previousWasItem = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return menu;
    }
}

