/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.layout;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;
import org.fortiss.tooling.common.ui.javafx.layout.ICompositeFXController;
import org.fortiss.tooling.common.ui.javafx.util.JavaFXUtils;

public abstract class CompositeFXControllerBase<T extends Node, S extends Node>
implements ICompositeFXController<T, S> {
    private T layout;
    private ICompositeFXController<? extends S, ?>[] containments;

    public CompositeFXControllerBase(ICompositeFXController<? extends S, ?> ... containments) {
        this.containments = containments;
    }

    @Override
    public T getLayout() {
        return this.layout;
    }

    @Override
    public List<ICompositeFXController<? extends S, ?>> getContainments() {
        return Arrays.asList(this.containments);
    }

    @Override
    public void loadLayout() {
        this.getContainments().forEach(containment -> containment.loadLayout());
        if (this.layout == null) {
            URL fxmlResource = this.getClass().getResource(this.getFXMLLocation());
            try {
                this.layout = (Node)JavaFXUtils.loadFXML(fxmlResource, this);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot load the resource located at " + this.getFXMLLocation(), e);
            }
        }
    }

    protected void fitToParent(Node child) {
        if (child.getParent() instanceof AnchorPane) {
            AnchorPane.setBottomAnchor((Node)child, (Double)0.0);
            AnchorPane.setTopAnchor((Node)child, (Double)0.0);
            AnchorPane.setLeftAnchor((Node)child, (Double)0.0);
            AnchorPane.setRightAnchor((Node)child, (Double)0.0);
        }
    }
}

