/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef;

import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewer;
import org.fortiss.tooling.common.ui.javafx.lwfxef.MouseState;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;

public final class DiagramLayers
extends Group {
    private final Layer bottomLayer = new Layer();
    private final Layer contentLayer = new Layer();
    private final Layer linkLayer = new Layer();
    private final Layer anchorageLayer = new Layer();
    private final Layer textLayer = new Layer();
    private final Layer visualFeedbackLayer = new Layer();
    private final Layer contentInteractionLayer = new Layer();
    private final Layer anchorageInteractionLayer = new Layer();
    private final Layer linkInteractionLayer = new Layer();
    private final Layer topLayer = new Layer();
    private final MouseState mouseState;

    public DiagramLayers(DiagramViewer viewer) {
        ObservableList c = this.getChildren();
        c.add((Object)this.bottomLayer);
        c.add((Object)this.contentLayer);
        c.add((Object)this.anchorageLayer);
        c.add((Object)this.linkLayer);
        c.add((Object)this.visualFeedbackLayer);
        c.add((Object)this.textLayer);
        c.add((Object)this.contentInteractionLayer);
        c.add((Object)this.anchorageInteractionLayer);
        c.add((Object)this.linkInteractionLayer);
        c.add((Object)this.topLayer);
        this.mouseState = new MouseState(viewer);
    }

    public MouseState getMouseState() {
        return this.mouseState;
    }

    public ILayer getBottomLayer() {
        return this.bottomLayer;
    }

    public ILayer getContentLayer() {
        return this.contentLayer;
    }

    public ILayer getAnchorageLayer() {
        return this.anchorageLayer;
    }

    public ILayer getLinkLayer() {
        return this.linkLayer;
    }

    public ILayer getVisualFeedbackLayer() {
        return this.visualFeedbackLayer;
    }

    public ILayer getTextLayer() {
        return this.textLayer;
    }

    public ILayer getContentInteractionLayer() {
        return this.contentInteractionLayer;
    }

    public ILayer getAnchorageInteractionLayer() {
        return this.anchorageInteractionLayer;
    }

    public ILayer getLinkInteractionLayer() {
        return this.linkInteractionLayer;
    }

    public ILayer getTopLayer() {
        return this.topLayer;
    }

    public boolean isInteractionFeedback(Node node) {
        return node.getParent() == this.contentInteractionLayer;
    }

    public void clearLayers() {
        this.bottomLayer.clear();
        this.contentLayer.clear();
        this.anchorageLayer.clear();
        this.linkLayer.clear();
        this.visualFeedbackLayer.clear();
        this.textLayer.clear();
        this.contentInteractionLayer.clear();
        this.anchorageInteractionLayer.clear();
        this.linkInteractionLayer.clear();
        this.topLayer.clear();
    }

    public static interface ILayer {
        public void add(Node var1, IMVCBundle var2);

        public void remove(Node var1);

        public void clear();
    }

    private class Layer
    extends Group
    implements ILayer {
        private Layer() {
        }

        @Override
        public void add(Node node, IMVCBundle bundle) {
            if (node == null || bundle == null || node.getParent() != null) {
                return;
            }
            this.getChildren().add((Object)node);
            DiagramLayers.this.mouseState.registerMouseListeners(node, bundle);
        }

        @Override
        public void remove(Node node) {
            if (node == null || node.getParent() != this) {
                return;
            }
            DiagramLayers.this.mouseState.unregisterMouseListeners(node);
            this.getChildren().remove((Object)node);
        }

        @Override
        public void clear() {
            for (Node node : this.getChildren()) {
                DiagramLayers.this.mouseState.unregisterMouseListeners(node);
            }
            this.getChildren().clear();
        }
    }
}

