/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javafx.event.EventHandler;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollBar;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.fortiss.tooling.common.ui.ToolingCommonUIActivator;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramLayers;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerDefaultTags;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerFeatures;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerSelection;
import org.fortiss.tooling.common.ui.javafx.lwfxef.EDragGesture;
import org.fortiss.tooling.common.ui.javafx.lwfxef.MVCBundleManager;
import org.fortiss.tooling.common.ui.javafx.lwfxef.SVGExporter;
import org.fortiss.tooling.common.ui.javafx.lwfxef.change.Change;
import org.fortiss.tooling.common.ui.javafx.lwfxef.change.ChangeSet;
import org.fortiss.tooling.common.ui.javafx.lwfxef.change.DefaultModelModifier;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IControllerFactory;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IDragController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IKeyPressController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.IModelFactory;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IDiagramAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IDiagramMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.ILinkMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.MVCBundleTag;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IVisualFactory;
import org.fortiss.tooling.common.ui.javafx.util.GraphicUtils;

public class DiagramViewer {
    private final Double[] DEFAULT_DASH_STROKE_PATTERN = new Double[]{15.0, 5.0};
    private final MVCBundleManager viewerManager;
    private final DiagramViewerFeatures features;
    private final GridPane scrolledPane;
    private final ScrollBar horizontalScrollbar;
    private final ScrollBar verticalScrollbar;
    private final DiagramLayers layers;
    private final Pane viewerPane;
    private final Label helpLabel = new Label("");
    private Text helpText = null;
    private final Rectangle helpShadow = new Rectangle(0.0, 0.0);
    private final Rectangle mouseDragRectangle = new Rectangle(0.0, 0.0);
    private Point2D mouseDragRectangleStartLocation = new Point2D(0.0, 0.0);
    private final Line linkLineFeedback = new Line();
    private ContextMenu contextMenu = null;
    private Affine transform = new Affine();
    private Label debugLabel = new Label("");

    public DiagramViewer(IModelFactory modelFactory, IVisualFactory visualFactory, IControllerFactory controllerFactory, Consumer<DiagramViewerSelection> selectionChangedCallback) {
        this(modelFactory, visualFactory, controllerFactory, selectionChangedCallback, new DefaultModelModifier());
    }

    public DiagramViewer(IModelFactory modelFactory, IVisualFactory visualFactory, IControllerFactory controllerFactory, Consumer<DiagramViewerSelection> selectionChangedCallback, Consumer<Change> modelModifier) {
        this.features = new DiagramViewerFeatures(this);
        this.layers = new DiagramLayers(this);
        this.viewerManager = new MVCBundleManager(this, modelFactory, visualFactory, controllerFactory, this.layers, selectionChangedCallback, Objects.requireNonNull(modelModifier));
        this.mouseDragRectangle.setFill((Paint)Color.TRANSPARENT);
        this.mouseDragRectangle.setStroke((Paint)Color.ORANGERED);
        this.mouseDragRectangle.getStrokeDashArray().addAll((Object[])this.DEFAULT_DASH_STROKE_PATTERN);
        this.mouseDragRectangle.setMouseTransparent(true);
        this.viewerPane = new Pane();
        this.layers.boundsInLocalProperty().addListener((obs, ov, nv) -> this.updateScrollBars());
        this.layers.getTransforms().add((Object)this.transform);
        this.viewerPane.getChildren().add((Object)this.layers);
        this.viewerPane.widthProperty().addListener(evt -> {
            this.updateGridCanvasSize();
            this.updateScrollBars();
        });
        this.viewerPane.heightProperty().addListener(evt -> {
            this.updateGridCanvasSize();
            this.updateScrollBars();
        });
        this.viewerPane.focusedProperty().addListener((obs, ov, nv) -> this.viewerManager.handleFocus((boolean)nv, this.getLayers()));
        this.viewerPane.addEventFilter(MouseEvent.MOUSE_CLICKED, evt -> {
            if (evt.isAltDown()) {
                Point2D p = this.layers.sceneToLocal(evt.getSceneX(), evt.getSceneY());
                this.scrollToCenter(new DiagramCoordinate(p.getX(), p.getY()));
            }
        });
        this.scrolledPane = new GridPane();
        this.scrolledPane.add((Node)this.viewerPane, 1, 1);
        GridPane.setHgrow((Node)this.viewerPane, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)this.viewerPane, (Priority)Priority.ALWAYS);
        this.verticalScrollbar = this.createContentScrollBar(Orientation.VERTICAL);
        this.scrolledPane.add((Node)this.verticalScrollbar, 2, 1);
        this.horizontalScrollbar = this.createContentScrollBar(Orientation.HORIZONTAL);
        this.scrolledPane.add((Node)this.horizontalScrollbar, 1, 2);
        this.viewerPane.getChildren().add((Object)this.debugLabel);
        this.debugLabel.setLayoutX(20.0);
        this.debugLabel.setLayoutY(20.0);
        this.debugLabel.setTextFill((Paint)Color.ORANGERED);
        this.viewerPane.getChildren().add((Object)this.helpLabel);
        Image helpImage = GraphicUtils.getFXImage(ToolingCommonUIActivator.PLUGIN_ID, "/icons/help.png");
        ImageView view = new ImageView(helpImage);
        this.helpLabel.setGraphic((Node)view);
        this.helpLabel.setLayoutX(this.viewerPane.getWidth() - this.helpLabel.getWidth());
        this.helpLabel.setLayoutY(0.0);
        this.helpLabel.setOnMouseClicked(evt -> this.toggleHelp());
        Rectangle viewerClip = new Rectangle();
        this.viewerPane.setClip((Node)viewerClip);
        this.viewerPane.layoutBoundsProperty().addListener((obs, ov, nv) -> {
            double width = nv.getWidth();
            viewerClip.setWidth(width);
            viewerClip.setHeight(nv.getHeight());
            this.helpLabel.setLayoutX(width - this.helpLabel.getWidth());
        });
        this.viewerManager.updateContentObjects();
        this.viewerPane.addEventFilter(ScrollEvent.SCROLL, this.getScrollingFilter());
        ContentDragController contentDragController = new ContentDragController();
        contentDragController.registerEventFilters((Node)this.viewerPane);
    }

    private ScrollBar createContentScrollBar(Orientation orientation) {
        ScrollBar scrollbar = new ScrollBar();
        scrollbar.setOrientation(orientation);
        scrollbar.valueProperty().addListener((obs, ov, nv) -> {
            this.hideContextMenu();
            Point2D diagramTranslation = this.layers.parentToLocal(0.0, 0.0);
            switch (orientation) {
                case HORIZONTAL: {
                    this.transform.appendTranslation(-nv.doubleValue() + diagramTranslation.getX(), 0.0);
                    break;
                }
                case VERTICAL: {
                    this.transform.appendTranslation(0.0, -nv.doubleValue() + diagramTranslation.getY());
                }
            }
            this.viewerManager.gridCanvasVisual.updateNodes(this.layers);
        });
        return scrollbar;
    }

    Pane getViewerPane() {
        return this.viewerPane;
    }

    IDiagramMVCBundle getDiagramBundle() {
        return this.viewerManager.diagramBundle;
    }

    void hideContextMenu() {
        if (this.contextMenu != null && this.contextMenu.isShowing()) {
            this.contextMenu.hide();
            this.contextMenu = null;
        }
    }

    public void showContextMenu(Node node, DiagramCoordinate diagramLocation, IMVCBundle mvcb) {
        List<MenuItem> items = mvcb.getController().contextMenuContributions(node, diagramLocation);
        if (items == null || items.isEmpty()) {
            return;
        }
        for (MenuItem item : items) {
            EventHandler baseEventHandler = item.getOnAction();
            item.setOnAction(event -> {
                this.hideContextMenu();
                if (baseEventHandler != null) {
                    baseEventHandler.handle(event);
                }
            });
        }
        this.contextMenu = new ContextMenu();
        this.contextMenu.getItems().addAll(items);
        this.contextMenu.setAutoHide(true);
        Point2D screenLocation = this.layers.localToScreen(diagramLocation);
        this.contextMenu.show(node, screenLocation.getX(), screenLocation.getY());
    }

    public Object getRootElement() {
        return this.viewerManager.getRootModel();
    }

    public DiagramViewerFeatures getFeatures() {
        return this.features;
    }

    public String getSVGExport() {
        SVGExporter exporter = new SVGExporter(this);
        return exporter.export();
    }

    private void updateScrollBars() {
        Bounds contentBounds = this.layers.getBoundsInLocal();
        double contentHeight = contentBounds.getMinY() + contentBounds.getHeight();
        double contentWidth = contentBounds.getMinX() + contentBounds.getWidth();
        Bounds visibleBounds = this.layers.parentToLocal(this.viewerPane.getLayoutBounds());
        double visibleWidth = visibleBounds.getWidth();
        double visibleHeight = visibleBounds.getHeight();
        this.verticalScrollbar.setMin(0.0);
        this.horizontalScrollbar.setMin(0.0);
        this.verticalScrollbar.setMax(contentHeight);
        this.horizontalScrollbar.setMax(contentWidth);
        Point2D diagramTopLeft = this.layers.parentToLocal(0.0, 0.0);
        this.verticalScrollbar.setValue(diagramTopLeft.getY());
        this.horizontalScrollbar.setValue(diagramTopLeft.getX());
        double verticalVisibleAmount = contentHeight * visibleHeight / (contentHeight + visibleHeight);
        double horizontalVisibleAmount = contentWidth * visibleWidth / (contentWidth + visibleWidth);
        this.verticalScrollbar.setVisibleAmount(verticalVisibleAmount);
        this.horizontalScrollbar.setVisibleAmount(horizontalVisibleAmount);
        this.verticalScrollbar.setUnitIncrement(1.0);
        this.horizontalScrollbar.setUnitIncrement(1.0);
        this.verticalScrollbar.setBlockIncrement(this.verticalScrollbar.getVisibleAmount());
        this.horizontalScrollbar.setBlockIncrement(this.horizontalScrollbar.getVisibleAmount());
    }

    void updateGridCanvasSize() {
        Bounds viewer = this.viewerPane.getBoundsInLocal();
        this.viewerManager.gridCanvasVisual.setWidth(viewer.getWidth());
        this.viewerManager.gridCanvasVisual.setHeight(viewer.getHeight());
    }

    public Pane getVisualNode() {
        return this.scrolledPane;
    }

    public double getHorizontalScrollBarValue() {
        return this.horizontalScrollbar.getValue();
    }

    public double getVerticalScrollBarValue() {
        return this.verticalScrollbar.getValue();
    }

    public Consumer<Change> getModelModifier() {
        return this.viewerManager.getModelModifier();
    }

    public Change deleteAllSelected() {
        DiagramViewerSelection sel = this.getSelection();
        return () -> {
            sel.getPrimarySelection().getController().delete();
            for (IMVCBundle sec : sel.getSecondarySelections()) {
                sec.getController().delete();
            }
        };
    }

    public DiagramViewerSelection getSelection() {
        return this.viewerManager.getSelection();
    }

    public void setSingleSelectedMVCBundle(IMVCBundle sel) {
        this.viewerManager.setSingleSelectedMVCBundle(sel);
    }

    public boolean isPrimarySelected(IMVCBundle bundle) {
        return this.viewerManager.isPrimarySelected(bundle);
    }

    public boolean isSecondarySelected(IMVCBundle bundle) {
        return this.viewerManager.isSecondarySelected(bundle);
    }

    public boolean isSelected(IMVCBundle bundle) {
        return this.isPrimarySelected(bundle) || this.isSecondarySelected(bundle);
    }

    public void addSelectedMVCBundle(IMVCBundle sel) {
        this.viewerManager.addSelectedMVCBundle(sel);
    }

    public void selectAll() {
        this.viewerManager.selectAll();
    }

    public void handleCtrlSelectionOf(IMVCBundle sel) {
        this.viewerManager.handleCtrlSelectionOf(sel);
    }

    public void removeSelectedMVCBundle(IMVCBundle sel) {
        this.viewerManager.removeSelectedMVCBundle(sel);
    }

    public IVisualFactory getVisualFactory() {
        return this.viewerManager.visualFactory;
    }

    public IControllerFactory getControllerFactory() {
        return this.viewerManager.controllerFactory;
    }

    public IModelFactory getModelFactory() {
        return this.viewerManager.modelFactory;
    }

    private void enforceBounds() {
        Bounds contentBounds = this.layers.getBoundsInLocal();
        BoundingBox enforceContentBounds = new BoundingBox(0.0, 0.0, contentBounds.getMaxX(), contentBounds.getMaxY());
        Bounds contentInParent = this.layers.localToParent((Bounds)enforceContentBounds);
        double leftBoundCorrection = Math.max(contentInParent.getMinX(), 0.0);
        double topBoundCorrection = Math.max(contentInParent.getMinY(), 0.0);
        double rightBoundCorrection = Math.min(contentInParent.getMaxX(), 0.0);
        double bottomBoundCorrection = Math.min(contentInParent.getMaxY(), 0.0);
        Point2D clampedInParent = new Point2D(leftBoundCorrection + rightBoundCorrection, topBoundCorrection + bottomBoundCorrection);
        Point2D correctionLocal = this.layers.parentToLocal(clampedInParent);
        Point2D originLocal = this.layers.parentToLocal(0.0, 0.0);
        this.transform.appendTranslation(originLocal.getX() - correctionLocal.getX(), originLocal.getY() - correctionLocal.getY());
    }

    void appendContentTransform(Transform t) {
        this.transform.append(t);
        this.enforceBounds();
        this.updateScrollBars();
        this.viewerManager.gridCanvasVisual.updateNodes(this.layers);
    }

    private EventHandler<? super ScrollEvent> getScrollingFilter() {
        return evt -> {
            evt.consume();
            if (evt.isControlDown()) {
                if (this.features.getZoomFactorIndex() == -1) {
                    return;
                }
                if (evt.getDeltaY() > 0.0) {
                    Point2D pivot = this.layers.sceneToLocal(evt.getSceneX(), evt.getSceneY());
                    this.features.zoomIn(pivot.getX(), pivot.getY());
                } else if (evt.getDeltaY() < 0.0) {
                    Point2D pivot = this.layers.sceneToLocal(evt.getSceneX(), evt.getSceneY());
                    this.features.zoomOut(pivot.getX(), pivot.getY());
                }
            } else if (evt.isShiftDown()) {
                Point2D p0 = this.layers.screenToLocal(0.0, 0.0);
                Point2D p1 = this.layers.screenToLocal(1.0, 1.0);
                double hmax = this.horizontalScrollbar.getMax();
                double hmin = this.horizontalScrollbar.getMin();
                double nval = this.horizontalScrollbar.getValue() - evt.getDeltaY() * Math.abs(p1.getX() - p0.getX());
                this.horizontalScrollbar.setValue(Math.max(hmin, Math.min(hmax, nval)));
            } else {
                Point2D p0 = this.layers.screenToLocal(0.0, 0.0);
                Point2D p1 = this.layers.screenToLocal(1.0, 1.0);
                double vmax = this.verticalScrollbar.getMax();
                double vmin = this.verticalScrollbar.getMin();
                double vval = this.verticalScrollbar.getValue() - evt.getDeltaY() * Math.abs(p1.getY() - p0.getY());
                double hmax = this.horizontalScrollbar.getMax();
                double hmin = this.horizontalScrollbar.getMin();
                double hval = this.horizontalScrollbar.getValue() - evt.getDeltaX() * Math.abs(p1.getX() - p0.getX());
                this.verticalScrollbar.setValue(Math.max(vmin, Math.min(vmax, vval)));
                this.horizontalScrollbar.setValue(Math.max(hmin, Math.min(hmax, hval)));
            }
        };
    }

    public void updateAllVisuals() {
        this.viewerManager.updateAllVisuals();
    }

    public void updateVisual(IMVCBundle bundle) {
        this.viewerManager.updateVisual(bundle);
    }

    public void updateModelVisual(Object model) {
        this.viewerManager.updateModelVisual(model);
    }

    public void updateFromModel() {
        this.viewerManager.updateContentObjects();
    }

    public void requestFocus() {
        this.viewerPane.requestFocus();
    }

    public boolean hasFocus() {
        return this.viewerPane.isFocused();
    }

    public void setDebugMessage(String msg) {
        this.debugLabel.setText(msg);
    }

    public DiagramLayers getLayers() {
        return this.layers;
    }

    public void startSelectionFeedback(Node node, DiagramCoordinate locationInDiagram) {
        if (node == null || locationInDiagram == null) {
            return;
        }
        this.mouseDragRectangleStartLocation = locationInDiagram;
        this.mouseDragRectangle.setX(this.mouseDragRectangleStartLocation.getX());
        this.mouseDragRectangle.setY(this.mouseDragRectangleStartLocation.getY());
        this.mouseDragRectangle.setWidth(0.0);
        this.mouseDragRectangle.setHeight(0.0);
        if (this.mouseDragRectangle.getParent() == null) {
            this.layers.getVisualFeedbackLayer().add((Node)this.mouseDragRectangle, this.viewerManager.diagramBundle);
        }
        this.setSingleSelectedMVCBundle(null);
    }

    DiagramCoordinate convertEventToDiagramCoordinates(Point2D absoluteLocation, Node node) {
        return this.convertEventToDiagramCoordinates(absoluteLocation.getX(), absoluteLocation.getY(), node);
    }

    DiagramCoordinate convertEventToDiagramCoordinates(double evtX, double evtY, Node node) {
        Point2D scene = node.localToScene(evtX, evtY);
        Point2D diagram = this.layers.sceneToLocal(scene);
        return new DiagramCoordinate(diagram.getX(), diagram.getY());
    }

    DiagramCoordinate getDefaultZoomPivot() {
        Point2D pivot = this.layers.parentToLocal(0.0, 0.0);
        return new DiagramCoordinate(pivot.getX(), pivot.getY());
    }

    public void scrollToComponent(Object component) {
        IMVCBundle bundle = this.viewerManager.contentBundles.get(component);
        if (bundle != null) {
            Rectangle2D bounds = bundle.getVisual().getCurrentBounds();
            double centerX = (bounds.getMinX() + bounds.getMaxX()) / 2.0;
            double centerY = (bounds.getMinY() + bounds.getMaxY()) / 2.0;
            this.scrollToCenter(new DiagramCoordinate(centerX, centerY));
        }
    }

    public void scrollToCenter(DiagramCoordinate center) {
        Point2D centerScene = this.viewerPane.localToScene(this.viewerPane.getWidth() / 2.0, this.viewerPane.getHeight() / 2.0);
        Point2D currentCenter = this.layers.sceneToLocal(centerScene);
        double dx = currentCenter.getX() - center.getX();
        double dy = currentCenter.getY() - center.getY();
        this.appendContentTransform((Transform)new Translate(dx, dy));
    }

    public void updateSelectionFeedback(Node node, Point2D locationInDiagram) {
        if (node == null || locationInDiagram == null) {
            return;
        }
        Point2D location = locationInDiagram;
        double x = Math.min(this.mouseDragRectangleStartLocation.getX(), location.getX());
        this.mouseDragRectangle.setX(x);
        double w = Math.abs(this.mouseDragRectangleStartLocation.getX() - location.getX());
        this.mouseDragRectangle.setWidth(w);
        double y = Math.min(this.mouseDragRectangleStartLocation.getY(), location.getY());
        this.mouseDragRectangle.setY(y);
        double h = Math.abs(this.mouseDragRectangleStartLocation.getY() - location.getY());
        this.mouseDragRectangle.setHeight(h);
    }

    public void terminateSelectionFeedback(Node node, Point2D locationInDiagram) {
        if (node == null || locationInDiagram == null) {
            return;
        }
        Point2D location = locationInDiagram;
        double x = Math.min(this.mouseDragRectangleStartLocation.getX(), location.getX());
        double w = Math.abs(this.mouseDragRectangleStartLocation.getX() - location.getX());
        double y = Math.min(this.mouseDragRectangleStartLocation.getY(), location.getY());
        double h = Math.abs(this.mouseDragRectangleStartLocation.getY() - location.getY());
        this.layers.getVisualFeedbackLayer().remove((Node)this.mouseDragRectangle);
        Rectangle2D selectionRect = new Rectangle2D(x, y, w, h);
        this.setSingleSelectedMVCBundle(null);
        for (IContentMVCBundle cmvcb : this.viewerManager.contentBundles.values()) {
            Rectangle2D contentRect = cmvcb.getVisual().getCurrentBounds();
            if (contentRect == null || !selectionRect.contains(contentRect)) continue;
            this.addSelectedMVCBundle(cmvcb);
        }
        for (IDiagramAnchorageMVCBundle damvcb : this.viewerManager.diagramAnchorageBundles.values()) {
            Rectangle2D daRect = damvcb.getVisual().getCurrentBounds();
            if (daRect == null || !selectionRect.contains(daRect)) continue;
            this.addSelectedMVCBundle(damvcb);
        }
    }

    public void startNewLinkLineFeedback(IMVCBundle linkStartBundle, Node node, Point2D locationInDiagram) {
        if (node == null || locationInDiagram == null) {
            return;
        }
        Point2D location = locationInDiagram;
        this.linkLineFeedback.setStartX(location.getX());
        this.linkLineFeedback.setStartY(location.getY());
        this.linkLineFeedback.setEndX(location.getX());
        this.linkLineFeedback.setEndY(location.getY());
        if (this.linkLineFeedback.getParent() == null) {
            this.layers.getVisualFeedbackLayer().add((Node)this.linkLineFeedback, this.viewerManager.diagramBundle);
        }
        for (IMVCBundle possibleTarget : this.viewerManager.possibleLinkTargets) {
            IController controller = possibleTarget.getController();
            MVCBundleTag effect = controller.getLinkTargetEffectForNewLinkFrom(linkStartBundle);
            if (effect == null) continue;
            possibleTarget.addTag(effect);
            possibleTarget.getVisual().updateNodes(this.layers);
        }
    }

    public void updateNewLinkLineFeedback(Point2D locationInDiagram, Paint color) {
        this.linkLineFeedback.setEndX(locationInDiagram.getX());
        this.linkLineFeedback.setEndY(locationInDiagram.getY());
        this.linkLineFeedback.setStroke(color);
    }

    public void terminateNewLinkLineFeedback() {
        this.layers.getVisualFeedbackLayer().remove((Node)this.linkLineFeedback);
        this.clearLinkTargetFeedback();
    }

    private void clearLinkTargetFeedback() {
        for (IMVCBundle possibleTarget : this.viewerManager.possibleLinkTargets) {
            possibleTarget.removeTag(DiagramViewerDefaultTags.LINK_TARGET_ALLOWED_TAG);
            possibleTarget.removeTag(DiagramViewerDefaultTags.LINK_TARGET_DENIED_TAG);
            possibleTarget.removeTag(DiagramViewerDefaultTags.LINK_TARGET_MAYBE_TAG);
            possibleTarget.getVisual().updateNodes(this.layers);
        }
    }

    public void startMoveLinkFeedback(ILinkMVCBundle linkBundle, IAnchorageMVCBundle movedStartOrEnd) {
        for (IMVCBundle possibleTarget : this.viewerManager.possibleLinkTargets) {
            IController controller = possibleTarget.getController();
            MVCBundleTag effect = controller.getLinkTargetEffectForMoveLink(linkBundle, movedStartOrEnd);
            if (effect == null) continue;
            possibleTarget.addTag(effect);
            possibleTarget.getVisual().updateNodes(this.layers);
        }
    }

    public void terminateMoveLinkFeedback() {
        this.clearLinkTargetFeedback();
    }

    public DiagramCoordinate getLastMouseLocation() {
        return this.getLayers().getMouseState().getLastMouseLocation();
    }

    public DiagramCoordinate getDragExtent() {
        return this.getLayers().getMouseState().getDragExtent();
    }

    private void toggleHelp() {
        if (this.helpText == null) {
            String txt = this.features.getHelpText();
            if (txt == null || "".equals(txt)) {
                txt = "No in-place help available.";
            }
            this.helpText = new Text(txt);
            this.helpText.setFill((Paint)Color.WHITE);
            this.helpText.setLayoutY(0.0);
            double lw = this.viewerPane.getWidth() - this.helpLabel.getWidth();
            this.helpText.setLayoutX(lw * 0.2 + 3.0);
            this.helpText.setLayoutY(3.0);
            this.helpText.setTextOrigin(VPos.TOP);
            this.helpText.setWrappingWidth(lw * 0.8 - 6.0);
            this.helpText.setOnMouseClicked(evt -> this.toggleHelp());
            this.helpShadow.setX(lw * 0.2);
            this.helpShadow.setY(0.0);
            this.helpShadow.setWidth(lw * 0.8);
            this.helpShadow.setHeight(this.viewerPane.getHeight());
            this.helpShadow.setFill((Paint)Color.grayRgb((int)32, (double)0.66));
            this.helpShadow.setOnMouseClicked(evt -> this.toggleHelp());
            this.viewerPane.getChildren().add((Object)this.helpShadow);
            this.viewerPane.getChildren().add((Object)this.helpText);
        } else {
            this.viewerPane.getChildren().remove((Object)this.helpText);
            this.viewerPane.getChildren().remove((Object)this.helpShadow);
            this.helpText = null;
        }
    }

    public IDragController createDragController(IMVCBundle bundle, EDragGesture gesture, Node source, DiagramCoordinate lastMouseLocation) {
        DiagramViewerSelection sel = this.getSelection();
        if (!sel.isMultiSelection()) {
            return bundle.getController().getDragController(gesture, source, lastMouseLocation);
        }
        return new CompositeDragController(sel, gesture, source, lastMouseLocation);
    }

    public IKeyPressController createKeyPressController(IMVCBundle bundle, Node source, final DiagramCoordinate lastMouseLocation) {
        final DiagramViewerSelection sel = this.getSelection();
        if (sel.isMultiSelection()) {
            return new IKeyPressController(){

                @Override
                public Change keyEvent(KeyEvent event, IMVCBundle bundle, Node source, DiagramCoordinate mouseLocation) {
                    ChangeSet changeSet = new ChangeSet();
                    IMVCBundle primaryBundle = sel.getPrimarySelection();
                    IKeyPressController primaryKPC = primaryBundle.getController().getKeyPressController(source, lastMouseLocation);
                    Change primaryChg = primaryKPC.keyEvent(event, primaryBundle, source, lastMouseLocation);
                    if (primaryChg != null) {
                        changeSet.add(primaryChg);
                    }
                    for (IMVCBundle secondaryBundle : sel.getSecondarySelections()) {
                        IKeyPressController secondaryKPC = secondaryBundle.getController().getKeyPressController(source, lastMouseLocation);
                        Change secondaryChg = secondaryKPC.keyEvent(event, primaryBundle, source, lastMouseLocation);
                        if (secondaryChg == null) continue;
                        changeSet.add(secondaryChg);
                    }
                    if (!changeSet.isEmpty()) {
                        return changeSet;
                    }
                    return null;
                }
            };
        }
        return bundle.getController().getKeyPressController(source, lastMouseLocation);
    }

    private static final class CompositeDragController
    implements IDragController {
        private final Map<IDragController, IMVCBundle> controllers = new HashMap<IDragController, IMVCBundle>();

        public CompositeDragController(DiagramViewerSelection selection, EDragGesture gesture, Node source, DiagramCoordinate lastMouseLocation) {
            this.addDragController(selection.getPrimarySelection(), gesture, source, lastMouseLocation);
            for (IMVCBundle sec : selection.getSecondarySelections()) {
                this.addDragController(sec, gesture, source, lastMouseLocation);
            }
        }

        private void addDragController(IMVCBundle bundle, EDragGesture gesture, Node source, DiagramCoordinate lastMouseLocation) {
            if (bundle == null || bundle.getController() == null) {
                return;
            }
            IDragController dc = bundle.getController().getDragController(gesture, source, lastMouseLocation);
            if (dc != null) {
                this.controllers.put(dc, bundle);
            }
        }

        @Override
        public void dragStarted(IMVCBundle startBundle, Node startNode, DiagramCoordinate lastMouseLocation) {
            for (IDragController dc : this.controllers.keySet()) {
                IMVCBundle bundle = this.controllers.get(dc);
                dc.dragStarted(bundle, startNode, lastMouseLocation);
            }
        }

        @Override
        public void dragInProgress(IMVCBundle currentBundle, Node currentNode, DiagramCoordinate lastMouseLocation) {
            for (IDragController dc : this.controllers.keySet()) {
                IMVCBundle bundle = this.controllers.get(dc);
                dc.dragInProgress(bundle, currentNode, lastMouseLocation);
            }
        }

        @Override
        public Change dragCompleted(IMVCBundle endBundle, Node endNode, DiagramCoordinate lastMouseLocation) {
            ChangeSet cset = new ChangeSet();
            for (IDragController dc : this.controllers.keySet()) {
                Change chg = dc.dragCompleted(endBundle, endNode, lastMouseLocation);
                if (chg == null) continue;
                cset.add(chg);
            }
            if (!cset.isEmpty()) {
                return cset;
            }
            return null;
        }
    }

    private final class ContentDragController {
        private Point2D dragPoint;
        private boolean buttonReleased;
        private final EventHandler<MouseEvent> dragDetected = evt -> {
            if (this.dragPoint == null && evt.isControlDown() && evt.getButton() == MouseButton.PRIMARY) {
                this.dragPoint = DiagramViewer.this.getLayers().sceneToLocal(evt.getSceneX(), evt.getSceneY());
                this.buttonReleased = false;
                evt.consume();
            }
        };
        private final EventHandler<MouseEvent> dragged = evt -> {
            if (this.dragPoint != null) {
                evt.consume();
                Point2D evtLayer = DiagramViewer.this.getLayers().sceneToLocal(evt.getSceneX(), evt.getSceneY());
                Point2D move = evtLayer.subtract(this.dragPoint);
                double dx = move.getX();
                double dy = move.getY();
                DiagramViewer.this.appendContentTransform((Transform)new Translate(dx, dy));
                this.dragPoint = DiagramViewer.this.getLayers().sceneToLocal(evt.getSceneX(), evt.getSceneY());
            }
        };
        private final EventHandler<MouseEvent> mouseReleased = evt -> {
            if (this.dragPoint != null && evt.getButton() == MouseButton.PRIMARY) {
                this.dragPoint = null;
                this.buttonReleased = true;
                evt.consume();
            }
        };
        private final EventHandler<MouseEvent> mouseClicked = evt -> {
            if (this.buttonReleased && evt.getButton() == MouseButton.PRIMARY) {
                evt.consume();
            }
            this.buttonReleased = false;
        };

        private ContentDragController() {
        }

        void registerEventFilters(Node node) {
            node.addEventFilter(MouseEvent.MOUSE_DRAGGED, this.dragDetected);
            node.addEventFilter(MouseEvent.ANY, this.dragged);
            node.addEventFilter(MouseEvent.MOUSE_RELEASED, this.mouseReleased);
            node.addEventFilter(MouseEvent.MOUSE_CLICKED, this.mouseClicked);
        }
    }
}

