/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef;

import java.util.Objects;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import javafx.scene.paint.Color;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewer;

public final class DiagramViewerFeatures {
    private final DiagramViewer viewer;
    private double[] zoomFactors = new double[]{0.125, 0.25, 0.3, 0.4, 0.5, 0.65, 0.8, 1.0, 1.25, 1.5, 2.0, 2.5, 3.5, 4.5, 6.0};
    private int zoomFactorIndex = 7;
    private boolean linkHighlightingEnabled = false;
    private boolean interactionAreaShadingEnabled = false;
    private Dimension2D indicatorSpacing = new Dimension2D(20.0, 20.0);
    private boolean useSnapToGrid = true;
    private double indicatorSize = 2.0;
    private Color indicatorColor = Color.LIGHTGRAY.darker();
    private boolean drawOuterBorder = true;
    private IndicatorType currentIndicatorType = IndicatorType.INVISIBLE;
    private IndicatorType defaultIndicatorType = IndicatorType.CROSS;
    private Color backgroundColor = Color.LIGHTGRAY;
    private String helpText = null;

    public DiagramViewerFeatures(DiagramViewer diagramViewer) {
        this.viewer = diagramViewer;
    }

    public double[] getZoomFactors() {
        return this.zoomFactors;
    }

    public void setZoomFactors(double[] zoomFactors) {
        this.zoomFactors = zoomFactors;
        if (this.zoomFactorIndex >= zoomFactors.length) {
            this.zoomFactorIndex = zoomFactors.length - 1;
        }
        this.viewer.updateAllVisuals();
    }

    public int getZoomFactorIndex() {
        return this.zoomFactorIndex;
    }

    public double getCurrentZoomFactor() {
        return this.zoomFactorIndex == -1 ? 1.0 : this.zoomFactors[this.zoomFactorIndex];
    }

    public void setZoomFactorIndex(int zoomFactorIndex) {
        Objects.checkIndex(zoomFactorIndex, this.zoomFactors.length);
        double factor = this.zoomFactors[zoomFactorIndex] / this.zoomFactors[this.zoomFactorIndex];
        this.zoomFactorIndex = zoomFactorIndex;
        DiagramCoordinate pivot = this.viewer.getDefaultZoomPivot();
        this.viewer.appendContentTransform((Transform)new Scale(factor, factor, pivot.getX(), pivot.getY()));
    }

    public void zoomIn() {
        DiagramCoordinate pivot = this.viewer.getDefaultZoomPivot();
        this.zoomIn(pivot.getX(), pivot.getY());
    }

    public void zoomIn(double pivotX, double pivotY) {
        if (this.zoomFactorIndex < this.zoomFactors.length - 1) {
            ++this.zoomFactorIndex;
            double factor = this.zoomFactors[this.zoomFactorIndex] / this.zoomFactors[this.zoomFactorIndex - 1];
            this.viewer.appendContentTransform((Transform)new Scale(factor, factor, pivotX, pivotY));
        }
    }

    public void zoomOut() {
        DiagramCoordinate pivot = this.viewer.getDefaultZoomPivot();
        this.zoomOut(pivot.getX(), pivot.getY());
    }

    public void zoomOut(double pivotX, double pivotY) {
        if (this.zoomFactorIndex > 0) {
            --this.zoomFactorIndex;
            double factor = this.zoomFactors[this.zoomFactorIndex] / this.zoomFactors[this.zoomFactorIndex + 1];
            this.viewer.appendContentTransform((Transform)new Scale(factor, factor, pivotX, pivotY));
        }
    }

    public boolean isLinkHighlightingEnabled() {
        return this.linkHighlightingEnabled;
    }

    public void setLinkHighlightingEnabled(boolean linkHighlightingEnabled) {
        this.linkHighlightingEnabled = linkHighlightingEnabled;
        this.viewer.updateAllVisuals();
    }

    public boolean isInteractionAreaShadingEnabled() {
        return this.interactionAreaShadingEnabled;
    }

    public void setInteractionAreaShadingEnabled(boolean interactionAreaShadingEnabled) {
        this.interactionAreaShadingEnabled = interactionAreaShadingEnabled;
        this.viewer.updateAllVisuals();
    }

    public IndicatorType getIndicatorType() {
        return this.currentIndicatorType;
    }

    public void setIndicatorType(IndicatorType indicatorType) {
        this.currentIndicatorType = indicatorType;
        this.viewer.updateAllVisuals();
    }

    public void setIndicatorTypeToDefault() {
        this.setIndicatorType(this.defaultIndicatorType);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.viewer.updateAllVisuals();
    }

    public Color getIndicatorColor() {
        return this.indicatorColor;
    }

    public void setIndicatorColor(Color indicatorColor) {
        this.indicatorColor = indicatorColor;
        this.viewer.updateAllVisuals();
    }

    public double getIndicatorSize() {
        return this.indicatorSize;
    }

    public void setIndicatorSize(double indicatorSize) {
        this.indicatorSize = indicatorSize;
        this.viewer.updateAllVisuals();
    }

    public Dimension2D getIndicatorSpacing() {
        return this.indicatorSpacing;
    }

    public double getHorizontalSpacing() {
        return this.indicatorSpacing.getWidth();
    }

    public double getVerticalSpacing() {
        return this.indicatorSpacing.getHeight();
    }

    public void setIndicatorSpacing(Dimension2D indicatorSpacing) {
        this.indicatorSpacing = Objects.requireNonNull(indicatorSpacing);
        this.viewer.updateAllVisuals();
    }

    public boolean useSnapToGrid() {
        return this.useSnapToGrid;
    }

    public void setUseSnapToGrid(boolean useSnapToGrid) {
        this.useSnapToGrid = useSnapToGrid;
        this.viewer.updateAllVisuals();
    }

    public double snapToGridX(double x) {
        if (this.useSnapToGrid) {
            double width = this.indicatorSpacing.getWidth();
            return Math.floor(x / width) * width;
        }
        return x;
    }

    public double snapToGridY(double y) {
        if (this.useSnapToGrid) {
            double height = this.indicatorSpacing.getHeight();
            return Math.floor(y / height) * height;
        }
        return y;
    }

    public Point2D snapToGrid(Point2D point) {
        return this.snapToGrid(point.getX(), point.getY());
    }

    public Point2D snapToGrid(double x, double y) {
        return new Point2D(this.snapToGridX(x), this.snapToGridY(y));
    }

    public double snapToCenterX(double x) {
        double hs2 = this.indicatorSpacing.getWidth() / 2.0;
        return this.snapToGridX(x - hs2) + hs2;
    }

    public double snapToCenterY(double y) {
        double vs2 = this.indicatorSpacing.getHeight() / 2.0;
        return this.snapToGridY(y - vs2) + vs2;
    }

    public DiagramCoordinate snapToCenter(DiagramCoordinate point) {
        return this.snapToCenter(point.getX(), point.getY());
    }

    public DiagramCoordinate snapToCenter(double x, double y) {
        return new DiagramCoordinate(this.snapToCenterX(x), this.snapToCenterY(y));
    }

    public boolean isDrawOuterBorder() {
        return this.drawOuterBorder;
    }

    public void setDrawOuterBorder(boolean drawOuterBorder) {
        this.drawOuterBorder = drawOuterBorder;
        this.viewer.updateAllVisuals();
    }

    public double getMaximumSpacing() {
        return Math.max(this.getVerticalSpacing(), this.getHorizontalSpacing());
    }

    public String getHelpText() {
        return this.helpText;
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }

    public IndicatorType getDefaultIndicatorType() {
        return this.defaultIndicatorType;
    }

    public void setDefaultIndicatorType(IndicatorType defaultIndicatorType) {
        this.defaultIndicatorType = defaultIndicatorType;
    }

    public static enum IndicatorType {
        INVISIBLE,
        CIRCLE,
        CROSS,
        SQUARE;

    }
}

