/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef;

import java.util.Collections;
import java.util.List;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;

public final class DiagramViewerSelection {
    private final IMVCBundle primarySelection;
    private final List<IMVCBundle> secondarySelections;

    public DiagramViewerSelection(IMVCBundle primary) {
        this(primary, Collections.emptyList());
    }

    public DiagramViewerSelection(IMVCBundle primary, List<IMVCBundle> secondary) {
        this.primarySelection = primary;
        this.secondarySelections = Collections.unmodifiableList(secondary);
    }

    public IMVCBundle getPrimarySelection() {
        return this.primarySelection;
    }

    public List<IMVCBundle> getSecondarySelections() {
        return this.secondarySelections;
    }

    public boolean isEmpty() {
        return this.primarySelection == null && this.secondarySelections.isEmpty();
    }

    public boolean isMultiSelection() {
        return this.primarySelection != null && !this.secondarySelections.isEmpty();
    }

    public boolean isSelected(IMVCBundle bundle) {
        return this.primarySelection == bundle || this.secondarySelections.contains(bundle);
    }
}

