/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef;

import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;

public final class FeedbackChange {
    public static final FeedbackChange EMPTY = new FeedbackChange();
    private final double deltaX;
    private final double deltaY;
    private final double deltaW;
    private final double deltaH;

    public FeedbackChange(double dx, double dy, double dw, double dh) {
        this.deltaX = dx;
        this.deltaY = dy;
        this.deltaW = dw;
        this.deltaH = dh;
    }

    public FeedbackChange() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public double getDeltaX() {
        return this.deltaX;
    }

    public double getDeltaY() {
        return this.deltaY;
    }

    public double getDeltaW() {
        return this.deltaW;
    }

    public double getDeltaH() {
        return this.deltaH;
    }

    public boolean isEmpty() {
        return this.deltaX == 0.0 && this.deltaY == 0.0 && this.deltaW == 0.0 && this.deltaH == 0.0;
    }

    public Rectangle2D applyTo(Rectangle2D b) {
        return new Rectangle2D(b.getMinX() + this.deltaX, b.getMinY() + this.deltaY, b.getWidth() + this.deltaW, b.getHeight() + this.deltaH);
    }

    public Point2D applyToPoint(Point2D p) {
        return new Point2D(p.getX() + this.deltaX, p.getY() + this.deltaY);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.deltaX);
        sb.append(",").append(this.deltaY);
        sb.append(",").append(this.deltaW);
        sb.append(",").append(this.deltaH).append("]");
        return sb.toString();
    }

    public static FeedbackChange locationFeedbackChange(double dx, double dy) {
        return new FeedbackChange(dx, dy, 0.0, 0.0);
    }

    public static FeedbackChange sizeFeedbackChange(double dw, double dh) {
        return new FeedbackChange(0.0, 0.0, dw, dh);
    }
}

