/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef;

import java.util.Objects;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramLayers;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewer;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerFeatures;
import org.fortiss.tooling.common.ui.javafx.lwfxef.EDragGesture;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IVisual;

final class GridCanvasVisual
implements IVisual {
    private final DiagramViewer viewer;
    private final Pane pane;
    private final Canvas gridCanvas;
    private final Rectangle leftOuterBorder;
    private final Rectangle topOuterBorder;
    double width;
    double height;
    private GridParameters currentGridCanvasParameters = null;

    public GridCanvasVisual(DiagramViewer viewer) {
        this.viewer = viewer;
        this.pane = new Pane();
        this.gridCanvas = new Canvas();
        this.leftOuterBorder = new Rectangle();
        this.topOuterBorder = new Rectangle();
        this.pane.getChildren().addAll((Object[])new Node[]{this.gridCanvas, this.leftOuterBorder, this.topOuterBorder});
    }

    Node getGridNode() {
        return this.pane;
    }

    @Override
    public boolean enableInteraction() {
        return false;
    }

    @Override
    public boolean enableVisual() {
        return true;
    }

    @Override
    public IMVCBundle getMVCBundle() {
        return this.viewer.getDiagramBundle();
    }

    @Override
    public void updateNodes(DiagramLayers layers) {
        if (this.pane.getParent() == null) {
            this.viewer.getViewerPane().getChildren().add(0, (Object)this.pane);
            this.viewer.getLayers().getMouseState().registerMouseListeners((Node)this.pane, this.getMVCBundle());
        }
        this.updateContent();
    }

    @Override
    public void removeAllVisuals(DiagramLayers layers) {
        this.viewer.getLayers().getMouseState().unregisterMouseListeners((Node)this.pane);
        this.viewer.getViewerPane().getChildren().remove((Object)this.pane);
    }

    @Override
    public Rectangle2D getModelBounds() {
        Bounds b = this.pane.getBoundsInParent();
        return new Rectangle2D(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
    }

    @Override
    public DiagramCoordinate getLinkAnchorage(DiagramCoordinate indication) {
        DiagramViewerFeatures features = this.viewer.getFeatures();
        return indication.add(features.getHorizontalSpacing() / 2.0, features.getVerticalSpacing() / 2.0);
    }

    @Override
    public Rectangle2D getCurrentBounds() {
        return this.getModelBounds();
    }

    @Override
    public void requestFocus() {
        this.pane.requestFocus();
    }

    private double getZoomFactor() {
        Point2D unitVector = new Point2D(1.0, 1.0);
        Point2D transformedVector = this.viewer.getLayers().getLocalToParentTransform().deltaTransform(unitVector);
        return transformedVector.getX();
    }

    private GridOffset getGridOffset() {
        DiagramViewerFeatures features = this.viewer.getFeatures();
        Point2D p0 = this.viewer.getLayers().sceneToLocal(this.pane.localToScene(0.0, 0.0));
        GridOffset gridOffset = new GridOffset();
        gridOffset.gridX = (int)(p0.getX() / features.getHorizontalSpacing());
        gridOffset.gridY = (int)(p0.getY() / features.getVerticalSpacing());
        gridOffset.insets = new Point2D(p0.getX() / features.getHorizontalSpacing() % 1.0, p0.getY() / features.getVerticalSpacing() % 1.0);
        return gridOffset;
    }

    private void updateContent() {
        DiagramViewerFeatures features = this.viewer.getFeatures();
        GridParameters parameters = new GridParameters();
        parameters.hSpacing = features.getHorizontalSpacing();
        parameters.vSpacing = features.getVerticalSpacing();
        parameters.zoomFactor = this.getZoomFactor();
        parameters.indicatorType = features.getIndicatorType();
        parameters.backgroundColor = features.getBackgroundColor();
        parameters.indicatorColor = features.getIndicatorColor();
        parameters.indicatorSize = features.getIndicatorSize();
        this.paintCanvas(parameters);
        GridOffset gridOffset = this.getGridOffset();
        double zfhs = parameters.zoomFactor * parameters.hSpacing;
        double zfvs = parameters.zoomFactor * parameters.vSpacing;
        this.gridCanvas.relocate(-gridOffset.insets.getX() * zfhs, -gridOffset.insets.getY() * zfvs);
        this.pane.getChildren().removeAll((Object[])new Node[]{this.leftOuterBorder, this.topOuterBorder});
        if (features.isDrawOuterBorder()) {
            this.pane.getChildren().addAll((Object[])new Node[]{this.leftOuterBorder, this.topOuterBorder});
            this.leftOuterBorder.relocate(-((double)gridOffset.gridX + gridOffset.insets.getX()) * zfhs, 0.0);
            this.leftOuterBorder.setWidth(zfhs);
            this.leftOuterBorder.setHeight(this.height);
            this.leftOuterBorder.setStrokeWidth(0.0);
            this.leftOuterBorder.setFill((Paint)features.getIndicatorColor());
            this.topOuterBorder.relocate(0.0, -((double)gridOffset.gridY + gridOffset.insets.getY()) * zfhs);
            this.topOuterBorder.setWidth(this.width);
            this.topOuterBorder.setHeight(zfvs);
            this.topOuterBorder.setStrokeWidth(0.0);
            this.topOuterBorder.setFill((Paint)features.getIndicatorColor());
        }
    }

    private void paintCanvas(GridParameters parameters) {
        double targetCanvasWidth = this.width + parameters.zoomFactor * parameters.hSpacing;
        double targetCanvasHeight = this.height + parameters.zoomFactor * parameters.vSpacing;
        boolean resized = false;
        resized |= this.gridCanvas.getWidth() != targetCanvasWidth;
        if (resized |= this.gridCanvas.getHeight() != targetCanvasHeight) {
            this.gridCanvas.setWidth(targetCanvasWidth);
            this.gridCanvas.setHeight(targetCanvasHeight);
        }
        if (!resized && parameters.equals(this.currentGridCanvasParameters)) {
            return;
        }
        this.currentGridCanvasParameters = parameters;
        GraphicsContext gc = this.gridCanvas.getGraphicsContext2D();
        gc.setFill((Paint)parameters.backgroundColor);
        gc.setStroke((Paint)parameters.backgroundColor);
        gc.fillRect(0.0, 0.0, this.gridCanvas.getWidth(), this.gridCanvas.getHeight());
        DiagramViewerFeatures.IndicatorType indicatorType = parameters.indicatorType;
        if (indicatorType == DiagramViewerFeatures.IndicatorType.INVISIBLE) {
            return;
        }
        gc.setStroke((Paint)parameters.indicatorColor);
        gc.setFill((Paint)parameters.indicatorColor);
        double zfhs = parameters.zoomFactor * parameters.hSpacing;
        double zfvs = parameters.zoomFactor * parameters.vSpacing;
        double isize = parameters.indicatorSize * parameters.zoomFactor;
        double x = zfhs;
        while (x < this.gridCanvas.getWidth()) {
            double y = zfvs;
            while (y < this.gridCanvas.getHeight()) {
                this.drawIndicator(gc, Math.floor(x) + 0.5, Math.floor(y) + 0.5, isize, indicatorType);
                y += zfvs;
            }
            x += zfhs;
        }
    }

    private void drawIndicator(GraphicsContext gc, double x, double y, double size, DiagramViewerFeatures.IndicatorType indicatorType) {
        switch (indicatorType) {
            case CIRCLE: {
                this.drawCircle(gc, x, y, size);
                break;
            }
            case CROSS: {
                this.drawCross(gc, x, y, size);
                break;
            }
            case SQUARE: {
                this.drawSquare(gc, x, y, size);
                break;
            }
        }
    }

    private void drawCircle(GraphicsContext gc, double x, double y, double size) {
        gc.fillOval(x - size, y - size, 2.0 * size, 2.0 * size);
    }

    private void drawCross(GraphicsContext gc, double x, double y, double size) {
        gc.strokeLine(x - size, y, x + size, y);
        gc.strokeLine(x, y - size, x, y + size);
    }

    private void drawSquare(GraphicsContext gc, double x, double y, double size) {
        gc.fillRect(x - size, y - size, 2.0 * size, 2.0 * size);
    }

    @Override
    public EDragGesture getDragGesture(Node node, DiagramCoordinate diagramLocation) {
        if (node == this.pane) {
            return EDragGesture.SELECTION;
        }
        return EDragGesture.NONE;
    }

    public void setWidth(double w) {
        this.width = w;
        this.updateContent();
    }

    public void setHeight(double h) {
        this.height = h;
        this.updateContent();
    }

    private static class GridOffset {
        int gridX;
        int gridY;
        Point2D insets;

        private GridOffset() {
        }
    }

    private static class GridParameters {
        private double hSpacing;
        private double vSpacing;
        private double zoomFactor;
        private double indicatorSize;
        private DiagramViewerFeatures.IndicatorType indicatorType;
        private Color backgroundColor;
        private Color indicatorColor;

        private GridParameters() {
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.backgroundColor, this.hSpacing, this.indicatorColor, this.indicatorSize, this.indicatorType, this.vSpacing, this.zoomFactor});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GridParameters other = (GridParameters)obj;
            return Objects.equals(this.backgroundColor, other.backgroundColor) && Double.doubleToLongBits(this.hSpacing) == Double.doubleToLongBits(other.hSpacing) && Objects.equals(this.indicatorColor, other.indicatorColor) && Double.doubleToLongBits(this.indicatorSize) == Double.doubleToLongBits(other.indicatorSize) && this.indicatorType == other.indicatorType && Double.doubleToLongBits(this.vSpacing) == Double.doubleToLongBits(other.vSpacing) && Double.doubleToLongBits(this.zoomFactor) == Double.doubleToLongBits(other.zoomFactor);
        }
    }
}

