/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramLayers;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewer;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerDefaultTags;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerSelection;
import org.fortiss.tooling.common.ui.javafx.lwfxef.GridCanvasVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.change.Change;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IControllerFactory;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.IModelFactory;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundleWithParent;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IDiagramAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IDiagramMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.ILinkMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.impl.ContentAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.impl.ContentMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.impl.DiagramAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.impl.DiagramMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.impl.LinkMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IContentAnchorageVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IContentVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IDiagramAnchorageVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.ILinkVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IVisualFactory;

final class MVCBundleManager {
    private final DiagramViewer viewer;
    private final DiagramLayers layers;
    private final Consumer<DiagramViewerSelection> selectionChangedCallback;
    private final Consumer<Change> modelModifier;
    final IModelFactory modelFactory;
    final IVisualFactory visualFactory;
    final IControllerFactory controllerFactory;
    GridCanvasVisual gridCanvasVisual;
    Map<Object, IContentMVCBundle> contentBundles = new HashMap<Object, IContentMVCBundle>();
    Map<Object, IDiagramAnchorageMVCBundle> diagramAnchorageBundles = new HashMap<Object, IDiagramAnchorageMVCBundle>();
    Map<Object, IContentAnchorageMVCBundle> contentAnchorageBundles = new HashMap<Object, IContentAnchorageMVCBundle>();
    Map<Object, ILinkMVCBundle> linkBundles = new HashMap<Object, ILinkMVCBundle>();
    List<IMVCBundle> possibleLinkTargets = new ArrayList<IMVCBundle>();
    IDiagramMVCBundle diagramBundle;
    IMVCBundle primarySelectedBundle;
    List<IMVCBundle> secondarySelectedBundles = new LinkedList<IMVCBundle>();

    MVCBundleManager(DiagramViewer viewer, IModelFactory modelFactory, IVisualFactory visualFactory, IControllerFactory controllerFactory, DiagramLayers layers, Consumer<DiagramViewerSelection> selectionChangedCallback, Consumer<Change> modelModifier) {
        this.viewer = viewer;
        this.gridCanvasVisual = new GridCanvasVisual(viewer);
        this.modelFactory = modelFactory;
        this.visualFactory = visualFactory;
        this.controllerFactory = controllerFactory;
        this.layers = layers;
        this.selectionChangedCallback = selectionChangedCallback;
        this.modelModifier = modelModifier;
    }

    public Consumer<Change> getModelModifier() {
        return this.modelModifier;
    }

    void setSingleSelectedMVCBundle(IMVCBundle sel) {
        if (this.primarySelectedBundle == sel) {
            return;
        }
        for (IMVCBundle mvcb : this.secondarySelectedBundles) {
            mvcb.removeTag(DiagramViewerDefaultTags.SECONDARY_SELECTION_TAG);
            mvcb.getVisual().updateNodes(this.layers);
        }
        this.secondarySelectedBundles.clear();
        IMVCBundle oldSelection = this.primarySelectedBundle;
        if (oldSelection != null) {
            oldSelection.removeTag(DiagramViewerDefaultTags.FOCUS_TAG);
            oldSelection.removeTag(DiagramViewerDefaultTags.PRIMARY_SELECTION_TAG);
            oldSelection.getVisual().updateNodes(this.layers);
        }
        this.primarySelectedBundle = sel;
        if (this.primarySelectedBundle != null) {
            this.primarySelectedBundle.getVisual().requestFocus();
            this.primarySelectedBundle.addTag(DiagramViewerDefaultTags.FOCUS_TAG);
            this.primarySelectedBundle.addTag(DiagramViewerDefaultTags.PRIMARY_SELECTION_TAG);
            this.primarySelectedBundle.getVisual().updateNodes(this.layers);
        }
        this.fireSelectionChanged();
    }

    void addSelectedMVCBundle(IMVCBundle sel) {
        if (this.primarySelectedBundle == sel || this.secondarySelectedBundles.contains(sel)) {
            return;
        }
        if (this.primarySelectedBundle != null) {
            this.primarySelectedBundle.removeTag(DiagramViewerDefaultTags.PRIMARY_SELECTION_TAG);
            this.primarySelectedBundle.addTag(DiagramViewerDefaultTags.SECONDARY_SELECTION_TAG);
            this.secondarySelectedBundles.add(this.primarySelectedBundle);
            this.primarySelectedBundle.getVisual().updateNodes(this.layers);
        }
        this.primarySelectedBundle = sel;
        if (this.primarySelectedBundle != null) {
            this.primarySelectedBundle.addTag(DiagramViewerDefaultTags.PRIMARY_SELECTION_TAG);
            this.primarySelectedBundle.getVisual().updateNodes(this.layers);
        }
        this.fireSelectionChanged();
    }

    void removeSelectedMVCBundle(IMVCBundle sel) {
        if (this.primarySelectedBundle == sel) {
            sel.removeTag(DiagramViewerDefaultTags.PRIMARY_SELECTION_TAG);
            if (this.secondarySelectedBundles.isEmpty()) {
                this.primarySelectedBundle = null;
            } else {
                this.primarySelectedBundle = this.secondarySelectedBundles.remove(this.secondarySelectedBundles.size() - 1);
                this.primarySelectedBundle.removeTag(DiagramViewerDefaultTags.SECONDARY_SELECTION_TAG);
                this.primarySelectedBundle.addTag(DiagramViewerDefaultTags.PRIMARY_SELECTION_TAG);
                this.primarySelectedBundle.getVisual().updateNodes(this.layers);
            }
        } else {
            sel.removeTag(DiagramViewerDefaultTags.SECONDARY_SELECTION_TAG);
            this.secondarySelectedBundles.remove(sel);
        }
        sel.getVisual().updateNodes(this.layers);
        this.fireSelectionChanged();
    }

    private void fireSelectionChanged() {
        if (this.selectionChangedCallback != null) {
            this.selectionChangedCallback.accept(this.getSelection());
        }
    }

    void updateContentObjects() {
        Object oldSelection;
        this.possibleLinkTargets.clear();
        Object object = oldSelection = this.primarySelectedBundle != null ? this.primarySelectedBundle.getModel() : null;
        if (oldSelection == null) {
            this.setSingleSelectedMVCBundle(null);
        }
        this.modelFactory.update();
        HashMap<Object, IContentMVCBundle> newContentBundles = new HashMap<Object, IContentMVCBundle>();
        HashMap<Object, IDiagramAnchorageMVCBundle> newDiagramAnchorageBundles = new HashMap<Object, IDiagramAnchorageMVCBundle>();
        HashMap<Object, IContentAnchorageMVCBundle> newContentAnchorageBundles = new HashMap<Object, IContentAnchorageMVCBundle>();
        HashMap<Object, ILinkMVCBundle> newLinkBundles = new HashMap<Object, ILinkMVCBundle>();
        this.updateDiagramBundle();
        oldSelection = this.updateContentAndContentAnchorageBundles(oldSelection, newContentBundles, newContentAnchorageBundles);
        oldSelection = this.updateDiagramAnchorages(oldSelection, newDiagramAnchorageBundles);
        oldSelection = this.updateLinkBundles(oldSelection, newDiagramAnchorageBundles, newContentAnchorageBundles, newLinkBundles);
        if (oldSelection != null) {
            this.setSingleSelectedMVCBundle(this.diagramBundle);
        }
        this.detachAndRemoveRemainingMVCB();
        this.contentBundles = newContentBundles;
        this.diagramAnchorageBundles = newDiagramAnchorageBundles;
        this.contentAnchorageBundles = newContentAnchorageBundles;
        this.linkBundles = newLinkBundles;
        this.updateAllVisuals();
    }

    private Object updateLinkBundles(Object oldSelection, Map<Object, IDiagramAnchorageMVCBundle> newDiagramAnchorageBundles, Map<Object, IContentAnchorageMVCBundle> newContentAnchorageBundles, Map<Object, ILinkMVCBundle> newLinkBundles) {
        for (Object link : this.modelFactory.getLinkModels()) {
            ILinkMVCBundle bundle = this.linkBundles.remove(link);
            if (bundle == null) {
                bundle = this.initLinks(link, newDiagramAnchorageBundles, newContentAnchorageBundles);
            } else {
                this.reinitLinks(bundle, newDiagramAnchorageBundles, newContentAnchorageBundles);
            }
            newLinkBundles.put(link, bundle);
            if (link != oldSelection) continue;
            this.setSingleSelectedMVCBundle(bundle);
            oldSelection = null;
        }
        return oldSelection;
    }

    private Object updateDiagramAnchorages(Object oldSelection, Map<Object, IDiagramAnchorageMVCBundle> newDiagramAnchorageBundles) {
        for (Object m : this.modelFactory.getDiagramAnchorageModels()) {
            IDiagramAnchorageMVCBundle bundle = this.diagramAnchorageBundles.remove(m);
            if (bundle == null) {
                bundle = this.initDiagramAnchorages(m);
            }
            newDiagramAnchorageBundles.put(m, bundle);
            if (m == oldSelection) {
                this.setSingleSelectedMVCBundle(bundle);
                oldSelection = null;
            }
            if (!bundle.getController().isPossibleLinkTarget()) continue;
            this.possibleLinkTargets.add(bundle);
        }
        return oldSelection;
    }

    private void updateParentRelationship(Map<Object, IContentMVCBundle> newContentBundles, List<?> contentModels) {
        for (Object m : contentModels) {
            Object parentModel = this.modelFactory.getParent(m);
            if (parentModel == null) continue;
            IContentMVCBundle parentBundle = newContentBundles.get(parentModel);
            IContentMVCBundleWithParent elementBundle = (IContentMVCBundleWithParent)newContentBundles.get(m);
            if (elementBundle == null || parentBundle == null) continue;
            elementBundle.setParentBundle(parentBundle);
        }
    }

    private Object updateContentAndContentAnchorageBundles(Object oldSelection, Map<Object, IContentMVCBundle> newContentBundles, Map<Object, IContentAnchorageMVCBundle> newContentAnchorageBundles) {
        List<?> contentModels = this.modelFactory.getContentModels();
        for (Object m : contentModels) {
            IContentMVCBundle bundle = this.contentBundles.remove(m);
            if (bundle == null) {
                bundle = this.initContentBundle(m);
            }
            newContentBundles.put(m, bundle);
            if (m == oldSelection) {
                this.setSingleSelectedMVCBundle(bundle);
                oldSelection = null;
            }
            if (bundle.getController().isPossibleLinkTarget()) {
                this.possibleLinkTargets.add(bundle);
            }
            for (Object cElement : this.modelFactory.getContentAnchorageModels(m)) {
                IContentAnchorageMVCBundle cBundle = this.contentAnchorageBundles.remove(cElement);
                if (cBundle == null) {
                    cBundle = this.initSingleAttachedContentAnchorage(bundle, cElement);
                }
                newContentAnchorageBundles.put(cElement, cBundle);
                if (cElement == oldSelection) {
                    this.setSingleSelectedMVCBundle(cBundle);
                    oldSelection = null;
                }
                if (!cBundle.getController().isPossibleLinkTarget()) continue;
                this.possibleLinkTargets.add(cBundle);
            }
            bundle.getChildren().clear();
        }
        this.updateParentRelationship(newContentBundles, contentModels);
        return oldSelection;
    }

    private void updateDiagramBundle() {
        boolean attached = true;
        if (this.diagramBundle != null && this.diagramBundle.getModel() != this.modelFactory.getRootModel()) {
            this.gridCanvasVisual.removeAllVisuals(this.layers);
            this.diagramBundle.detach();
            this.diagramBundle.remove();
            this.gridCanvasVisual = null;
            this.diagramBundle = null;
        }
        if (this.diagramBundle == null) {
            this.diagramBundle = new DiagramMVCBundle(this.modelFactory.getRootModel(), this.viewer);
            this.gridCanvasVisual = new GridCanvasVisual(this.viewer);
            this.diagramBundle.setVisual(this.gridCanvasVisual);
            attached = false;
        }
        IController diagramController = this.controllerFactory.createDiagramController(this.diagramBundle);
        this.diagramBundle.setController(diagramController);
        if (!attached) {
            this.diagramBundle.attach();
        }
        if (diagramController.isPossibleLinkTarget()) {
            this.possibleLinkTargets.add(this.diagramBundle);
        }
    }

    private void detachAndRemoveRemainingMVCB() {
        for (ILinkMVCBundle iLinkMVCBundle : this.linkBundles.values()) {
            iLinkMVCBundle.getVisual().removeAllVisuals(this.layers);
            iLinkMVCBundle.detach();
            iLinkMVCBundle.remove();
        }
        for (IContentAnchorageMVCBundle iContentAnchorageMVCBundle : this.contentAnchorageBundles.values()) {
            iContentAnchorageMVCBundle.getVisual().removeAllVisuals(this.layers);
            iContentAnchorageMVCBundle.detach();
            iContentAnchorageMVCBundle.remove();
        }
        for (IDiagramAnchorageMVCBundle iDiagramAnchorageMVCBundle : this.diagramAnchorageBundles.values()) {
            iDiagramAnchorageMVCBundle.getVisual().removeAllVisuals(this.layers);
            iDiagramAnchorageMVCBundle.detach();
            iDiagramAnchorageMVCBundle.remove();
        }
        for (IContentMVCBundle iContentMVCBundle : this.contentBundles.values()) {
            iContentMVCBundle.getVisual().removeAllVisuals(this.layers);
            iContentMVCBundle.detach();
            iContentMVCBundle.remove();
        }
    }

    private IContentMVCBundle initContentBundle(Object m) {
        ContentMVCBundle mvcb = new ContentMVCBundle(m, this.diagramBundle, this.viewer);
        IContentVisual visual = this.visualFactory.createContentVisual(mvcb);
        mvcb.setVisual(visual);
        IController contentController = this.controllerFactory.createContentController(mvcb);
        mvcb.setController(contentController);
        mvcb.attach();
        return mvcb;
    }

    private DiagramAnchorageMVCBundle initDiagramAnchorages(Object m) {
        DiagramAnchorageMVCBundle mvcb = new DiagramAnchorageMVCBundle(m, this.diagramBundle, this.viewer);
        IDiagramAnchorageVisual visual = this.visualFactory.createDiagramAnchorageVisual(mvcb);
        mvcb.setVisual(visual);
        IController diagramAnchorageController = this.controllerFactory.createDiagramAnchorageController(mvcb);
        mvcb.setController(diagramAnchorageController);
        mvcb.attach();
        return mvcb;
    }

    void handleFocus(boolean focus, DiagramLayers layers) {
        if (this.primarySelectedBundle == null) {
            return;
        }
        if (focus) {
            this.primarySelectedBundle.addTag(DiagramViewerDefaultTags.FOCUS_TAG);
        } else {
            this.primarySelectedBundle.removeTag(DiagramViewerDefaultTags.FOCUS_TAG);
        }
        this.primarySelectedBundle.getVisual().updateNodes(layers);
    }

    private IContentAnchorageMVCBundle initSingleAttachedContentAnchorage(IContentMVCBundle pBundle, Object cElement) {
        ContentAnchorageMVCBundle cBundle = new ContentAnchorageMVCBundle(cElement, pBundle, this.viewer);
        IContentAnchorageVisual cVisual = this.visualFactory.createContentAnchorageVisual(cBundle);
        cBundle.setVisual(cVisual);
        IController contentAnchorageController = this.controllerFactory.createContentAnchorageController(cBundle);
        cBundle.setController(contentAnchorageController);
        cBundle.attach();
        return cBundle;
    }

    private ILinkMVCBundle initLinks(Object link, Map<Object, IDiagramAnchorageMVCBundle> diagramAnchorageBundles, Map<Object, IContentAnchorageMVCBundle> contentAnchorageBundles) {
        Object startModel = this.modelFactory.getLinkStart(link);
        if (startModel == null) {
            return null;
        }
        IAnchorageMVCBundle startBundle = this.getBundleForAnchorageModel(startModel, diagramAnchorageBundles, contentAnchorageBundles);
        Object endModel = this.modelFactory.getLinkEnd(link);
        if (endModel == null) {
            return null;
        }
        IAnchorageMVCBundle endBundle = this.getBundleForAnchorageModel(endModel, diagramAnchorageBundles, contentAnchorageBundles);
        LinkMVCBundle lBundle = new LinkMVCBundle(link, this.diagramBundle, startBundle, endBundle, this.viewer);
        ILinkVisual visual = this.visualFactory.createLinkVisual(lBundle);
        lBundle.setVisual(visual);
        IController linkController = this.controllerFactory.createLinkController(lBundle);
        lBundle.setController(linkController);
        lBundle.attach();
        if (linkController.isPossibleLinkTarget()) {
            this.possibleLinkTargets.add(lBundle);
        }
        return lBundle;
    }

    private void reinitLinks(ILinkMVCBundle linkBundle, Map<Object, IDiagramAnchorageMVCBundle> diagramAnchorageBundles, Map<Object, IContentAnchorageMVCBundle> contentAnchorageBundles) {
        Object link = linkBundle.getModel();
        Object startModel = this.modelFactory.getLinkStart(link);
        if (startModel == null) {
            throw new IllegalArgumentException("Link start model element cannot be null!");
        }
        IAnchorageMVCBundle startBundle = this.getBundleForAnchorageModel(startModel, diagramAnchorageBundles, contentAnchorageBundles);
        Object endModel = this.modelFactory.getLinkEnd(link);
        if (endModel == null) {
            throw new IllegalArgumentException("Link target model element cannot be null!");
        }
        IAnchorageMVCBundle endBundle = this.getBundleForAnchorageModel(endModel, diagramAnchorageBundles, contentAnchorageBundles);
        linkBundle.updateLinkBundle(startBundle, endBundle);
    }

    private IAnchorageMVCBundle getBundleForAnchorageModel(Object m, Map<Object, IDiagramAnchorageMVCBundle> diagramAnchorageBundles, Map<Object, IContentAnchorageMVCBundle> contentAnchorageBundles) {
        IAnchorageMVCBundle result = diagramAnchorageBundles.get(m);
        if (result != null) {
            return result;
        }
        result = contentAnchorageBundles.get(m);
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException("Anchorage node model is neither a diagram nor a content anchorage.");
    }

    void updateAllVisuals() {
        this.viewer.updateGridCanvasSize();
        this.gridCanvasVisual.updateNodes(this.layers);
        for (IContentMVCBundle iContentMVCBundle : this.contentBundles.values()) {
            if (iContentMVCBundle instanceof IContentMVCBundleWithParent) {
                IContentMVCBundleWithParent wp = (IContentMVCBundleWithParent)iContentMVCBundle;
                if (wp.getParentBundle() != null) continue;
                this.updateChildContentVisualsRecursively(iContentMVCBundle);
                continue;
            }
            this.updateChildContentVisualsRecursively(iContentMVCBundle);
        }
        for (IDiagramAnchorageMVCBundle iDiagramAnchorageMVCBundle : this.diagramAnchorageBundles.values()) {
            iDiagramAnchorageMVCBundle.getVisual().updateNodes(this.layers);
        }
        for (IContentAnchorageMVCBundle iContentAnchorageMVCBundle : this.contentAnchorageBundles.values()) {
            iContentAnchorageMVCBundle.getVisual().updateNodes(this.layers);
        }
        for (ILinkMVCBundle iLinkMVCBundle : this.linkBundles.values()) {
            iLinkMVCBundle.getVisual().updateNodes(this.layers);
        }
    }

    private void updateChildContentVisualsRecursively(IContentMVCBundle bundle) {
        bundle.getVisual().updateNodes(this.layers);
        for (IContentMVCBundle iContentMVCBundle : bundle.getChildren()) {
            this.updateChildContentVisualsRecursively(iContentMVCBundle);
        }
    }

    void updateVisual(IMVCBundle bundle) {
        if (bundle instanceof IContentMVCBundle) {
            this.updateContentVisual((IContentMVCBundle)bundle);
        } else if (bundle instanceof IAnchorageMVCBundle) {
            this.updateAnchorage((IAnchorageMVCBundle)bundle);
        } else if (bundle instanceof ILinkMVCBundle) {
            bundle.getVisual().updateNodes(this.layers);
        } else if (bundle instanceof IDiagramMVCBundle) {
            this.updateAllVisuals();
        }
    }

    void updateModelVisual(Object model) {
        if (this.contentBundles.containsKey(model)) {
            this.updateContentVisual(this.contentBundles.get(model));
        } else if (this.contentAnchorageBundles.containsKey(model)) {
            this.updateAnchorage(this.contentAnchorageBundles.get(model));
        } else if (this.diagramAnchorageBundles.containsKey(model)) {
            this.updateAnchorage(this.diagramAnchorageBundles.get(model));
        } else if (this.linkBundles.containsKey(model)) {
            this.linkBundles.get(model).getVisual().updateNodes(this.layers);
        } else if (this.diagramBundle.getModel() == model) {
            this.updateAllVisuals();
        }
    }

    private void updateContentVisual(IContentMVCBundle bundle) {
        bundle.getVisual().updateNodes(this.layers);
        for (IContentAnchorageMVCBundle iContentAnchorageMVCBundle : bundle.getAnchorages()) {
            this.updateAnchorage(iContentAnchorageMVCBundle);
        }
        for (IContentMVCBundle iContentMVCBundle : bundle.getChildren()) {
            this.updateContentVisual(iContentMVCBundle);
        }
    }

    private void updateAnchorage(IAnchorageMVCBundle bundle) {
        bundle.getVisual().updateNodes(this.layers);
        for (ILinkMVCBundle link : bundle.getIncomingLinks()) {
            link.getVisual().updateNodes(this.layers);
        }
        for (ILinkMVCBundle link : bundle.getOutgoingLinks()) {
            link.getVisual().updateNodes(this.layers);
        }
    }

    Object getRootModel() {
        return this.modelFactory.getRootModel();
    }

    public DiagramViewerSelection getSelection() {
        return new DiagramViewerSelection(this.primarySelectedBundle, this.secondarySelectedBundles);
    }

    public boolean isPrimarySelected(IMVCBundle bundle) {
        return this.primarySelectedBundle == bundle;
    }

    public boolean isSecondarySelected(IMVCBundle bundle) {
        return this.secondarySelectedBundles.contains(bundle);
    }

    public void handleCtrlSelectionOf(IMVCBundle sel) {
        if (this.primarySelectedBundle == sel || this.secondarySelectedBundles.contains(sel)) {
            this.removeSelectedMVCBundle(sel);
        } else {
            this.addSelectedMVCBundle(sel);
        }
    }

    public void selectAll() {
        this.secondarySelectedBundles.addAll(this.contentBundles.values());
        this.secondarySelectedBundles.addAll(this.diagramAnchorageBundles.values());
        this.secondarySelectedBundles.addAll(this.linkBundles.values());
        if (this.secondarySelectedBundles.isEmpty()) {
            if (this.primarySelectedBundle != null) {
                this.primarySelectedBundle.removeTag(DiagramViewerDefaultTags.PRIMARY_SELECTION_TAG);
            }
            this.primarySelectedBundle = null;
        } else {
            this.primarySelectedBundle = this.secondarySelectedBundles.remove(0);
            this.primarySelectedBundle.removeTag(DiagramViewerDefaultTags.SECONDARY_SELECTION_TAG);
            this.primarySelectedBundle.addTag(DiagramViewerDefaultTags.PRIMARY_SELECTION_TAG);
        }
        for (IMVCBundle s : this.secondarySelectedBundles) {
            s.removeTag(DiagramViewerDefaultTags.PRIMARY_SELECTION_TAG);
            s.addTag(DiagramViewerDefaultTags.SECONDARY_SELECTION_TAG);
        }
        this.updateAllVisuals();
        this.fireSelectionChanged();
    }
}

