/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef;

import java.util.HashMap;
import java.util.Map;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.DragEvent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewer;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerDefaultTags;
import org.fortiss.tooling.common.ui.javafx.lwfxef.EDragGesture;
import org.fortiss.tooling.common.ui.javafx.lwfxef.change.Change;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IClickController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IDragController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IKeyPressController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IContentAnchorageVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IContentVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IVisual;

public final class MouseState {
    private final DiagramViewer viewer;
    private final Map<Node, IMVCBundle> nodesToBundleMap = new HashMap<Node, IMVCBundle>();
    private MouseEvent lastMousePressedEvent = null;
    private DiagramCoordinate lastMouseLocation = new DiagramCoordinate(0.0, 0.0);
    private DiagramCoordinate dragStartLocation = null;
    private EventHandler<MouseEvent> mouseClickedHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (!MouseState.this.nodesToBundleMap.containsKey(event.getSource())) {
                return;
            }
            Node source = (Node)event.getSource();
            IMVCBundle bundle = MouseState.this.nodesToBundleMap.get(source);
            MouseState.this.lastMouseLocation = MouseState.this.viewer.convertEventToDiagramCoordinates(event.getX(), event.getY(), source);
            IClickController cc = bundle.getController().getClickController(source, MouseState.this.lastMouseLocation);
            if (cc != null) {
                Change chg = null;
                if (event.getButton() == MouseButton.SECONDARY) {
                    if (event.getClickCount() == 1) {
                        chg = cc.secondaryClick(event, source, MouseState.this.lastMouseLocation);
                    }
                } else if (event.getButton() == MouseButton.PRIMARY) {
                    if (event.getClickCount() == 1) {
                        chg = cc.singleClick(event, source, MouseState.this.lastMouseLocation);
                    } else if (event.getClickCount() == 2) {
                        chg = cc.doubleClick(event, source, MouseState.this.lastMouseLocation);
                    }
                }
                event.consume();
                if (chg != null) {
                    MouseState.this.viewer.getModelModifier().accept(chg);
                }
            }
        }
    };
    private IDragController dragController = null;
    private EventHandler<MouseEvent> mouseDragDetectedHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            Node source;
            double y;
            double x;
            if (!MouseState.this.nodesToBundleMap.containsKey(event.getSource())) {
                return;
            }
            event.consume();
            if (MouseState.this.lastMousePressedEvent != null) {
                x = MouseState.this.lastMousePressedEvent.getX();
                y = MouseState.this.lastMousePressedEvent.getY();
                source = (Node)MouseState.this.lastMousePressedEvent.getSource();
            } else {
                x = event.getX();
                y = event.getY();
                source = (Node)event.getSource();
            }
            IMVCBundle bundle = MouseState.this.nodesToBundleMap.get(source);
            IVisual visual = bundle.getVisual();
            MouseState.this.lastMouseLocation = MouseState.this.viewer.convertEventToDiagramCoordinates(x, y, source);
            EDragGesture edg = visual.getDragGesture(source, MouseState.this.lastMouseLocation);
            if (edg == EDragGesture.NONE) {
                return;
            }
            MouseState.this.dragController = MouseState.this.viewer.createDragController(bundle, edg, source, MouseState.this.lastMouseLocation);
            if (MouseState.this.dragController != null) {
                MouseState.this.dragController.dragStarted(bundle, source, MouseState.this.lastMouseLocation);
                source.startFullDrag();
            }
        }
    };
    private EventHandler<MouseEvent> mouseDragCompletedHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (!MouseState.this.nodesToBundleMap.containsKey(event.getSource())) {
                return;
            }
            if (MouseState.this.dragController == null) {
                return;
            }
            event.consume();
            Node source = (Node)event.getSource();
            IMVCBundle bundle = MouseState.this.nodesToBundleMap.get(source);
            MouseState.this.lastMouseLocation = MouseState.this.viewer.convertEventToDiagramCoordinates(event.getX(), event.getY(), source);
            Change chg = MouseState.this.dragController.dragCompleted(bundle, source, MouseState.this.lastMouseLocation);
            MouseState.this.dragController = null;
            if (chg != null) {
                MouseState.this.viewer.getModelModifier().accept(chg);
            }
        }
    };
    private EventHandler<MouseEvent> mouseDraggedHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (!MouseState.this.nodesToBundleMap.containsKey(event.getSource())) {
                return;
            }
            if (MouseState.this.dragController == null) {
                return;
            }
            event.consume();
            Node source = (Node)event.getSource();
            IMVCBundle bundle = MouseState.this.nodesToBundleMap.get(source);
            MouseState.this.lastMouseLocation = MouseState.this.viewer.convertEventToDiagramCoordinates(event.getX(), event.getY(), source);
            MouseState.this.dragController.dragInProgress(bundle, source, MouseState.this.lastMouseLocation);
        }
    };
    private EventHandler<MouseEvent> mouseReleasedHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (MouseState.this.lastMousePressedEvent != null && event.getButton() == MouseState.this.lastMousePressedEvent.getButton()) {
                MouseState.this.lastMousePressedEvent = null;
            }
            if (!MouseState.this.nodesToBundleMap.containsKey(event.getSource())) {
                return;
            }
            if (MouseState.this.dragController == null) {
                return;
            }
            event.consume();
            Node source = (Node)event.getSource();
            IMVCBundle bundle = MouseState.this.nodesToBundleMap.get(source);
            MouseState.this.lastMouseLocation = MouseState.this.viewer.convertEventToDiagramCoordinates(event.getX(), event.getY(), source);
            Change chg = MouseState.this.dragController.dragCompleted(bundle, source, MouseState.this.lastMouseLocation);
            MouseState.this.dragController = null;
            if (chg != null) {
                MouseState.this.viewer.getModelModifier().accept(chg);
            }
        }
    };
    private EventHandler<MouseEvent> mouseEnterExitHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (!MouseState.this.nodesToBundleMap.containsKey(event.getSource())) {
                return;
            }
            event.consume();
            Node source = (Node)event.getSource();
            IMVCBundle bundle = MouseState.this.nodesToBundleMap.get(source);
            if (event.getEventType() == MouseEvent.MOUSE_ENTERED) {
                bundle.addTag(DiagramViewerDefaultTags.HOVER_TAG);
                this.updateVisualsAfterHoverChange(bundle);
            } else if (event.getEventType() == MouseEvent.MOUSE_EXITED) {
                bundle.removeTag(DiagramViewerDefaultTags.HOVER_TAG);
                this.updateVisualsAfterHoverChange(bundle);
            }
            if (MouseState.this.dragController != null) {
                return;
            }
            MouseState.this.lastMouseLocation = MouseState.this.viewer.convertEventToDiagramCoordinates(event.getX(), event.getY(), source);
            IController ctrl = bundle.getController();
            if (ctrl != null) {
                Cursor cursor = ctrl.getCurrentCursor(source, MouseState.this.lastMouseLocation);
                source.setCursor(cursor);
            }
        }

        private void updateVisualsAfterHoverChange(IMVCBundle bundle) {
            IContentAnchorageMVCBundle anchorageBundle2;
            IContentAnchorageVisual anchorageVisual;
            MouseState.this.viewer.updateVisual(bundle);
            if (bundle instanceof IContentMVCBundle) {
                IContentMVCBundle contentBundle = (IContentMVCBundle)bundle;
                IContentVisual contentVisual = contentBundle.getVisual();
                if (contentVisual.updateAttachedAnchorageVisualsOnHover()) {
                    contentBundle.getAnchorages().stream().forEach(anchorageBundle -> MouseState.this.viewer.updateVisual((IMVCBundle)anchorageBundle));
                }
            } else if (bundle instanceof IContentAnchorageMVCBundle && (anchorageVisual = (anchorageBundle2 = (IContentAnchorageMVCBundle)bundle).getVisual()).updateSiblingAnchorageVisualsOnHover()) {
                IContentMVCBundle contentBundle = anchorageBundle2.getAttachedTo();
                contentBundle.getAnchorages().stream().filter(ab -> ab != anchorageBundle2).forEach(ab -> MouseState.this.viewer.updateVisual((IMVCBundle)ab));
            }
        }
    };
    private EventHandler<MouseEvent> mouseMotionHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (!MouseState.this.nodesToBundleMap.containsKey(event.getSource()) || MouseState.this.dragController != null) {
                return;
            }
            event.consume();
            Node source = (Node)event.getSource();
            IMVCBundle bundle = MouseState.this.nodesToBundleMap.get(source);
            IController ctrl = bundle.getController();
            MouseState.this.lastMouseLocation = MouseState.this.viewer.convertEventToDiagramCoordinates(event.getX(), event.getY(), source);
            if (ctrl != null) {
                Cursor cursor = ctrl.getCurrentCursor(source, MouseState.this.lastMouseLocation);
                source.setCursor(cursor);
            }
        }
    };
    private EventHandler<MouseEvent> mousePressedHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            MouseState.this.lastMousePressedEvent = event;
            MouseState.this.viewer.hideContextMenu();
            event.consume();
        }
    };
    private final EventHandler<KeyEvent> keyEventHandler = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            Change change;
            if (!MouseState.this.nodesToBundleMap.containsKey(event.getSource())) {
                return;
            }
            Node source = (Node)event.getSource();
            IMVCBundle bundle = MouseState.this.nodesToBundleMap.get(source);
            IKeyPressController kpc = MouseState.this.viewer.createKeyPressController(bundle, source, MouseState.this.lastMouseLocation);
            if (kpc != null && (change = kpc.keyEvent(event, bundle, source, MouseState.this.lastMouseLocation)) != null) {
                MouseState.this.viewer.getModelModifier().accept(change);
            }
        }
    };
    private final EventHandler<DragEvent> dragOverHandler = new EventHandler<DragEvent>(){

        public void handle(DragEvent event) {
            if (!MouseState.this.nodesToBundleMap.containsKey(event.getSource())) {
                return;
            }
            Node source = (Node)event.getSource();
            IMVCBundle bundle = MouseState.this.nodesToBundleMap.get(source);
            IController ctrl = bundle.getController();
            MouseState.this.lastMouseLocation = MouseState.this.viewer.convertEventToDiagramCoordinates(event.getX(), event.getY(), source);
            if (ctrl != null && ctrl.handleExternalDNDDragOver(event.getDragboard(), MouseState.this.lastMouseLocation)) {
                event.acceptTransferModes(TransferMode.ANY);
                event.consume();
            }
        }
    };
    private final EventHandler<DragEvent> dropHandler = new EventHandler<DragEvent>(){

        public void handle(DragEvent event) {
            if (!MouseState.this.nodesToBundleMap.containsKey(event.getSource())) {
                return;
            }
            Node source = (Node)event.getSource();
            IMVCBundle bundle = MouseState.this.nodesToBundleMap.get(source);
            IController ctrl = bundle.getController();
            MouseState.this.lastMouseLocation = MouseState.this.viewer.convertEventToDiagramCoordinates(event.getX(), event.getY(), source);
            if (ctrl != null && ctrl.handleExternalDNDDrop(event.getDragboard(), MouseState.this.lastMouseLocation)) {
                event.setDropCompleted(true);
                event.consume();
            }
        }
    };

    public MouseState(DiagramViewer viewer) {
        this.viewer = viewer;
    }

    void registerMouseListeners(Node node, IMVCBundle mvcb) {
        node.setOnMousePressed(this.mousePressedHandler);
        node.setOnMouseEntered(this.mouseEnterExitHandler);
        node.setOnMouseExited(this.mouseEnterExitHandler);
        node.setOnMouseClicked(this.mouseClickedHandler);
        node.setOnDragDetected(this.mouseDragDetectedHandler);
        node.setOnMouseDragged(this.mouseDraggedHandler);
        node.setOnMouseDragOver(this.mouseDraggedHandler);
        node.setOnMouseReleased(this.mouseReleasedHandler);
        node.setOnMouseDragReleased(this.mouseDragCompletedHandler);
        node.setOnMouseMoved(this.mouseMotionHandler);
        node.setOnKeyReleased(this.keyEventHandler);
        node.setOnDragOver(this.dragOverHandler);
        node.setOnDragDropped(this.dropHandler);
        this.nodesToBundleMap.put(node, mvcb);
    }

    void unregisterMouseListeners(Node node) {
        node.setOnDragDropped(null);
        node.setOnDragOver(null);
        node.setOnKeyReleased(null);
        node.setOnMouseMoved(null);
        node.setOnMouseDragReleased(null);
        node.setOnMouseReleased(null);
        node.setOnMouseDragOver(null);
        node.setOnMouseDragged(null);
        node.setOnDragDetected(null);
        node.setOnMouseClicked(null);
        node.setOnMouseExited(null);
        node.setOnMouseEntered(null);
        node.setOnMousePressed(null);
        this.nodesToBundleMap.remove(node);
    }

    public DiagramCoordinate getLastMouseLocation() {
        return this.lastMouseLocation;
    }

    public DiagramCoordinate getDragStartLocation() {
        return this.dragStartLocation;
    }

    public DiagramCoordinate getDragExtent() {
        if (this.dragStartLocation == null || this.lastMouseLocation == null) {
            return null;
        }
        return this.lastMouseLocation.subtract(this.dragStartLocation);
    }
}

