/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef;

import java.util.List;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurve;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.QuadCurve;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.text.Text;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewer;

final class SVGExporter {
    private final Pane diagramNode;
    private double width = 0.0;
    private double height = 0.0;

    public SVGExporter(DiagramViewer viewer) {
        this.diagramNode = (Pane)viewer.getVisualNode().getChildren().get(0);
    }

    public String export() {
        this.height = 0.0;
        this.width = 0.0;
        StringBuilder content = new StringBuilder();
        for (Node n : this.diagramNode.getChildrenUnmodifiable()) {
            this.transform(n, content);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" standalone=\"no\"?>\n");
        sb.append("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" ");
        sb.append("\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n");
        sb.append("<svg ");
        SVGExporter.setProp("width", this.width, sb);
        SVGExporter.setProp("height", this.height, sb);
        SVGExporter.setProp("version", "1.1", sb);
        SVGExporter.setProp("xmlns", "http://www.w3.org/2000/svg", sb);
        SVGExporter.setProp("xmlns:xlink", "http://www.w3.org/1999/xlink", sb);
        sb.append(">\n");
        sb.append((CharSequence)content);
        sb.append("</svg>\n");
        return sb.toString();
    }

    private void transform(Node node, StringBuilder sb) {
        Bounds b = node.getBoundsInParent();
        if (b.getMaxX() > this.width) {
            this.width = b.getMaxX();
        }
        if (b.getMaxY() > this.height) {
            this.height = b.getMaxY();
        }
        if (node instanceof Region) {
            this.transform((Region)node, sb);
        } else if (node instanceof Group) {
            this.transform((Group)node, sb);
        } else if (node instanceof Rectangle) {
            this.transform((Rectangle)node, sb);
        } else if (node instanceof Ellipse) {
            this.transform((Ellipse)node, sb);
        } else if (node instanceof Circle) {
            this.transform((Circle)node, sb);
        } else if (node instanceof QuadCurve) {
            this.transform((QuadCurve)node, sb);
        } else if (node instanceof CubicCurve) {
            this.transform((CubicCurve)node, sb);
        } else if (node instanceof Line) {
            this.transform((Line)node, sb);
        } else if (node instanceof Text) {
            this.transform((Text)node, sb);
        } else if (node instanceof Path) {
            this.transform((Path)node, sb);
        }
    }

    private static void writePath(StringBuilder sb, String op, double ... coords) {
        sb.append(op).append(' ');
        double[] dArray = coords;
        int n = coords.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            sb.append(d).append(' ');
            ++n2;
        }
    }

    private void transform(CubicCurve curve, StringBuilder sb) {
        StyleHelper st = new StyleHelper((Shape)curve);
        if (st.isTransparent()) {
            return;
        }
        StringBuilder db = new StringBuilder();
        db.append("M ").append(curve.getStartX()).append(' ').append(curve.getStartY()).append(' ');
        db.append("C ").append(curve.getControlX1()).append(' ').append(curve.getControlY1()).append(' ');
        db.append(curve.getControlX2()).append(' ').append(curve.getControlY2()).append(' ');
        db.append(curve.getEndX()).append(' ').append(curve.getEndY());
        sb.append("<path ");
        SVGExporter.setProp("d", db.toString(), sb);
        st.applySVGStyle(sb);
        sb.append("/>\n");
    }

    private void transform(QuadCurve curve, StringBuilder sb) {
        StyleHelper st = new StyleHelper((Shape)curve);
        if (st.isTransparent()) {
            return;
        }
        StringBuilder db = new StringBuilder();
        db.append("M ").append(curve.getStartX()).append(' ').append(curve.getStartY()).append(' ');
        db.append("Q ").append(curve.getControlX()).append(' ').append(curve.getControlY()).append(' ');
        db.append(curve.getEndX()).append(' ').append(curve.getEndY());
        sb.append("<path ");
        SVGExporter.setProp("d", db.toString(), sb);
        st.applySVGStyle(sb);
        sb.append("/>\n");
    }

    private static String convertPathToD(Path path) {
        StringBuilder db = new StringBuilder();
        for (PathElement pe : path.getElements()) {
            if (pe instanceof MoveTo) {
                MoveTo mt = (MoveTo)pe;
                SVGExporter.writePath(db, "M", mt.getX(), mt.getY());
                continue;
            }
            if (pe instanceof LineTo) {
                LineTo lt = (LineTo)pe;
                SVGExporter.writePath(db, "L", lt.getX(), lt.getY());
                continue;
            }
            if (pe instanceof QuadCurveTo) {
                QuadCurveTo qc = (QuadCurveTo)pe;
                SVGExporter.writePath(db, "Q", qc.getControlX(), qc.getControlY(), qc.getX(), qc.getY());
                continue;
            }
            if (pe instanceof CubicCurveTo) {
                CubicCurveTo cc = (CubicCurveTo)pe;
                SVGExporter.writePath(db, "C", cc.getControlX1(), cc.getControlY1(), cc.getControlX2(), cc.getControlY2(), cc.getX(), cc.getY());
                continue;
            }
            if (!(pe instanceof ClosePath)) continue;
            SVGExporter.writePath(db, "Z", new double[0]);
        }
        return db.toString();
    }

    private void transform(Path path, StringBuilder sb) {
        StyleHelper st = new StyleHelper((Shape)path);
        if (st.isTransparent()) {
            return;
        }
        sb.append("<path ");
        SVGExporter.setProp("d", SVGExporter.convertPathToD(path), sb);
        st.applySVGStyle(sb);
        sb.append("/>\n");
    }

    private void transform(Text text, StringBuilder sb) {
        StyleHelper st = new StyleHelper((Shape)text);
        if (st.isTransparent()) {
            return;
        }
        sb.append("<text ");
        double yBaselineOffsetFromTop = text.getBoundsInParent().getHeight() - text.getBaselineOffset();
        SVGExporter.setProp("x", text.getX(), sb);
        SVGExporter.setProp("y", text.getY() + yBaselineOffsetFromTop, sb);
        SVGExporter.setProp("font-size", text.getFont().getSize(), sb);
        SVGExporter.setProp("font-family", text.getFont().getName() + ", Arial, Helvetica, sans-serif", sb);
        st.applySVGStyle(sb);
        sb.append(">\n");
        sb.append(text.getText());
        sb.append("</text>\n");
    }

    private void transform(Line line, StringBuilder sb) {
        StyleHelper st = new StyleHelper((Shape)line);
        if (st.isTransparent()) {
            return;
        }
        sb.append("<line ");
        SVGExporter.setProp("x1", line.getStartX(), sb);
        SVGExporter.setProp("y1", line.getStartY(), sb);
        SVGExporter.setProp("x2", line.getEndX(), sb);
        SVGExporter.setProp("y2", line.getEndY(), sb);
        st.applySVGStyle(sb);
        sb.append("/>\n");
    }

    private void transform(Circle circ, StringBuilder sb) {
        StyleHelper st = new StyleHelper((Shape)circ);
        if (st.isTransparent()) {
            return;
        }
        sb.append("<circle ");
        SVGExporter.setProp("cx", circ.getCenterX(), sb);
        SVGExporter.setProp("cy", circ.getCenterY(), sb);
        SVGExporter.setProp("r", circ.getRadius(), sb);
        st.applySVGStyle(sb);
        sb.append("/>\n");
    }

    private void transform(Ellipse ell, StringBuilder sb) {
        StyleHelper st = new StyleHelper((Shape)ell);
        if (st.isTransparent()) {
            return;
        }
        sb.append("<ellipse ");
        SVGExporter.setProp("cx", ell.getCenterX(), sb);
        SVGExporter.setProp("cy", ell.getCenterY(), sb);
        SVGExporter.setProp("rx", ell.getRadiusX(), sb);
        SVGExporter.setProp("ry", ell.getRadiusY(), sb);
        st.applySVGStyle(sb);
        sb.append("/>\n");
    }

    private void transform(Rectangle rect, StringBuilder sb) {
        StyleHelper st = new StyleHelper((Shape)rect);
        if (st.isTransparent()) {
            return;
        }
        sb.append("<rect ");
        SVGExporter.setProp("x", rect.getX(), sb);
        SVGExporter.setProp("y", rect.getY(), sb);
        SVGExporter.setProp("rx", rect.getArcWidth(), sb);
        SVGExporter.setProp("ry", rect.getArcHeight(), sb);
        SVGExporter.setProp("width", rect.getWidth(), sb);
        SVGExporter.setProp("height", rect.getHeight(), sb);
        st.applySVGStyle(sb);
        sb.append("/>\n");
    }

    private void transform(Group g, StringBuilder sb) {
        this.transformToG(null, (List<Node>)g.getChildrenUnmodifiable(), sb);
    }

    private void transformToG(String transform, List<Node> children, StringBuilder sb) {
        sb.append("<g ");
        if (transform != null) {
            sb.append("transform=\"").append(transform).append("\" ");
        }
        sb.append(">\n");
        for (Node n : children) {
            if (!n.isVisible()) continue;
            this.transform(n, sb);
        }
        sb.append("</g>\n");
    }

    private void transform(Region r, StringBuilder sb) {
        Bounds b = r.getBoundsInParent();
        String transform = "translate(" + b.getMinX() + "," + b.getMinY() + ")";
        this.transformToG(transform, (List<Node>)r.getChildrenUnmodifiable(), sb);
    }

    private static void setProp(String prop, String value, StringBuilder sb) {
        sb.append(prop).append("=\"").append(value).append("\" ");
    }

    private static void setProp(String prop, double value, StringBuilder sb) {
        sb.append(prop).append("=\"").append(value).append("\" ");
    }

    private static class StyleHelper {
        private String fill;
        private double fillAlpha;
        private String stroke;
        private double strokeAlpha;
        private double strokeWidth;

        public StyleHelper(Paint back, Paint fore, double sw) {
            this.fill = StyleHelper.rgbHex(back);
            this.fillAlpha = StyleHelper.alpha(back);
            this.stroke = StyleHelper.rgbHex(fore);
            this.strokeAlpha = StyleHelper.alpha(fore);
            this.strokeWidth = sw;
        }

        public StyleHelper(Shape shape) {
            this(shape.getFill(), shape.getStroke(), shape.getStrokeWidth());
        }

        public void applySVGStyle(StringBuilder sb) {
            SVGExporter.setProp("fill", this.fill != null ? this.fill : "none", sb);
            SVGExporter.setProp("fill-opacity", this.fillAlpha, sb);
            SVGExporter.setProp("stroke", this.stroke != null ? this.stroke : "none", sb);
            SVGExporter.setProp("stroke-width", this.strokeWidth, sb);
            SVGExporter.setProp("stroke-opacity", this.strokeAlpha, sb);
        }

        public boolean isTransparent() {
            return this.fill == null && this.stroke == null || this.fillAlpha == 0.0 && this.strokeAlpha == 0.0;
        }

        private static String rgbHex(Paint p) {
            if (p instanceof Color) {
                Color c = (Color)p;
                int r = (int)(c.getRed() * 255.0);
                int g = (int)(c.getGreen() * 255.0);
                int b = (int)(c.getBlue() * 255.0);
                return String.format("#%02X%02X%02X", r, g, b);
            }
            return null;
        }

        private static double alpha(Paint p) {
            if (p instanceof Color) {
                return ((Color)p).getOpacity();
            }
            return 0.0;
        }
    }
}

