/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base;

import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.FeedbackChange;
import org.fortiss.tooling.common.ui.javafx.lwfxef.change.Change;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.DragControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;

public abstract class ContentAnchorageMoveControllerBase
extends DragControllerBase {
    protected final IContentAnchorageMVCBundle anchorage;

    public ContentAnchorageMoveControllerBase(IContentAnchorageMVCBundle anchorage) {
        this.anchorage = anchorage;
    }

    protected abstract Point2D getAnchorageFeedbackLocation(DiagramCoordinate var1);

    protected abstract void moveAnchorage(DiagramCoordinate var1);

    @Override
    public final void safeDragInProgress(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
        DiagramCoordinate delta = diagramLocation.subtract(this.startDiagramLocation);
        Point2D c = this.getAnchorageFeedbackLocation(delta);
        Rectangle2D anchorageBounds = this.anchorage.getVisual().getModelBounds();
        FeedbackChange change = new FeedbackChange(c.getX() - anchorageBounds.getMinX(), c.getY() - anchorageBounds.getMinY(), 0.0, 0.0);
        this.anchorage.setFeedbackChange(change);
    }

    @Override
    public final Change safeDragCompleted(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
        DiagramCoordinate delta = diagramLocation.subtract(this.startDiagramLocation);
        this.anchorage.setFeedbackChange(FeedbackChange.EMPTY);
        bundle.getViewer().updateVisual(bundle);
        return () -> this.moveAnchorage(delta);
    }
}

