/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base;

import java.util.Collections;
import java.util.List;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewer;
import org.fortiss.tooling.common.ui.javafx.lwfxef.EDragGesture;
import org.fortiss.tooling.common.ui.javafx.lwfxef.change.Change;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IClickController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IDragController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IKeyPressController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.ClickControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.DragControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.IModelChangeProvider;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.ILinkMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.MVCBundleTag;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.impl.MVCBundlePartBase;

public abstract class ControllerBase
extends MVCBundlePartBase
implements IController {
    private final IDragController defaultLinkController = new DragControllerBase(){

        @Override
        public void safeDragStarted(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
            diagramLocation = ControllerBase.this.getVisual().getLinkAnchorage(diagramLocation);
            ControllerBase.this.getViewer().startNewLinkLineFeedback(bundle, node, diagramLocation);
        }

        @Override
        protected void safeDragInProgress(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
            diagramLocation = bundle.getVisual().getLinkAnchorage(diagramLocation);
            ControllerBase.this.getViewer().updateNewLinkLineFeedback(diagramLocation, ControllerBase.this.newLinkFeedback(ControllerBase.this.getMVCBundle(), this.startDiagramLocation, bundle, diagramLocation));
        }

        @Override
        protected Change safeDragCompleted(IMVCBundle endBundle, Node node, DiagramCoordinate endDiagramLocation) {
            IMVCBundle startBundle = ControllerBase.this.getMVCBundle();
            ControllerBase.this.getViewer().terminateNewLinkLineFeedback();
            if (ControllerBase.this.canLink(startBundle, this.startDiagramLocation, endBundle, endDiagramLocation)) {
                DiagramCoordinate startDiagramLocation_ = this.startDiagramLocation;
                return () -> ControllerBase.this.link(startBundle, startDiagramLocation_, endBundle, endDiagramLocation);
            }
            return null;
        }
    };
    private final IKeyPressController defaultKeyPressController = new IKeyPressController(){

        @Override
        public Change keyEvent(KeyEvent event, IMVCBundle bundle, Node source, DiagramCoordinate mouseLocation) {
            DiagramViewer viewer = ControllerBase.this.getViewer();
            KeyCode code = event.getCode();
            if (code == KeyCode.DELETE) {
                return new Change(){

                    @Override
                    public void applyChange() {
                        ControllerBase.this.delete();
                    }
                };
            }
            if (code == KeyCode.A && event.isControlDown()) {
                viewer.selectAll();
            }
            return null;
        }
    };

    public ControllerBase(IMVCBundle mvcb) {
        super(mvcb);
    }

    @Override
    public boolean selectOnMousePress() {
        return true;
    }

    @Override
    public boolean selectOnCtrlMousePress() {
        return true;
    }

    @Override
    public List<MenuItem> contextMenuContributions(Node node, DiagramCoordinate diagramLocation) {
        return Collections.emptyList();
    }

    @Override
    public IClickController getClickController(Node node, DiagramCoordinate diagramLocation) {
        return new ClickControllerBase(){

            @Override
            public Change singleClick(MouseEvent event, Node node, DiagramCoordinate diagramLocation) {
                if (!ControllerBase.this.selectOnClick()) {
                    return null;
                }
                if (event.isControlDown() && ControllerBase.this.selectOnCtrlMousePress()) {
                    ControllerBase.this.getViewer().handleCtrlSelectionOf(ControllerBase.this.getMVCBundle());
                } else {
                    ControllerBase.this.getViewer().setSingleSelectedMVCBundle(ControllerBase.this.getMVCBundle());
                }
                return null;
            }

            @Override
            public Change secondaryClick(MouseEvent event, Node node, DiagramCoordinate diagramLocation) {
                DiagramViewer viewer = ControllerBase.this.getViewer();
                if (ControllerBase.this.selectOnClick()) {
                    viewer.setSingleSelectedMVCBundle(ControllerBase.this.getMVCBundle());
                }
                if (event.isControlDown()) {
                    return () -> ControllerBase.this.delete();
                }
                viewer.showContextMenu(node, diagramLocation, ControllerBase.this.getMVCBundle());
                return null;
            }
        };
    }

    protected boolean selectOnClick() {
        return true;
    }

    @Override
    public boolean handleExternalDNDDragOver(Dragboard db, DiagramCoordinate diagramLocation) {
        return false;
    }

    @Override
    public boolean handleExternalDNDDrop(Dragboard db, DiagramCoordinate diagramLocation) {
        return false;
    }

    @Override
    public IDragController getDragController(EDragGesture gesture, Node node, DiagramCoordinate diagramLocation) {
        if (this.allowLink() && gesture == EDragGesture.NEW_LINK) {
            return this.getLinkCreationController();
        }
        return null;
    }

    protected boolean allowLink() {
        return true;
    }

    protected IDragController getLinkCreationController() {
        return this.defaultLinkController;
    }

    protected boolean canLink(IMVCBundle startBundle, DiagramCoordinate startLocation, IMVCBundle endBundle, DiagramCoordinate endLocation) {
        return true;
    }

    protected void link(IMVCBundle startBundle, DiagramCoordinate startLocation, IMVCBundle endBundle, DiagramCoordinate endLocation) {
    }

    protected Paint newLinkFeedback(IMVCBundle startBundle, DiagramCoordinate startLocation, IMVCBundle endBundle, DiagramCoordinate endLocation) {
        return Color.BLACK;
    }

    @Override
    public boolean isPossibleLinkTarget() {
        return false;
    }

    @Override
    public MVCBundleTag getLinkTargetEffectForNewLinkFrom(IMVCBundle linkStartBundle) {
        return null;
    }

    @Override
    public MVCBundleTag getLinkTargetEffectForMoveLink(ILinkMVCBundle linkBundle, IAnchorageMVCBundle movedAnchorageBundle) {
        return null;
    }

    @Override
    public void delete() {
    }

    @Override
    public IKeyPressController getKeyPressController(Node node, DiagramCoordinate lastMouseLocation) {
        return this.defaultKeyPressController;
    }

    @Override
    public Cursor getCurrentCursor(Node node, DiagramCoordinate diagramLocation) {
        EDragGesture edg = this.getVisual().getDragGesture(node, diagramLocation);
        switch (edg) {
            case NEW_LINK: {
                return this.allowLink() ? Cursor.CROSSHAIR : Cursor.DEFAULT;
            }
        }
        return Cursor.DEFAULT;
    }

    @Override
    public IModelChangeProvider getModelChangeProvider() {
        return null;
    }
}

