/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base;

import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerFeatures;
import org.fortiss.tooling.common.ui.javafx.lwfxef.EDragGesture;
import org.fortiss.tooling.common.ui.javafx.lwfxef.change.Change;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IClickController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IDragController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.ControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.DragControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;

public class DefaultDiagramController
extends ControllerBase {
    private boolean ignoreNextMouseClick = false;
    private final IDragController dragSelectionRectangleController = new DragControllerBase(){

        @Override
        protected void safeDragStarted(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
            DefaultDiagramController.this.getViewer().startSelectionFeedback(node, diagramLocation);
            DefaultDiagramController.this.ignoreNextMouseClick = true;
        }

        @Override
        protected void safeDragInProgress(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
            DefaultDiagramController.this.getViewer().updateSelectionFeedback(node, diagramLocation);
        }

        @Override
        protected Change safeDragCompleted(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
            DefaultDiagramController.this.getViewer().terminateSelectionFeedback(node, diagramLocation);
            return null;
        }
    };

    public DefaultDiagramController(IMVCBundle mvcb) {
        super(mvcb);
    }

    private MenuItem createLinkHighlightingMenuItem(DiagramViewerFeatures features) {
        MenuItem linkHighLightingMenuItem;
        if (features.isLinkHighlightingEnabled()) {
            linkHighLightingMenuItem = new MenuItem("Disable Link Highlighting");
            linkHighLightingMenuItem.setOnAction(evt -> features.setLinkHighlightingEnabled(false));
        } else {
            linkHighLightingMenuItem = new MenuItem("Enable Link Highlighting");
            linkHighLightingMenuItem.setOnAction(evt -> features.setLinkHighlightingEnabled(true));
        }
        return linkHighLightingMenuItem;
    }

    private MenuItem createInteractionAreaShadingMenuItem(DiagramViewerFeatures features) {
        MenuItem interactionAreaShadingMenuItem;
        if (features.isInteractionAreaShadingEnabled()) {
            interactionAreaShadingMenuItem = new MenuItem("Disable Interactive Area Shading");
            interactionAreaShadingMenuItem.setOnAction(evt -> features.setInteractionAreaShadingEnabled(false));
        } else {
            interactionAreaShadingMenuItem = new MenuItem("Enable Interactive Area Shading");
            interactionAreaShadingMenuItem.setOnAction(evt -> features.setInteractionAreaShadingEnabled(true));
        }
        return interactionAreaShadingMenuItem;
    }

    private MenuItem createGridMenuItem(DiagramViewerFeatures features) {
        MenuItem gridMenuItem = null;
        if (features.getIndicatorType() == DiagramViewerFeatures.IndicatorType.INVISIBLE) {
            gridMenuItem = new MenuItem("Show Grid");
            gridMenuItem.setOnAction(evt -> features.setIndicatorTypeToDefault());
        } else {
            gridMenuItem = new MenuItem("Hide Grid");
            gridMenuItem.setOnAction(evt -> features.setIndicatorType(DiagramViewerFeatures.IndicatorType.INVISIBLE));
        }
        return gridMenuItem;
    }

    private MenuItem createZoomInMenuItem(DiagramViewerFeatures features) {
        MenuItem zoomInMenuItem = new MenuItem("Zoom in");
        zoomInMenuItem.setOnAction(evt -> features.zoomIn());
        return zoomInMenuItem;
    }

    private MenuItem createZoomOutMenuItem(DiagramViewerFeatures features) {
        MenuItem zoomOutMenuItem = new MenuItem("Zoom out");
        zoomOutMenuItem.setOnAction(evt -> features.zoomOut());
        return zoomOutMenuItem;
    }

    private MenuItem createZoomFactorMenuItem(DiagramViewerFeatures features, int zoomFactorIndex, String prefix) {
        MenuItem zoomFactorMenuItem = null;
        if (zoomFactorIndex >= 0 && zoomFactorIndex < features.getZoomFactors().length) {
            double zoomFactor = features.getZoomFactors()[zoomFactorIndex];
            zoomFactorMenuItem = new MenuItem(prefix + zoomFactor * 100.0 + " %");
            zoomFactorMenuItem.setOnAction(evt -> features.setZoomFactorIndex(zoomFactorIndex));
        }
        return zoomFactorMenuItem;
    }

    @Override
    public List<MenuItem> contextMenuContributions(Node node, DiagramCoordinate diagramLocation) {
        ArrayList<MenuItem> rval = new ArrayList<MenuItem>();
        Menu gridMenu = new Menu("Display ...");
        ObservableList gridMenuItems = gridMenu.getItems();
        DiagramViewerFeatures features = this.getViewer().getFeatures();
        gridMenuItems.add((Object)this.createLinkHighlightingMenuItem(features));
        gridMenuItems.add((Object)this.createInteractionAreaShadingMenuItem(features));
        MenuItem gridMenuItem = this.createGridMenuItem(features);
        if (gridMenuItem != null) {
            gridMenuItems.add((Object)gridMenuItem);
        }
        rval.add((MenuItem)gridMenu);
        Menu zoomMenu = new Menu("Zoom ...");
        ObservableList zoomMenuItems = zoomMenu.getItems();
        double[] zoomFactors = features.getZoomFactors();
        int normalZoomIndex = -1;
        int i = 0;
        while (i < zoomFactors.length) {
            MenuItem zoomFactorMenuItem = this.createZoomFactorMenuItem(features, i, "");
            if (zoomFactorMenuItem != null) {
                zoomMenuItems.add((Object)zoomFactorMenuItem);
            }
            if (zoomFactors[i] == 1.0) {
                normalZoomIndex = i;
            }
            ++i;
        }
        rval.add(this.createZoomInMenuItem(features));
        rval.add(this.createZoomOutMenuItem(features));
        if (normalZoomIndex != -1) {
            rval.add(this.createZoomFactorMenuItem(features, normalZoomIndex, "Zoom "));
        }
        rval.add((MenuItem)zoomMenu);
        return rval;
    }

    @Override
    public IDragController getDragController(EDragGesture gesture, Node node, DiagramCoordinate diagramLocation) {
        if (gesture == EDragGesture.SELECTION) {
            return this.dragSelectionRectangleController;
        }
        return super.getDragController(gesture, node, diagramLocation);
    }

    @Override
    public IClickController getClickController(Node node, DiagramCoordinate diagramLocation) {
        if (this.ignoreNextMouseClick) {
            this.ignoreNextMouseClick = false;
            return null;
        }
        return super.getClickController(node, diagramLocation);
    }
}

